/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.impl;

import com.atlassian.fisheye.spi.admin.data.RepositoryIndexingStatus;
import com.atlassian.fisheye.spi.admin.data.RepositoryState;
import com.atlassian.fisheye.spi.admin.impl.DefaultRepositoryIndexer;
import com.atlassian.fisheye.spi.admin.services.RepositoryAdminService;
import com.atlassian.fisheye.spi.admin.services.RepositoryConfigException;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import java.io.File;

public class DefaultDvcsRepositoryIndexer
extends DefaultRepositoryIndexer {
    public DefaultDvcsRepositoryIndexer(RepositoryAdminService repositoryAdminService, RepositoryHandle repositoryHandle) {
        super(repositoryAdminService, repositoryHandle);
    }

    public RepositoryIndexingStatus startFullReindexing(boolean reclone) throws RepositoryConfigException {
        this.ensureRepositoryExists();
        RepositoryState state = this.repositoryAdminService.getState(this.name);
        if (state != RepositoryState.STOPPED) {
            throw new IllegalStateException(String.format("Repository '%s' (currently %s) must be stopped before starting.", this.name, state));
        }
        if (reclone) {
            Logs.APP_LOG.info((Object)("[" + this.name + "] Deleting clone"));
            IOHelper.recursiveDelete(new File(this.repositoryHandle.getCfg().getCacheDir(), "clone"), Integer.MAX_VALUE);
        }
        return super.startFullReindexing();
    }
}

