/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.impl;

import com.atlassian.fisheye.spi.admin.data.AdvancedLinker;
import com.atlassian.fisheye.spi.admin.data.AuthenticationData;
import com.atlassian.fisheye.spi.admin.data.AuthenticationStyle;
import com.atlassian.fisheye.spi.admin.data.CaseAwarePath;
import com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob;
import com.atlassian.fisheye.spi.admin.data.CommitMessageSyntaxSettings;
import com.atlassian.fisheye.spi.admin.data.CvsRepositoryData;
import com.atlassian.fisheye.spi.admin.data.CvsUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.DefaultUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.GitRepositoryData;
import com.atlassian.fisheye.spi.admin.data.HgRepositoryData;
import com.atlassian.fisheye.spi.admin.data.ImportMode;
import com.atlassian.fisheye.spi.admin.data.ObsoleteRepositoryData;
import com.atlassian.fisheye.spi.admin.data.P4RepositoryData;
import com.atlassian.fisheye.spi.admin.data.PolledUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.spi.admin.data.SimpleLinker;
import com.atlassian.fisheye.spi.admin.data.SvnRepositoryData;
import com.atlassian.fisheye.spi.admin.data.TarballSettings;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.ClearcaseRepType;
import com.cenqua.fisheye.config1.CommitMessageSyntaxType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.CvsRepType;
import com.cenqua.fisheye.config1.CvsUpdaterType;
import com.cenqua.fisheye.config1.DefaultUpdaterType;
import com.cenqua.fisheye.config1.GitRepType;
import com.cenqua.fisheye.config1.HgRepType;
import com.cenqua.fisheye.config1.HideDirType;
import com.cenqua.fisheye.config1.LinkerAdvancedType;
import com.cenqua.fisheye.config1.LinkerSimpleType;
import com.cenqua.fisheye.config1.P4RepType;
import com.cenqua.fisheye.config1.PasswordAuthenticationType;
import com.cenqua.fisheye.config1.PolledUpdaterType;
import com.cenqua.fisheye.config1.RenameOptions;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.SshKeyAuthenticationType;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.config1.SvnSymbolicRuleType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.config1.TarballType;
import com.cenqua.fisheye.config1.UserPassAuthType;
import com.cenqua.fisheye.util.Pair;
import com.google.common.base.Strings;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class AdminSpiUtil {
    private AdminSpiUtil() {
    }

    public static RepositoryData.Type getType(RepositoryType repType) {
        if (repType.isSetSvn()) {
            return RepositoryData.Type.SUBVERSION;
        }
        if (repType.isSetCvs()) {
            return RepositoryData.Type.CVS;
        }
        if (repType.isSetPerforce()) {
            return RepositoryData.Type.PERFORCE;
        }
        if (repType.isSetGit()) {
            return RepositoryData.Type.GIT;
        }
        if (repType.isSetClearcase()) {
            return RepositoryData.Type.CLEARCASE;
        }
        if (repType.isSetHg()) {
            return RepositoryData.Type.HG;
        }
        return null;
    }

    public static RepositoryData toRepositoryData(RepositoryType repType) {
        RepositoryData.Type type = AdminSpiUtil.getType(repType);
        if (RepositoryData.Type.SUBVERSION.equals((Object)type)) {
            SvnRepType svnType = repType.getSvn();
            SvnRepositoryData svnData = new SvnRepositoryData(repType.getName(), svnType.getUrl());
            AdminSpiUtil.copyCommonFieldsToRepData((RepositoryData)svnData, repType);
            AdminSpiUtil.copySvnFieldsToRepData(svnData, repType);
            return svnData;
        }
        if (RepositoryData.Type.CVS.equals((Object)type)) {
            CvsRepType cvsType = repType.getCvs();
            CvsRepositoryData cvsData = new CvsRepositoryData(repType.getName(), cvsType.getDir());
            AdminSpiUtil.copyCommonFieldsToRepData((RepositoryData)cvsData, repType);
            AdminSpiUtil.copyCvsFieldsToRepData(cvsData, repType);
            return cvsData;
        }
        if (RepositoryData.Type.PERFORCE.equals((Object)type)) {
            P4RepType p4Type = repType.getPerforce();
            P4RepositoryData p4Data = new P4RepositoryData(repType.getName(), p4Type.getServer(), p4Type.getPath());
            AdminSpiUtil.copyCommonFieldsToRepData((RepositoryData)p4Data, repType);
            AdminSpiUtil.copyP4FieldsToRepData(p4Data, repType);
            return p4Data;
        }
        if (RepositoryData.Type.GIT.equals((Object)type)) {
            GitRepType gitType = repType.getGit();
            GitRepositoryData gitData = new GitRepositoryData(repType.getName(), gitType.getLocation());
            AdminSpiUtil.copyCommonFieldsToRepData((RepositoryData)gitData, repType);
            AdminSpiUtil.copyGitFieldsToRepData(gitData, repType);
            return gitData;
        }
        if (RepositoryData.Type.CLEARCASE.equals((Object)type)) {
            ClearcaseRepType ccRepType = repType.getClearcase();
            return new ObsoleteRepositoryData(repType.getName(), RepositoryData.Type.CLEARCASE.toString(), ccRepType.getViewLocation());
        }
        if (RepositoryData.Type.HG.equals((Object)type)) {
            HgRepType hgType = repType.getHg();
            HgRepositoryData hgData = new HgRepositoryData(repType.getName(), hgType.getLocation());
            AdminSpiUtil.copyCommonFieldsToRepData((RepositoryData)hgData, repType);
            AdminSpiUtil.copyHgFieldsToRepData(hgData, repType);
            return hgData;
        }
        throw new UnsupportedOperationException("Unknown repository type.");
    }

    public static RepositoryType toRepositoryType(RepositoryData repData) {
        if (repData instanceof SvnRepositoryData) {
            SvnRepositoryData svnData = (SvnRepositoryData)repData;
            RepositoryType repType = RepositoryType.Factory.newInstance();
            AdminSpiUtil.copyCommonFieldsToRepType(repType, (RepositoryData)svnData);
            AdminSpiUtil.copySvnFieldsToRepType(repType, svnData);
            return repType;
        }
        if (repData instanceof CvsRepositoryData) {
            CvsRepositoryData cvsData = (CvsRepositoryData)repData;
            RepositoryType repType = RepositoryType.Factory.newInstance();
            AdminSpiUtil.copyCommonFieldsToRepType(repType, (RepositoryData)cvsData);
            AdminSpiUtil.copyCvsFieldsToRepType(repType, cvsData);
            return repType;
        }
        if (repData instanceof P4RepositoryData) {
            P4RepositoryData p4Data = (P4RepositoryData)repData;
            RepositoryType repType = RepositoryType.Factory.newInstance();
            AdminSpiUtil.copyCommonFieldsToRepType(repType, (RepositoryData)p4Data);
            AdminSpiUtil.copyP4FieldsToRepType(repType, p4Data);
            return repType;
        }
        if (repData instanceof GitRepositoryData) {
            GitRepositoryData gitData = (GitRepositoryData)repData;
            RepositoryType repType = RepositoryType.Factory.newInstance();
            AdminSpiUtil.copyCommonFieldsToRepType(repType, (RepositoryData)gitData);
            AdminSpiUtil.copyGitFieldsToRepType(repType, gitData);
            return repType;
        }
        if (repData instanceof ObsoleteRepositoryData) {
            ObsoleteRepositoryData obsoleteData = (ObsoleteRepositoryData)repData;
            RepositoryType repType = RepositoryType.Factory.newInstance();
            AdminSpiUtil.copyCommonFieldsToRepType(repType, (RepositoryData)obsoleteData);
            return repType;
        }
        if (repData instanceof HgRepositoryData) {
            HgRepositoryData hgData = (HgRepositoryData)repData;
            RepositoryType repType = RepositoryType.Factory.newInstance();
            AdminSpiUtil.copyCommonFieldsToRepType(repType, (RepositoryData)hgData);
            AdminSpiUtil.copyHgFieldsToRepType(repType, hgData);
            return repType;
        }
        throw new UnsupportedOperationException("Unknown repository type.");
    }

    private static AuthenticationData createAuthenticationData(PasswordAuthenticationType authType) {
        AuthenticationData authData = new AuthenticationData();
        if (authType != null) {
            authData.setAuthenticationStyle(AuthenticationStyle.PASSWORD);
        } else {
            authData.setAuthenticationStyle(AuthenticationStyle.NONE);
        }
        return authData;
    }

    private static AuthenticationData createAuthenticationData(SshKeyAuthenticationType authType) {
        AuthenticationData authData = new AuthenticationData();
        if (authType != null) {
            if (authType.isSetPassphrase()) {
                authData.setAuthenticationStyle(AuthenticationStyle.SSH_KEY_WITH_PASSPHRASE);
            } else {
                authData.setAuthenticationStyle(AuthenticationStyle.SSH_KEY_WITHOUT_PASSPHRASE);
            }
            authData.setKeyName(authType.getKeyName());
        } else {
            authData.setAuthenticationStyle(AuthenticationStyle.NONE);
        }
        return authData;
    }

    private static void copyGitFieldsToRepType(RepositoryType repType, GitRepositoryData gitData) {
        GitRepType gitType = GitRepType.Factory.newInstance();
        gitType.setLocation(gitData.getLocation());
        if (gitData.getPath() != null) {
            gitType.setPath(gitData.getPath());
        }
        if (StringUtils.isNotBlank((String)gitData.getParent())) {
            repType.setParent(gitData.getParent());
        }
        if (gitData.getBlockSize() != null) {
            gitType.setBlocksize(BigInteger.valueOf(gitData.getBlockSize().intValue()));
        }
        if (gitData.getCommandTimeout() != null) {
            gitType.setCommandTimeout(gitData.getCommandTimeout());
        }
        if (gitData.getRenameOption() != null) {
            gitType.setRenames(RenameOptions.Enum.forInt(gitData.getRenameOption()));
        } else {
            gitType.setRenames(RenameOptions.NONE);
        }
        Pair<SshKeyAuthenticationType, PasswordAuthenticationType> updatedAuth = AdminSpiUtil.updateAuthentication(null, null, gitData.getAuthentication());
        if (updatedAuth.getFirst() != null) {
            gitType.setSshAuth(updatedAuth.getFirst());
        } else if (updatedAuth.getSecond() != null) {
            gitType.setPasswordAuth(updatedAuth.getSecond());
        }
        repType.setGit(gitType);
    }

    private static Pair<SshKeyAuthenticationType, PasswordAuthenticationType> updateAuthentication(SshKeyAuthenticationType sshAuth, PasswordAuthenticationType passwordAuth, AuthenticationData authData) {
        if (authData == null || authData.getAuthenticationType() == AuthenticationStyle.NONE) {
            return Pair.newInstance(null, null);
        }
        AuthenticationStyle authStyle = authData.getAuthenticationType();
        switch (authStyle) {
            case PASSWORD: {
                if (passwordAuth == null) {
                    passwordAuth = PasswordAuthenticationType.Factory.newInstance();
                    passwordAuth.setPassword(authData.getPassword());
                }
                if (!StringUtils.isNotEmpty((String)authData.getPassword())) break;
                passwordAuth.setPassword(authData.getPassword());
                break;
            }
            case SSH_KEY_WITHOUT_PASSPHRASE: {
                sshAuth = SshKeyAuthenticationType.Factory.newInstance();
                sshAuth.setKeyName(authData.getKeyName());
                break;
            }
            case SSH_KEY_WITH_PASSPHRASE: {
                if (sshAuth == null) {
                    sshAuth = SshKeyAuthenticationType.Factory.newInstance();
                }
                sshAuth.setKeyName(authData.getKeyName());
                if (!StringUtils.isNotEmpty((String)authData.getPassphrase())) break;
                sshAuth.setPassphrase(authData.getPassphrase());
                break;
            }
        }
        return Pair.newInstance(sshAuth, passwordAuth);
    }

    private static void copyHgFieldsToRepType(RepositoryType repType, HgRepositoryData hgData) {
        Pair<SshKeyAuthenticationType, PasswordAuthenticationType> updatedAuth;
        HgRepType hgType = HgRepType.Factory.newInstance();
        hgType.setLocation(hgData.getLocation());
        if (hgData.getBlockSize() != null) {
            hgType.setBlocksize(BigInteger.valueOf(hgData.getBlockSize().intValue()));
        }
        if (hgData.getCommandTimeout() != null) {
            hgType.setCommandTimeout(hgData.getCommandTimeout());
        }
        if ((updatedAuth = AdminSpiUtil.updateAuthentication(null, null, hgData.getAuthentication())).getFirst() != null) {
            hgType.setSshAuth(updatedAuth.getFirst());
        } else if (updatedAuth.getSecond() != null) {
            hgType.setPasswordAuth(updatedAuth.getSecond());
        }
        repType.setHg(hgType);
    }

    private static void copyGitFieldsToRepData(GitRepositoryData gitData, RepositoryType repType) {
        GitRepType gitType = repType.getGit();
        if (gitType.isSetPath()) {
            gitData.setPath(gitType.getPath());
        }
        if (gitType.isSetBlocksize()) {
            gitData.setBlockSize(Integer.valueOf(gitType.getBlocksize().intValue()));
        }
        if (gitType.isSetCommandTimeout() && gitType.getCommandTimeout().length() > 0) {
            gitData.setCommandTimeout(gitType.getCommandTimeout());
        }
        if (gitType.isSetRenames()) {
            gitData.setRenameOption(Integer.valueOf(gitType.getRenames().intValue()));
        } else {
            gitData.setRenameOption(Integer.valueOf(1));
        }
        if (gitType.isSetPasswordAuth()) {
            gitData.setAuthentication(AdminSpiUtil.createAuthenticationData(gitType.getPasswordAuth()));
        } else if (gitType.isSetSshAuth()) {
            gitData.setAuthentication(AdminSpiUtil.createAuthenticationData(gitType.getSshAuth()));
        } else {
            gitData.setAuthentication(new AuthenticationData());
        }
    }

    private static void copyHgFieldsToRepData(HgRepositoryData hgData, RepositoryType repType) {
        HgRepType hgType = repType.getHg();
        if (hgType.isSetBlocksize()) {
            hgData.setBlockSize(Integer.valueOf(hgType.getBlocksize().intValue()));
        }
        if (hgType.isSetCommandTimeout() && hgType.getCommandTimeout().length() > 0) {
            hgData.setCommandTimeout(hgType.getCommandTimeout());
        }
        if (hgType.isSetPasswordAuth()) {
            hgData.setAuthentication(AdminSpiUtil.createAuthenticationData(hgType.getPasswordAuth()));
        } else if (hgType.isSetSshAuth()) {
            hgData.setAuthentication(AdminSpiUtil.createAuthenticationData(hgType.getSshAuth()));
        } else {
            hgData.setAuthentication(new AuthenticationData());
        }
    }

    private static void copyP4FieldsToRepType(RepositoryType repType, P4RepositoryData p4Data) {
        P4RepType p4Type = P4RepType.Factory.newInstance();
        p4Type.setServer(p4Data.getServer());
        p4Type.setPath(p4Data.getPath());
        if (p4Data.getUsername() != null) {
            UserPassAuthType authType = UserPassAuthType.Factory.newInstance();
            authType.setUsername(p4Data.getUsername());
            authType.setPassword(p4Data.getPassword());
            p4Type.setAuth(authType);
        }
        if (p4Data.getBlockSize() != null) {
            p4Type.setBlocksize(BigInteger.valueOf(p4Data.getBlockSize().intValue()));
        }
        if (p4Data.isCaseSensitive() != null) {
            p4Type.setCasesensitive(p4Data.isCaseSensitive());
        }
        if (p4Data.isDisableMutli() != null) {
            p4Type.setDisableMulti(p4Data.isDisableMutli());
        }
        if (p4Data.getCharset() != null) {
            p4Type.setCharset(p4Data.getCharset().name());
        }
        if (p4Data.getCommandTimeout() != null) {
            p4Type.setCommandTimeout(p4Data.getCommandTimeout());
        }
        if (p4Data.getConnectionsPerSecond() != null) {
            p4Type.setCps(p4Data.getConnectionsPerSecond().floatValue());
        }
        if (p4Data.getFileLogLimit() != null) {
            p4Type.setFileloglimit(BigInteger.valueOf(p4Data.getFileLogLimit().intValue()));
        }
        if (p4Data.isInitialImport() != null) {
            p4Type.setInitialImport(p4Data.isInitialImport());
        }
        if (p4Data.getPort() != null) {
            p4Type.setPort(BigInteger.valueOf(p4Data.getPort().intValue()));
        }
        if (p4Data.isSkipLabels() != null) {
            p4Type.setSkipLabels(p4Data.isSkipLabels());
        }
        if (p4Data.getStartRevision() != null) {
            p4Type.setStartRev(BigInteger.valueOf(p4Data.getStartRevision()));
        }
        if (p4Data.isUnicode() != null) {
            p4Type.setUnicode(p4Data.isUnicode());
        }
        repType.setPerforce(p4Type);
    }

    private static void copyP4FieldsToRepData(P4RepositoryData p4Data, RepositoryType repType) {
        P4RepType p4Type = repType.getPerforce();
        if (p4Type.isSetAuth()) {
            UserPassAuthType authType = p4Type.getAuth();
            p4Data.setUsername(authType.getUsername());
            p4Data.setPassword(authType.getPassword());
        }
        if (p4Type.isSetBlocksize()) {
            p4Data.setBlockSize(Integer.valueOf(p4Type.getBlocksize().intValue()));
        }
        if (p4Type.isSetCasesensitive()) {
            p4Data.setCaseSensitive(Boolean.valueOf(p4Type.getCasesensitive()));
        }
        if (p4Type.isSetDisableMulti()) {
            p4Data.setDisableMutli(Boolean.valueOf(p4Type.getDisableMulti()));
        }
        if (p4Type.isSetCharset()) {
            p4Data.setCharset(Charset.forName(p4Type.getCharset()));
        }
        if (p4Type.isSetCommandTimeout() && p4Type.getCommandTimeout().length() > 0) {
            p4Data.setCommandTimeout(p4Type.getCommandTimeout());
        }
        if (p4Type.isSetCps()) {
            p4Data.setConnectionsPerSecond(Float.valueOf(p4Type.getCps()));
        }
        if (p4Type.isSetFileloglimit()) {
            p4Data.setFileLogLimit(Integer.valueOf(p4Type.getFileloglimit().intValue()));
        }
        if (p4Type.isSetInitialImport()) {
            p4Data.setInitialImport(Boolean.valueOf(p4Type.getInitialImport()));
        }
        if (p4Type.isSetPort()) {
            p4Data.setPort(Integer.valueOf(p4Type.getPort().intValue()));
        }
        if (p4Type.isSetSkipLabels()) {
            p4Data.setSkipLabels(Boolean.valueOf(p4Type.getSkipLabels()));
        }
        if (p4Type.isSetStartRev()) {
            p4Data.setStartRevision(Long.valueOf(p4Type.getStartRev().longValue()));
        }
        if (p4Type.isSetUnicode()) {
            p4Data.setUnicode(Boolean.valueOf(p4Type.getUnicode()));
        }
    }

    private static void copyCvsFieldsToRepType(RepositoryType repType, CvsRepositoryData cvsData) {
        CvsRepType cvsType = CvsRepType.Factory.newInstance();
        cvsType.setDir(cvsData.getDirectory());
        if (cvsData.getCharset() != null) {
            cvsType.setCharset(cvsData.getCharset().name());
        }
        repType.setCvs(cvsType);
    }

    private static void copyCvsFieldsToRepData(CvsRepositoryData cvsData, RepositoryType repType) {
        CvsRepType cvsType = repType.getCvs();
        cvsData.setDirectory(cvsType.getDir());
        if (cvsType.isSetCharset()) {
            cvsData.setCharset(Charset.forName(cvsType.getCharset()));
        }
    }

    private static void copyCommonFieldsToRepData(RepositoryData repData, RepositoryType repType) {
        if (repType.isSetDescription()) {
            repData.setDescription(repType.getDescription());
        }
        if (repType.isSetStoreDiff()) {
            repData.setStoreDiff(repType.getStoreDiff());
        }
        repData.setEnabled(Boolean.valueOf(repType.getEnabled()));
    }

    private static void copyCommonFieldsToRepType(RepositoryType repType, RepositoryData repData) {
        repType.setName(repData.getName());
        if (repData.getDescription() != null) {
            repType.setDescription(repData.getDescription());
        }
        repType.setStoreDiff(repData.isStoreDiff());
        if (repData.getEnabled() != null) {
            repType.setEnabled(repData.getEnabled());
        }
    }

    private static void copySvnFieldsToRepData(SvnRepositoryData svnData, RepositoryType repType) {
        SvnRepType svnType = repType.getSvn();
        svnData.setPath(svnType.getPath());
        if (svnType.isSetAuth()) {
            UserPassAuthType authType = svnType.getAuth();
            svnData.setUsername(authType.getUsername());
            svnData.setPassword(authType.getPassword());
        }
        if (svnType.isSetBlocksize()) {
            svnData.setBlockSize(Integer.valueOf(svnType.getBlocksize().intValue()));
        }
        if (svnType.isSetCommandTimeout() && svnType.getCommandTimeout().length() > 0) {
            svnData.setCommandTimeout(svnType.getCommandTimeout());
        }
        if (svnType.isSetCps()) {
            svnData.setConnectionsPerSecond(Float.valueOf(svnType.getCps()));
        }
        if (svnType.isSetCharset()) {
            svnData.setCharset(Charset.forName(svnType.getCharset()));
        }
        if (svnType.isSetAccess()) {
            svnData.setAccessCode(svnType.getAccess());
        }
        if (svnType.isSetStartRev()) {
            svnData.setStartRevision(Long.valueOf(svnType.getStartRev().longValue()));
        }
        if (svnType.isSetInitialImport()) {
            svnData.setInitialImport(ImportMode.fromString((String)svnType.getInitialImport()));
        }
        if (svnType.isSetFollowBase()) {
            svnData.setFollowBase(Boolean.valueOf(svnType.getFollowBase()));
        }
        if (svnType.isSetSymbolic()) {
            SvnSymbolicType symbolicType = svnType.getSymbolic();
            if (symbolicType.isSetAutoRules()) {
                svnData.setUsingInbuiltSymbolicRules(Boolean.valueOf(symbolicType.getAutoRules()));
            }
            svnData.setTrunks(AdminSpiUtil.toSymbolicRuleData(symbolicType.getTrunkArray()));
            svnData.setBranches(AdminSpiUtil.toSymbolicRuleData(symbolicType.getBranchArray()));
            svnData.setTags(AdminSpiUtil.toSymbolicRuleData(symbolicType.getTagArray()));
        }
    }

    private static void copySvnFieldsToRepType(RepositoryType repType, SvnRepositoryData svnData) {
        SvnRepType svnType = SvnRepType.Factory.newInstance();
        svnType.setUrl(svnData.getUrl());
        svnType.setPath(svnData.getPath());
        if (svnData.getUsername() != null) {
            UserPassAuthType authType = UserPassAuthType.Factory.newInstance();
            authType.setUsername(svnData.getUsername());
            authType.setPassword(svnData.getPassword());
            svnType.setAuth(authType);
        }
        if (svnData.getBlockSize() != null) {
            svnType.setBlocksize(BigInteger.valueOf(svnData.getBlockSize().intValue()));
        }
        if (svnData.getCommandTimeout() != null) {
            svnType.setCommandTimeout(svnData.getCommandTimeout());
        }
        if (svnData.getConnectionsPerSecond() != null) {
            svnType.setCps(svnData.getConnectionsPerSecond().floatValue());
        }
        if (svnData.getCharset() != null) {
            svnType.setCharset(svnData.getCharset().name());
        }
        if (svnData.getAccessCode() != null) {
            svnType.setAccess(svnData.getAccessCode());
        }
        if (svnData.getStartRevision() != null) {
            svnType.setStartRev(BigInteger.valueOf(svnData.getStartRevision()));
        }
        if (svnData.getInitialImport() != null) {
            svnType.setInitialImport(svnData.getInitialImport().getKey());
        }
        if (svnData.isFollowBase() != null) {
            svnType.setFollowBase(svnData.isFollowBase());
        }
        SvnSymbolicType symbolicType = SvnSymbolicType.Factory.newInstance();
        if (svnData.isUsingInbuiltSymbolicRules() != null) {
            symbolicType.setAutoRules(svnData.isUsingInbuiltSymbolicRules());
        }
        symbolicType.setTrunkArray(AdminSpiUtil.toSymbolicRuleType(svnData.getTrunks()));
        symbolicType.setBranchArray(AdminSpiUtil.toSymbolicRuleType(svnData.getBranches()));
        symbolicType.setTagArray(AdminSpiUtil.toSymbolicRuleType(svnData.getTags()));
        svnType.setSymbolic(symbolicType);
        repType.setSvn(svnType);
    }

    private static List<SvnRepositoryData.SymbolicRule> toSymbolicRuleData(SvnSymbolicRuleType[] ruleTypes) {
        if (ruleTypes.length > 0) {
            ArrayList<SvnRepositoryData.SymbolicRule> rules = new ArrayList<SvnRepositoryData.SymbolicRule>();
            for (SvnSymbolicRuleType ruleType : ruleTypes) {
                rules.add(new SvnRepositoryData.SymbolicRule(ruleType.getRegex(), ruleType.getName(), ruleType.getLogical()));
            }
            return rules;
        }
        return Collections.emptyList();
    }

    private static SvnSymbolicRuleType[] toSymbolicRuleType(Collection<SvnRepositoryData.SymbolicRule> rules) {
        if (rules != null && rules.size() > 0) {
            SvnSymbolicRuleType[] ruleTypes = new SvnSymbolicRuleType[rules.size()];
            int i2 = 0;
            for (SvnRepositoryData.SymbolicRule rule : rules) {
                ruleTypes[i2] = AdminSpiUtil.makeRule(rule.getRegex(), rule.getName(), rule.getLogicalPathPrefix());
                ++i2;
            }
            return ruleTypes;
        }
        return new SvnSymbolicRuleType[0];
    }

    private static SvnSymbolicRuleType makeEmptyRule() {
        return SvnSymbolicRuleType.Factory.newInstance();
    }

    private static SvnSymbolicRuleType makeRule(String regex, String name, String logical) {
        SvnSymbolicRuleType trunk = AdminSpiUtil.makeEmptyRule();
        trunk.setRegex(regex);
        trunk.setName(name);
        trunk.setLogical(logical);
        return trunk;
    }

    public static LinkerSimpleType toLinkerSimpleType(SimpleLinker simpleLinker) {
        LinkerSimpleType linkerType = LinkerSimpleType.Factory.newInstance();
        linkerType.setRegex(simpleLinker.getRegex().pattern());
        linkerType.setHref(simpleLinker.getHref());
        if (simpleLinker.getDescription() != null) {
            linkerType.setDescription(simpleLinker.getDescription());
        }
        return linkerType;
    }

    public static LinkerAdvancedType toLinkerAdvancedType(AdvancedLinker advancedLinker) {
        LinkerAdvancedType linkerType = LinkerAdvancedType.Factory.newInstance();
        linkerType.setSyntaxdef(advancedLinker.getSyntaxDef());
        if (advancedLinker.getDescription() != null) {
            linkerType.setDescription(advancedLinker.getDescription());
        }
        return linkerType;
    }

    public static SimpleLinker toSimpleLinker(LinkerSimpleType linkerType) {
        SimpleLinker simpleLinker = new SimpleLinker(Pattern.compile(linkerType.getRegex()), linkerType.getHref());
        if (linkerType.isSetDescription()) {
            simpleLinker.setDescription(linkerType.getDescription());
        }
        return simpleLinker;
    }

    public static AdvancedLinker toAdvancedLinker(LinkerAdvancedType linkerType) {
        AdvancedLinker advancedLinker = new AdvancedLinker(linkerType.getSyntaxdef());
        if (linkerType.isSetDescription()) {
            advancedLinker.setDescription(linkerType.getDescription());
        }
        return advancedLinker;
    }

    public static CaseAwarePath toCaseAwarePath(AllowType.Include includeType) {
        return new CaseAwarePath(includeType.getTree(), includeType.getCasesensitive());
    }

    public static AllowType.Include toAllowIncludeType(CaseAwarePath caseAwarePath) {
        AllowType.Include includeType = AllowType.Include.Factory.newInstance();
        includeType.setTree(caseAwarePath.getPath());
        includeType.setCasesensitive(caseAwarePath.isCaseSensitive());
        return includeType;
    }

    public static CaseAwarePathGlob toPathGlob(AllowType.Exclude excludeType) {
        return new CaseAwarePathGlob(excludeType.getPattern(), excludeType.getCasesensitive());
    }

    public static AllowType.Exclude toAllowExcludeType(CaseAwarePathGlob pathGlob) {
        AllowType.Exclude excludeType = AllowType.Exclude.Factory.newInstance();
        excludeType.setPattern(pathGlob.getGlob());
        excludeType.setCasesensitive(pathGlob.isCaseSensitive());
        return excludeType;
    }

    public static CaseAwarePath toCaseAwarePath(HideDirType hideDirType) {
        return new CaseAwarePath(hideDirType.getPattern(), hideDirType.getCasesensitive());
    }

    public static HideDirType toHideDirType(CaseAwarePath caseAwarePath) {
        HideDirType hideDirType = HideDirType.Factory.newInstance();
        hideDirType.setPattern(caseAwarePath.getPath());
        hideDirType.setCasesensitive(caseAwarePath.isCaseSensitive());
        return hideDirType;
    }

    public static TarballSettings toTarballSettings(TarballType tarballType) {
        ArrayList<TarballSettings.Exclude> excludes = new ArrayList<TarballSettings.Exclude>();
        for (TarballType.Exclude excludeType : tarballType.getExcludeArray()) {
            boolean isTree = excludeType.isSetTree();
            excludes.add(new TarballSettings.Exclude(isTree ? excludeType.getTree() : excludeType.getDir(), isTree));
        }
        return new TarballSettings(excludes, tarballType.getMaxFileCount().longValue(), tarballType.getEnabled());
    }

    public static TarballType toTarballType(TarballSettings tarballSettings) {
        TarballType tarballType = TarballType.Factory.newInstance();
        tarballType.setEnabled(tarballSettings.isEnabled());
        if (tarballSettings.getMaxFiles() > 0L) {
            tarballType.setMaxFileCount(BigInteger.valueOf(tarballSettings.getMaxFiles()));
        }
        List excludes = tarballSettings.getExcludes();
        TarballType.Exclude[] excludeArray = new TarballType.Exclude[excludes.size()];
        for (int i2 = 0; i2 < excludes.size(); ++i2) {
            excludeArray[i2] = AdminSpiUtil.toTarballExcludeType((TarballSettings.Exclude)excludes.get(i2));
        }
        tarballType.setExcludeArray(excludeArray);
        return tarballType;
    }

    private static TarballType.Exclude toTarballExcludeType(TarballSettings.Exclude exclude) {
        TarballType.Exclude excludeType = TarballType.Exclude.Factory.newInstance();
        if (exclude.isExcludeSubDirs()) {
            excludeType.setTree(exclude.getDirectoryPath());
        } else {
            excludeType.setDir(exclude.getDirectoryPath());
        }
        return excludeType;
    }

    public static int configIndex(String name) {
        ConfigDocument.Config config = AppConfig.getsConfig().getConfig();
        RepositoryType[] reps = config.getRepositoryArray();
        for (int i2 = 0; i2 < reps.length; ++i2) {
            if (!name.equals(reps[i2].getName())) continue;
            return i2;
        }
        return -1;
    }

    public static CommitMessageSyntaxSettings toCommitMessageSyntaxSettings(CommitMessageSyntaxType commitMessageSyntaxType) {
        return new CommitMessageSyntaxSettings(commitMessageSyntaxType.isSetSyntax() && commitMessageSyntaxType.getSyntax().intValue() == 2 ? CommitMessageSyntaxSettings.SyntaxType.WIKI : CommitMessageSyntaxSettings.SyntaxType.PLAIN, commitMessageSyntaxType.isSetWikiSyntaxStartDate() ? commitMessageSyntaxType.getWikiSyntaxStartDate().getTime() : null);
    }

    public static CommitMessageSyntaxType toCommitMessageSyntaxType(CommitMessageSyntaxSettings commitMessageSyntaxSettings) {
        CommitMessageSyntaxType syntaxType = CommitMessageSyntaxType.Factory.newInstance();
        boolean plainSyntax = commitMessageSyntaxSettings.getSyntaxType() == CommitMessageSyntaxSettings.SyntaxType.PLAIN;
        syntaxType.setSyntax(plainSyntax ? CommitMessageSyntaxType.Syntax.PLAIN : CommitMessageSyntaxType.Syntax.WIKI);
        if (!plainSyntax) {
            if (commitMessageSyntaxSettings.getWikiSyntaxStartDate() != null) {
                Calendar calendar = Calendar.getInstance(AppConfig.getsConfig().getTimezone());
                calendar.setTime(commitMessageSyntaxSettings.getWikiSyntaxStartDate());
                syntaxType.setWikiSyntaxStartDate(calendar);
            } else if (syntaxType.isSetWikiSyntaxStartDate()) {
                syntaxType.unsetWikiSyntaxStartDate();
            }
        }
        return syntaxType;
    }

    public static PolledUpdaterType getPolledRepoUpdater(RepositoryType repoType, boolean createIfRequired) {
        if (repoType.isSetSvn()) {
            SvnRepType svn = repoType.getSvn();
            if (!svn.isSetUpdater() && createIfRequired) {
                svn.addNewUpdater();
            }
            return svn.getUpdater();
        }
        if (repoType.isSetPerforce()) {
            P4RepType p4 = repoType.getPerforce();
            if (!p4.isSetUpdater() && createIfRequired) {
                p4.addNewUpdater();
            }
            return p4.getUpdater();
        }
        if (repoType.isSetGit()) {
            GitRepType git = repoType.getGit();
            if (!git.isSetUpdater() && createIfRequired) {
                git.addNewUpdater();
            }
            return git.getUpdater();
        }
        if (repoType.isSetHg()) {
            HgRepType hg = repoType.getHg();
            if (!hg.isSetUpdater() && createIfRequired) {
                hg.addNewUpdater();
            }
            return hg.getUpdater();
        }
        return null;
    }

    public static CvsUpdaterType getCvsRepoUpdater(RepositoryType repoType, boolean createIfRequired) {
        if (repoType.isSetCvs()) {
            CvsRepType cvs = repoType.getCvs();
            if (!cvs.isSetUpdater() && createIfRequired) {
                cvs.addNewUpdater();
            }
            return cvs.getUpdater();
        }
        return null;
    }

    public static void unsetRepoUpdater(RepositoryType repoType) {
        CvsRepType cvs;
        if (repoType.isSetSvn()) {
            SvnRepType svnRepType = repoType.getSvn();
            if (svnRepType.isSetUpdater()) {
                svnRepType.unsetUpdater();
            }
        } else if (repoType.isSetPerforce()) {
            P4RepType perforceRepType = repoType.getPerforce();
            if (perforceRepType.isSetUpdater()) {
                perforceRepType.unsetUpdater();
            }
        } else if (repoType.isSetHg()) {
            HgRepType hgRepType = repoType.getHg();
            if (hgRepType.isSetUpdater()) {
                hgRepType.unsetUpdater();
            }
        } else if (repoType.isSetGit()) {
            GitRepType gitRepType = repoType.getGit();
            if (gitRepType.isSetUpdater()) {
                gitRepType.unsetUpdater();
            }
        } else if (repoType.isSetCvs() && (cvs = repoType.getCvs()).isSetUpdater()) {
            cvs.unsetUpdater();
        }
    }

    public static void setCvsUpdaterType(CvsUpdateOptions cvsUpdateOptions, CvsUpdaterType cut) {
        CvsUpdaterType.Historyfile historyfile = cut.getHistoryfile();
        if (historyfile == null) {
            historyfile = cut.addNewHistoryfile();
        }
        historyfile.setFile(Strings.emptyToNull((String)cvsUpdateOptions.getHistoryFile()));
        historyfile.setFullScanPeriod(Strings.emptyToNull((String)cvsUpdateOptions.getFullScanInterval()));
        if (!Strings.isNullOrEmpty((String)cvsUpdateOptions.getStripPrefix())) {
            historyfile.setStripPrefix(cvsUpdateOptions.getStripPrefix());
        } else if (historyfile.isSetStripPrefix()) {
            historyfile.unsetStripPrefix();
        }
        if (!Strings.isNullOrEmpty((String)cvsUpdateOptions.getPollInterval())) {
            cut.setPollPeriod(cvsUpdateOptions.getPollInterval());
        } else if (cut.isSetPollPeriod()) {
            cut.unsetPollPeriod();
        }
    }

    public static PolledUpdaterType setPolledUpdaterType(PolledUpdateOptions polledUpdateOptions, PolledUpdaterType put) {
        put.setPollPeriod(polledUpdateOptions.getPollInterval());
        return put;
    }

    public static PolledUpdateOptions toPolledUpdateOptions(PolledUpdaterType polled) {
        return new PolledUpdateOptions(polled.getPollPeriod());
    }

    public static CvsUpdateOptions toCvsUpdateOptions(CvsUpdaterType cvs) {
        String pollInterval = cvs.isSetPollPeriod() ? cvs.getPollPeriod() : CvsUpdateOptions.DEFAULT.getPollInterval();
        String fullScanInterval = cvs.getHistoryfile().getFullScanPeriod();
        String stripPrefix = cvs.getHistoryfile().isSetStripPrefix() ? cvs.getHistoryfile().getStripPrefix() : CvsUpdateOptions.DEFAULT.getStripPrefix();
        String historyFile = cvs.getHistoryfile().getFile();
        return new CvsUpdateOptions(pollInterval, fullScanInterval, historyFile, stripPrefix);
    }

    public static DefaultUpdaterType toDefaultUpdaterType(DefaultUpdateOptions updateSettings) {
        DefaultUpdaterType defaultUpdater = DefaultUpdaterType.Factory.newInstance();
        AdminSpiUtil.setCvsUpdaterType(updateSettings.getCvsUpdateOptions(), defaultUpdater.addNewCvs());
        AdminSpiUtil.setPolledUpdaterType(updateSettings.getPolledUpdateOptions(), defaultUpdater.addNewPolled());
        return defaultUpdater;
    }

    public static DefaultUpdateOptions toDefaultUpdateOptions(DefaultUpdaterType updater) {
        return new DefaultUpdateOptions(AdminSpiUtil.toCvsUpdateOptions(updater.getCvs()), AdminSpiUtil.toPolledUpdateOptions(updater.getPolled()));
    }
}

