/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.impl;

import com.atlassian.fisheye.spi.admin.data.RepositoryIndexingStatus;
import com.atlassian.fisheye.spi.admin.data.RepositoryState;
import com.atlassian.fisheye.spi.admin.impl.DefaultRepositoryIndexer;
import com.atlassian.fisheye.spi.admin.services.RepositoryAdminService;
import com.cenqua.fisheye.rep.RepositoryHandle;

public abstract class AbstractRevisionRepositoryIndexer
extends DefaultRepositoryIndexer {
    public AbstractRevisionRepositoryIndexer(RepositoryAdminService repositoryAdminService, RepositoryHandle repositoryHandle) {
        super(repositoryAdminService, repositoryHandle);
    }

    protected RepositoryIndexingStatus startRevisionRangeReindexing(String fromRevision, String toRevision) {
        this.ensureRepositoryExists();
        if (fromRevision == null) {
            throw new NullPointerException("fromRevision cannot be null");
        }
        if (toRevision == null) {
            throw new NullPointerException("toRevision cannot be null");
        }
        RepositoryState state = this.repositoryAdminService.getState(this.name);
        if (state != RepositoryState.RUNNING) {
            throw new IllegalStateException(String.format("Repository '%s' must be running (currently %s).", this.name, state));
        }
        try {
            this.repositoryHandle.rescan(fromRevision, toRevision);
        }
        catch (RepositoryHandle.StateException e2) {
            throw new IllegalStateException(String.format("Repository '%s' must be running to rescan (currently %s).", this.name, state));
        }
        return this.getIndexingStatus();
    }
}

