/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.impl;

import com.atlassian.fisheye.spi.admin.data.AdvancedLinker;
import com.atlassian.fisheye.spi.admin.data.CaseAwarePath;
import com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob;
import com.atlassian.fisheye.spi.admin.data.CommitMessageSyntaxSettings;
import com.atlassian.fisheye.spi.admin.data.SimpleLinker;
import com.atlassian.fisheye.spi.admin.data.TarballSettings;
import com.atlassian.fisheye.spi.admin.impl.AdminSpiUtil;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.ChangesetDiscussionsSettingsType;
import com.cenqua.fisheye.config1.CommitMessageSyntaxType;
import com.cenqua.fisheye.config1.GroupListType;
import com.cenqua.fisheye.config1.GroupType;
import com.cenqua.fisheye.config1.HideDirType;
import com.cenqua.fisheye.config1.LinkerAdvancedType;
import com.cenqua.fisheye.config1.LinkerSimpleType;
import com.cenqua.fisheye.config1.LinkerType;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.TarballType;
import com.cenqua.fisheye.config1.WatchType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractRepositoryOptionsHelper {
    protected abstract LinkerType getLinkerType(boolean var1);

    public List<SimpleLinker> getSimpleLinkers() {
        ArrayList<SimpleLinker> result = new ArrayList<SimpleLinker>();
        for (LinkerSimpleType type : this.getLinkerType(false).getSimpleArray()) {
            result.add(AdminSpiUtil.toSimpleLinker(type));
        }
        return result;
    }

    public void setSimpleLinkers(List<SimpleLinker> linkers) {
        LinkerSimpleType[] types = new LinkerSimpleType[linkers.size()];
        for (int i2 = 0; i2 < linkers.size(); ++i2) {
            types[i2] = AdminSpiUtil.toLinkerSimpleType(linkers.get(i2));
        }
        LinkerType linkerType = this.getLinkerType(true);
        linkerType.setSimpleArray(types);
    }

    public List<AdvancedLinker> getAdvancedLinkers() {
        ArrayList<AdvancedLinker> result = new ArrayList<AdvancedLinker>();
        for (LinkerAdvancedType type : this.getLinkerType(false).getAdvancedArray()) {
            result.add(AdminSpiUtil.toAdvancedLinker(type));
        }
        return result;
    }

    public void setAdvancedLinkers(List<AdvancedLinker> linkers) {
        LinkerAdvancedType[] types = new LinkerAdvancedType[linkers.size()];
        for (int i2 = 0; i2 < linkers.size(); ++i2) {
            types[i2] = AdminSpiUtil.toLinkerAdvancedType(linkers.get(i2));
        }
        LinkerType linkerType = this.getLinkerType(true);
        linkerType.setAdvancedArray(types);
    }

    public abstract void reloadLinkers();

    public abstract void reloadUpdateOptions();

    protected abstract RepSecurityType getRepSecurityType(boolean var1);

    public boolean isAllowAnon() {
        return this.getRepSecurityType(false).getAllowAnon();
    }

    public boolean isAllowLoggedUsers() {
        return this.getRepSecurityType(false).getAllowLoggedIn();
    }

    public void setAllowAnon(boolean allow) {
        this.getRepSecurityType(true).setAllowAnon(allow);
    }

    public void setAllowLoggedUsers(boolean allow) {
        this.getRepSecurityType(true).setAllowLoggedIn(allow);
    }

    protected abstract GroupListType getGroupsListType(boolean var1);

    public Set<String> getRequiredGroups() {
        return this.extractGroupNames(this.getGroupsListType(false));
    }

    private Set<String> extractGroupNames(GroupListType list) {
        HashSet<String> groups = new HashSet<String>();
        if (list != null) {
            for (GroupType groupType : list.getGroupArray()) {
                groups.add(groupType.getName());
            }
        }
        return groups;
    }

    public void setRequiredGroups(Set<String> groups) {
        this.getGroupsListType(true).setGroupArray(this.extractGroupTypes(groups));
    }

    private GroupType[] extractGroupTypes(Set<String> groups) {
        ArrayList<GroupType> groupTypes = new ArrayList<GroupType>(groups.size());
        for (String group : groups) {
            GroupType groupType = GroupType.Factory.newInstance();
            groupType.setName(group);
            groupTypes.add(groupType);
        }
        return groupTypes.toArray(new GroupType[groupTypes.size()]);
    }

    protected abstract WatchType getWatchType(boolean var1);

    public boolean isWatchesEnabled() {
        return this.getWatchType(false).getEnabled();
    }

    public void setWatchesEnabled(boolean enable) {
        this.getWatchType(true).setEnabled(enable);
    }

    protected abstract ChangesetDiscussionsSettingsType getChangesetDiscussionsType(boolean var1);

    public boolean isChangesetDiscussionsEnabled() {
        return this.getChangesetDiscussionsType(false).getEnabled();
    }

    public void setChangesetDiscussionEnabled(boolean enable) {
        this.getChangesetDiscussionsType(true).setEnabled(enable);
    }

    protected abstract AllowType getAllowType(boolean var1);

    public List<CaseAwarePath> getAllowIncludePaths() {
        ArrayList<CaseAwarePath> result = new ArrayList<CaseAwarePath>();
        for (AllowType.Include includeType : this.getAllowType(false).getIncludeArray()) {
            result.add(AdminSpiUtil.toCaseAwarePath(includeType));
        }
        return result;
    }

    public void setAllowIncludePaths(List<CaseAwarePath> includePaths) {
        AllowType.Include[] types = new AllowType.Include[includePaths.size()];
        for (int i2 = 0; i2 < includePaths.size(); ++i2) {
            types[i2] = AdminSpiUtil.toAllowIncludeType(includePaths.get(i2));
        }
        this.getAllowType(true).setIncludeArray(types);
    }

    public List<CaseAwarePathGlob> getAllowExcludeGlobs() {
        ArrayList<CaseAwarePathGlob> result = new ArrayList<CaseAwarePathGlob>();
        for (AllowType.Exclude excludeType : this.getAllowType(false).getExcludeArray()) {
            result.add(AdminSpiUtil.toPathGlob(excludeType));
        }
        return result;
    }

    public void setAllowExcludeGlobs(List<CaseAwarePathGlob> excludeGlobs) {
        AllowType.Exclude[] types = new AllowType.Exclude[excludeGlobs.size()];
        for (int i2 = 0; i2 < excludeGlobs.size(); ++i2) {
            types[i2] = AdminSpiUtil.toAllowExcludeType(excludeGlobs.get(i2));
        }
        this.getAllowType(true).setExcludeArray(types);
    }

    protected abstract HideDirType[] getHideDirTypeArray();

    protected abstract void setHideDirTypeArray(HideDirType[] var1);

    public List<CaseAwarePath> getHiddenDirectories() {
        ArrayList<CaseAwarePath> result = new ArrayList<CaseAwarePath>();
        for (HideDirType hideDirType : this.getHideDirTypeArray()) {
            result.add(AdminSpiUtil.toCaseAwarePath(hideDirType));
        }
        return result;
    }

    public void setHiddenDirectories(List<CaseAwarePath> dirs) {
        HideDirType[] types = new HideDirType[dirs.size()];
        for (int i2 = 0; i2 < dirs.size(); ++i2) {
            types[i2] = AdminSpiUtil.toHideDirType(dirs.get(i2));
        }
        this.setHideDirTypeArray(types);
    }

    protected abstract TarballType getTarballType(boolean var1);

    protected abstract void setTarballType(TarballType var1);

    public TarballSettings getTarballSettings() {
        return AdminSpiUtil.toTarballSettings(this.getTarballType(false));
    }

    public void setTarballSettings(TarballSettings tarballSettings) {
        this.setTarballType(AdminSpiUtil.toTarballType(tarballSettings));
    }

    public abstract CommitMessageSyntaxType getCommitMessageSyntaxType(boolean var1);

    public CommitMessageSyntaxSettings getCommitMessageSyntaxSettings() {
        return AdminSpiUtil.toCommitMessageSyntaxSettings(this.getCommitMessageSyntaxType(false));
    }

    public void setCommitMessageSyntaxSettings(CommitMessageSyntaxSettings commitMessageSyntaxSettings) {
        this.setCommitMessageSyntaxType(AdminSpiUtil.toCommitMessageSyntaxType(commitMessageSyntaxSettings));
    }

    protected abstract void setCommitMessageSyntaxType(CommitMessageSyntaxType var1);
}

