/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.scm;

import com.atlassian.crucible.explorers.ChangelogExplorer;
import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.atlassian.crucible.explorers.FileHistoryExplorer;
import com.atlassian.crucible.scm.ChangeSet;
import com.atlassian.crucible.scm.ChangelogBrowser;
import com.atlassian.crucible.scm.DirectoryBrowser;
import com.atlassian.crucible.scm.FileHistory;
import com.atlassian.crucible.scm.HasChangelogBrowser;
import com.atlassian.crucible.scm.HasDirectoryBrowser;
import com.atlassian.crucible.scm.RevisionData;
import com.atlassian.crucible.scm.RevisionKey;
import com.atlassian.crucible.scm.SCMRepository;
import com.atlassian.fisheye.scm.RepositoryExplorer;
import com.atlassian.fisheye.scm.SCMChangelogExplorer;
import com.atlassian.fisheye.scm.SCMFileHistoryExplorer;
import com.atlassian.fisheye.scm.SCMRepositoryExplorer;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.managers.EncodedContentProvider;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.search.SearchManager;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class SCMSource
extends Source {
    private final Principal principal;
    private SCMRepository repository;
    private CommitterUserMappingManager committerUserMappingManager;

    public SCMSource(SCMRepository repository, Principal principal, ContentManager contentManager, NotificationManager notificationManager, CommentManager commentManager, EncodedContentProvider encodedContentProvider, CommitterUserMappingManager committerUserMappingManager) {
        super(repository.getName(), contentManager, notificationManager, commentManager, encodedContentProvider);
        this.repository = repository;
        this.principal = principal;
        this.committerUserMappingManager = committerUserMappingManager;
    }

    @Override
    public boolean isAvailableGivenLicense(LicenseInfo license) {
        return license.isCrucible();
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public String getReason() {
        return this.getRepository() == null ? "Repository plugin for repository " + this.getName() + " not loaded." : this.getRepository().getStateDescription();
    }

    @Override
    public String getChangeSetId(CrucibleRevision crucibleRevision) {
        return crucibleRevision.getDetail("changeset");
    }

    @Override
    public boolean isAvailable() {
        return this.getRepository() != null && this.getRepository().isAvailable(this.principal);
    }

    @Override
    public boolean isAuthorized() {
        return true;
    }

    @Override
    public boolean isAnySuccessorRevisions(CrucibleRevision fr) {
        return false;
    }

    @Override
    public String getLatestRevIdent(CrucibleRevision fr) {
        return null;
    }

    @Override
    public List<String> findAuthors(Path path) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isAllowsAuthorConstraint() {
        return false;
    }

    @Override
    public List<String> findBranches(Path path) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getDefaultBranch() {
        return null;
    }

    @Override
    public boolean isAllowsBranchConstraint() {
        return false;
    }

    @Override
    public SearchManager getSearchManager() {
        return null;
    }

    @Override
    public ChangelogExplorer getChangelogExplorer(Path path, WaybackSpec wbSpec, Review review) {
        if (this.isAvailable()) {
            if (this.isChangesetCapable()) {
                ChangelogBrowser changelogProvider = ((HasChangelogBrowser)this.getRepository()).getChangelogBrowser();
                return new SCMChangelogExplorer(this, path, wbSpec, review, changelogProvider, this.contentManager, this.committerUserMappingManager);
            }
            return null;
        }
        return null;
    }

    @Override
    public FileHistoryExplorer getFileHistoryExplorer(RevInfoKey revInfoKey, WaybackSpec wb) {
        if (this.isAvailable()) {
            if (this.isDirectoryBrowseCapable()) {
                DirectoryBrowser b2 = ((HasDirectoryBrowser)this.getRepository()).getDirectoryBrowser();
                FileHistory fh = b2.getFileHistory(this.principal, revInfoKey.getPath().getPath(), revInfoKey.getRev());
                return this.makeFileHistoryExplorer(fh);
            }
            throw new RuntimeException("getFileHistoryExplorer called on non directory capable repository:" + this.toString());
        }
        throw new RuntimeException("getFileHistoryExplorer called on unavailable repository.");
    }

    @Override
    public boolean isDirectoryBrowseCapable() {
        return this.isAvailable() && this.getRepository() instanceof HasDirectoryBrowser;
    }

    @Override
    public CrucibleChangeSet getChangeSet(String csid, boolean noSizeCheck) throws SourceException {
        SCMRepository repo = this.getRepository();
        if (repo instanceof HasChangelogBrowser) {
            ChangelogBrowser browser = ((HasChangelogBrowser)repo).getChangelogBrowser();
            ChangelogBrowser.ChangeSets changes = browser.listChanges(this.principal, "", csid, true, csid, true, 1);
            if (changes != null) {
                if (changes.getChangeSets().size() != 1) {
                    throw new SourceException("Expected 1 changeset but got " + changes.getChangeSets().size());
                }
                if (changes.getChangeSets() != null && !changes.getChangeSets().isEmpty() && ((ChangeSet)changes.getChangeSets().get(0)).getCsid().equals(csid)) {
                    return this.toCrucibleChangeSet((ChangeSet)changes.getChangeSets().get(0));
                }
            }
            throw new SourceException("Changeset '" + csid + "' not found in repository " + this.getName());
        }
        throw new SourceException("The SCM plugin repository " + this.getName() + " doesn't support change set retrieval.");
    }

    private CrucibleChangeSet toCrucibleChangeSet(ChangeSet scmChangeSet) {
        ArrayList<CrucibleRevision> revs = new ArrayList<CrucibleRevision>();
        for (RevisionKey rk : scmChangeSet.getRevisions()) {
            revs.add(this.makeMinimalRevision(rk, scmChangeSet.getMaybeDetails(rk)));
        }
        return new CrucibleChangeSet(scmChangeSet.getCsid(), scmChangeSet.getCsid(), revs, scmChangeSet.getComment(), scmChangeSet.getDate(), scmChangeSet.getAuthor(), this);
    }

    @Override
    public boolean isAfter(RevInfoKey thisRevisionIdent, RevInfoKey thatRevisionIdent) {
        return false;
    }

    @Override
    public boolean isBefore(RevInfoKey thisRevisionIdent, RevInfoKey thatRevisionIdent) {
        return false;
    }

    @Override
    public boolean isOnAncestryLine(List<CrucibleRevision> existingRevisions, CrucibleRevision from, CrucibleRevision to) throws SourceException {
        if (from != null && from.getCommitDate() == null || to.getCommitDate() == null) {
            return false;
        }
        for (CrucibleRevision currentRev : existingRevisions) {
            if (from != null && currentRev.getPath().equals(from.getPath()) && currentRev.getPath().equals(to.getPath()) && currentRev.getCommitDate() != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getInsertIndex(List<CrucibleRevision> existingRevisions, CrucibleRevision fr, CrucibleRevision knownMax) throws SourceException {
        this.validateRevisionSource(fr);
        if (!existingRevisions.contains(fr)) {
            boolean needsAdd = true;
            int i2 = 0;
            for (CrucibleRevision currentRev : existingRevisions) {
                this.validateRevisionSource(currentRev);
                if (fr.getCommitDate() != null && currentRev.getCommitDate() != null && fr.getCommitDate().before(currentRev.getCommitDate()) || currentRev.equals(knownMax)) break;
                if (fr.getRevInfoKey().equals(currentRev.getRevInfoKey())) {
                    needsAdd = false;
                    break;
                }
                ++i2;
            }
            if (needsAdd) {
                return i2;
            }
        }
        return -1;
    }

    @Override
    public boolean isFile(Path path) {
        return false;
    }

    @Override
    public boolean isDir(Path path) {
        return false;
    }

    @Override
    public RepositoryExplorer getRepositoryExplorer(Path path, WaybackSpec wbSpec, CookiePreferences userPreferences) {
        if (this.isAvailable() && this.getRepository() instanceof HasDirectoryBrowser) {
            return new SCMRepositoryExplorer(this, path, userPreferences, (HasDirectoryBrowser)this.getRepository());
        }
        return null;
    }

    @Override
    public boolean isChangesetCapable() {
        return this.isAvailable() && this.getRepository() instanceof HasChangelogBrowser;
    }

    @Override
    public boolean isSearchCapable() {
        return false;
    }

    public Blame getBlame(CrucibleRevision cruRev, int lineCount) throws Exception {
        return null;
    }

    @Override
    public IndexedLineReader getFileContents(CrucibleRevision fileRevision, String kopts, Disposer disposer) throws Exception {
        File tmpFile = disposer.newDisposedTmpFile();
        this.copyFile(fileRevision, tmpFile);
        StreamIndexedLineReader reader = new StreamIndexedLineReader(tmpFile);
        disposer.add(reader);
        return reader;
    }

    @Override
    public void copyFile(CrucibleRevision revision, File file) throws Exception {
        if (this.isAvailable()) {
            FileOutputStream os = null;
            try {
                os = FileUtils.openOutputStream((File)file);
                this.getRepository().streamContents(this.principal, new RevisionKey(revision.getPath(), revision.getRevision()), (OutputStream)os);
            }
            catch (IOException ioe) {
                throw new FileRevisionException(ioe);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)os);
            }
        } else {
            throw new FileRevisionException("copyFile called on unavailable repository.");
        }
    }

    @Override
    public Linker getLinker() {
        return AppConfig.getsConfig().getDefaultLinker();
    }

    @Override
    public boolean isStorable() {
        return true;
    }

    @Override
    public FileRevisionInfo getFileRevisionInfo(String path, String revision) throws FileRevisionException {
        if (this.isAvailable()) {
            RevisionKey key = new RevisionKey(path, revision);
            Logs.APP_LOG.debug((Object)("getting revision data for " + path + " " + revision));
            RevisionData revisionData = this.getRepository().getRevisionData(this.principal, key);
            if (revisionData == null) {
                Logs.APP_LOG.warn((Object)("No revision data found for " + path + " " + revision));
            }
            FileRevisionInfo fri = new FileRevisionInfo(path, revision, revision, revisionData == null ? new HashMap() : revisionData.getDetails());
            fri.getDetails().put("annotatable", this.isAnnotatable(revisionData) ? "true" : "false");
            return fri;
        }
        throw new FileRevisionException("getFileRevisionInfo called on unavailable repository.");
    }

    private boolean isAnnotatable(RevisionData revisionData) {
        if (revisionData == null) {
            return false;
        }
        return !"dir".equals(revisionData.getDetails().get("filetype"));
    }

    @Override
    public RevInfoKey searchAncestors(RevInfoKey revInfoKey, Predicate<RevInfoKey> predicate) throws FileRevisionException {
        if (this.isAvailable()) {
            RevisionKey key = this.getRepository().getDiffRevisionKey(this.principal, new RevisionKey(revInfoKey.getPath().getPath(), revInfoKey.getRev()));
            RevInfoKey ancRevKey = null;
            if (key != null) {
                ancRevKey = new RevInfoKey(new Path(key.getPath()), key.getRevision());
            }
            while (key != null && !predicate.apply(ancRevKey)) {
                key = this.getRepository().getDiffRevisionKey(this.principal, key);
                if (key == null) continue;
                ancRevKey = new RevInfoKey(new Path(key.getPath()), key.getRevision());
            }
            return ancRevKey;
        }
        throw new FileRevisionException("searchAncestors called on unavailable repository.");
    }

    @Override
    public Charset getTextEncoding(CrucibleRevision fr) throws SourceException {
        return Charset.forName("UTF8");
    }

    @Override
    public String getDisplayName() {
        return this.getRepository() == null ? this.getReason() : this.getRepository().getDescription() + (this.getRepository().isAvailable(this.principal) ? "" : " " + this.getReason());
    }

    public String toString() {
        return "SCMSource:" + this.getDisplayName();
    }

    private SCMRepository getRepository() {
        return this.repository;
    }

    public CrucibleRevision makeMinimalRevision(RevisionKey rk, RevisionData maybeDetails) {
        Map detailMap = null;
        boolean deleted = false;
        if (maybeDetails != null) {
            detailMap = maybeDetails.getDetails();
            deleted = "true".equals(detailMap.get("deleted"));
        }
        return this.contentManager.makeMinimalCrucibleRevision(this.getName(), rk.getPath(), rk.getRevision(), deleted, detailMap);
    }

    public SCMFileHistoryExplorer makeFileHistoryExplorer(FileHistory fh) {
        HashMap<String, List<RevInfoKey>> map = new HashMap<String, List<RevInfoKey>>();
        ArrayList<RevInfoKey> revisions = new ArrayList<RevInfoKey>();
        for (RevisionKey rk : fh.getRevisions()) {
            if (fh.anyMaybeDetails()) {
                this.makeMinimalRevision(rk, fh.getMaybeDetails(rk));
            }
            RevInfoKey rik = new RevInfoKey(rk);
            revisions.add(rik);
        }
        map.put("", revisions);
        return new SCMFileHistoryExplorer(map);
    }
}

