/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.scm;

import com.atlassian.crucible.scm.FileSummary;
import com.atlassian.crucible.scm.HasDirectoryBrowser;
import com.atlassian.crucible.scm.RevisionKey;
import com.atlassian.fisheye.scm.DirTreeData;
import com.atlassian.fisheye.scm.FileExplorerInfo;
import com.atlassian.fisheye.scm.RepositoryExplorer;
import com.atlassian.fisheye.scm.SCMDirTreeData;
import com.atlassian.fisheye.scm.SCMFileExplorerInfo;
import com.atlassian.fisheye.scm.SCMFileHistoryExplorer;
import com.atlassian.fisheye.scm.SCMSource;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.CookiePreferences;
import java.util.ArrayList;
import java.util.List;

public class SCMRepositoryExplorer
implements RepositoryExplorer {
    private final SCMSource source;
    private final Path path;
    private final CookiePreferences userPreferences;
    private final HasDirectoryBrowser repository;
    private SCMDirTreeData dirTreeData;

    public SCMRepositoryExplorer(SCMSource source, Path path, CookiePreferences userPreferences, HasDirectoryBrowser repository) {
        this.source = source;
        this.path = path;
        this.userPreferences = userPreferences;
        this.repository = repository;
    }

    @Override
    public DirTreeData getDirTreeData(Path rootPath, Path selectedPath, boolean noFiles) {
        if (this.dirTreeData == null) {
            this.dirTreeData = new SCMDirTreeData(this, this.source.getPrincipal(), rootPath, selectedPath, this.repository);
        }
        return this.dirTreeData;
    }

    @Override
    public int getDeletedFilesCount() {
        return 0;
    }

    @Override
    public boolean isHideDeletedFiles() {
        return this.userPreferences.isHideDeletedFiles();
    }

    @Override
    public List<FileExplorerInfo> getFiles() throws DbException {
        ArrayList<FileExplorerInfo> files = new ArrayList<FileExplorerInfo>();
        for (FileSummary f2 : this.repository.getDirectoryBrowser().listFiles(this.source.getPrincipal(), this.path.getPath())) {
            files.add(this.makeFileExplorer(f2));
        }
        return files;
    }

    private SCMFileExplorerInfo makeFileExplorer(FileSummary f2) {
        RevisionKey revisionKey = f2.getHeadRevision();
        CrucibleRevision cruRev = this.source.makeMinimalRevision(revisionKey, f2.getHeadMaybeDetail());
        SCMFileHistoryExplorer history = null;
        if (f2.getMaybeHistory() != null) {
            history = this.source.makeFileHistoryExplorer(f2.getMaybeHistory());
        }
        return new SCMFileExplorerInfo(cruRev, this.source, f2, history);
    }

    public Path getSelectedPath() {
        return this.path;
    }

    public Path getLocalPath() {
        return this.path;
    }

    public String getName() {
        return this.source.getName();
    }

    public String getRepName() {
        return this.source.getName();
    }
}

