/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.scm;

import com.atlassian.crucible.scm.DirectorySummary;
import com.atlassian.crucible.scm.HasDirectoryBrowser;
import com.atlassian.fisheye.scm.DirNodeData;
import com.atlassian.fisheye.scm.DirTreeData;
import com.atlassian.fisheye.scm.SCMRepositoryExplorer;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SCMDirTreeData
implements DirTreeData {
    private final SCMRepositoryExplorer repository;
    private final HasDirectoryBrowser dirBrowser;
    private final Principal principal;
    private DirNodeData rootNode;
    private final DirNodeData parentNode;
    private final Path rootPath;
    private final Path selectedPath;
    private int nodeCount = 0;

    public SCMDirTreeData(SCMRepositoryExplorer rep, Principal principal, Path rootPath, Path path, HasDirectoryBrowser dirBrowser) {
        this.repository = rep;
        this.dirBrowser = dirBrowser;
        this.principal = principal;
        this.selectedPath = path;
        this.rootPath = rootPath;
        if (!rep.getLocalPath().isRoot()) {
            this.parentNode = new DirNodeData(rep.getLocalPath().trimLast(), true, false, null, this.getRootPath().getNumComponents(), this.selectedPath, new Pair[0]);
            ++this.nodeCount;
            this.parentNode.setSubDirs(Collections.emptyList());
        } else {
            this.parentNode = null;
        }
        this.rootNode = new DirNodeData(this.getRootPath(), false, false, null, this.getRootPath().getNumComponents(), this.selectedPath, new Pair[0]);
        this.rootNode.setSubDirs(this.calcSubDirs(rootPath));
    }

    private List<DirNodeData> calcSubDirs(Path path) {
        ArrayList<DirNodeData> subdirs = new ArrayList<DirNodeData>();
        for (DirectorySummary directorySummary : this.dirBrowser.getDirectoryBrowser().listDirectories(this.principal, path.getPath())) {
            subdirs.add(this.createDirNode(directorySummary));
        }
        return subdirs;
    }

    private DirNodeData createDirNode(DirectorySummary dirSummary) {
        Path path = new Path(dirSummary.getPath());
        return new DirNodeData(path, false, false, null, path.getNumComponents(), this.getSelectedPath(), new Pair[0]);
    }

    @Override
    public String getRepositoryName() {
        return this.repository.getName();
    }

    @Override
    public boolean isHideHiddenDirs() {
        return false;
    }

    @Override
    public boolean isHideEmptyDirs() {
        return false;
    }

    @Override
    public boolean isHideDeletedFiles() {
        return false;
    }

    @Override
    public boolean isContainsEmptyDirs() {
        return false;
    }

    @Override
    public List<DirNodeData> getNodes() {
        ArrayList<DirNodeData> list = new ArrayList<DirNodeData>();
        this.addNode(this.rootNode, list, 0);
        if (this.rootNode.getPath().isRoot()) {
            list.remove(this.rootNode);
        }
        return list;
    }

    private void addNode(DirNodeData node, List<DirNodeData> list, int treeLevel) {
        list.add(node);
        node.setTreeLevel(treeLevel);
        if (node.getSubDirs() != null) {
            for (DirNodeData n2 : node.getSubDirs()) {
                this.addNode(n2, list, treeLevel + 1);
            }
        }
    }

    @Override
    public List<DirNodeData> getParentNode() {
        if (this.parentNode == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.parentNode);
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    @Override
    public Path getRootPath() {
        return this.rootPath;
    }

    @Override
    public Path getSelectedPath() {
        return this.selectedPath;
    }

    @Override
    public long getActualTreeBuildTime() {
        return 0L;
    }

    @Override
    public boolean isRepoMayHide() {
        return false;
    }

    @Override
    public int getNumberOfNodes() {
        return this.nodeCount;
    }
}

