/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.scm;

import com.atlassian.crucible.explorers.ChangeSetDO;
import com.atlassian.crucible.explorers.ChangeSetItemDO;
import com.atlassian.crucible.explorers.ChangelogExplorer;
import com.atlassian.crucible.scm.ChangeSet;
import com.atlassian.crucible.scm.ChangelogBrowser;
import com.atlassian.crucible.scm.RevisionKey;
import com.atlassian.fisheye.scm.SCMSource;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.web.WaybackSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SCMChangelogExplorer
implements ChangelogExplorer {
    private final SCMSource source;
    private final Path path;
    private final WaybackSpec wbSpec;
    private final Review review;
    private final ChangelogBrowser browser;
    private final ContentManager contentManager;
    private String fromId;
    private boolean includeFrom;
    private String toId;
    private boolean includeTo;
    private List<String> committers;
    private List<ChangeSetDO> changeSets;
    private String nextInFuture;
    private String nextInPast;
    private boolean nextInFutureIsInc = false;
    private boolean nextInPastIsInc = false;
    private CommitterUserMappingManager committerUserMappingManager;

    public SCMChangelogExplorer(SCMSource source, Path path, WaybackSpec wbSpec, Review review, ChangelogBrowser browser, ContentManager contentManager, CommitterUserMappingManager committerUserMappingManager) {
        this.source = source;
        this.path = path;
        this.wbSpec = wbSpec;
        this.review = review;
        this.browser = browser;
        this.contentManager = contentManager;
        this.committerUserMappingManager = committerUserMappingManager;
    }

    @Override
    public void setFromChangeSetId(String fromid) {
        this.fromId = fromid;
    }

    @Override
    public void setFromChangeSetIdInc(boolean inc) {
        this.includeFrom = inc;
    }

    @Override
    public void setToChangeSetId(String toid) {
        this.toId = toid;
    }

    @Override
    public void setToChangeSetIdInc(boolean inc) {
        this.includeTo = inc;
    }

    @Override
    public void setCommitters(List<String> committers) {
        this.committers = committers;
    }

    @Override
    public void computeData(int perPage) throws DbException {
        ChangelogBrowser.ChangeSets changes = this.browser.listChanges(this.source.getPrincipal(), this.path.getPath(), this.fromId, this.includeFrom, this.toId, this.includeTo, perPage);
        List list = changes.getChangeSets();
        this.changeSets = new ArrayList<ChangeSetDO>(list.size());
        HashMap<RevInfoKey, CrucibleRevision> existingRevisions = new HashMap<RevInfoKey, CrucibleRevision>();
        for (FileRevisionExtraInfo frx : this.review.getFrxs()) {
            for (int i2 = 1; i2 < frx.getCrucibleRevisions().size(); ++i2) {
                existingRevisions.put(frx.getCrucibleRevisions().get(i2).getRevInfoKey(), frx.getCrucibleRevisions().get(i2));
            }
            if (Boolean.TRUE.equals(frx.getShowAsDiff()) || frx.getFromRevision() == null) continue;
            existingRevisions.put(frx.getFromRevision().getRevInfoKey(), frx.getFromRevision());
        }
        for (ChangeSet changeSet : list) {
            RevInfoKey rik;
            ArrayList<ChangeSetItemDO> items = new ArrayList<ChangeSetItemDO>();
            int itemCount = changeSet.getRevisions().size();
            HashMap<RevisionKey, RevInfoKey> revKeyMap = new HashMap<RevisionKey, RevInfoKey>();
            for (RevisionKey rk : changeSet.getRevisions()) {
                rik = new RevInfoKey(rk);
                revKeyMap.put(rk, rik);
            }
            for (RevisionKey rk : changeSet.getRevisions()) {
                rik = (RevInfoKey)revKeyMap.get(rk);
                CrucibleRevision cruRev = (CrucibleRevision)existingRevisions.get(rik);
                boolean inThisReview = false;
                if (cruRev != null) {
                    inThisReview = true;
                }
                items.add(new ChangeSetItemDO(cruRev, inThisReview));
            }
            this.changeSets.add(new ChangeSetDO(items, this.committerUserMappingManager, itemCount, changeSet.getCsid(), changeSet.getAuthor(), changeSet.getComment(), changeSet.getDate(), ChangeSetDO.MetadataChange.NONE, this.isFisheyeExplorer(), this.source, this.review));
        }
        if (this.changeSets.isEmpty()) {
            this.nextInFuture = this.toId;
            this.nextInFutureIsInc = true;
            this.nextInPast = this.fromId;
            this.nextInPastIsInc = true;
        } else {
            if (changes.isNewerChangeSetsExist()) {
                this.nextInFuture = this.changeSets.get(0).getId();
            }
            if (changes.isOlderChangeSetsExist()) {
                this.nextInPast = this.changeSets.get(this.changeSets.size() - 1).getId();
            }
        }
    }

    @Override
    public List<ChangeSetDO> getChangesets() throws DbException {
        return this.changeSets;
    }

    @Override
    public String getNextInPast() {
        return this.nextInPast;
    }

    @Override
    public String getNextInFuture() {
        return this.nextInFuture;
    }

    @Override
    public boolean isNextInFutureIsInc() {
        return this.nextInFutureIsInc;
    }

    @Override
    public boolean isNextInPastIsInc() {
        return this.nextInPastIsInc;
    }

    @Override
    public List<String> getCommitters() {
        return this.committers;
    }

    @Override
    public boolean isFisheyeExplorer() {
        return false;
    }
}

