/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.scm;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class LoggingInvocationHandler
implements InvocationHandler {
    private final Logger log;
    private final Object target;

    public LoggingInvocationHandler(Logger log, Object target) {
        this.log = log;
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName());
        if (args != null) {
            sb.append(Arrays.toString(args));
        }
        try {
            Object result = method.invoke(this.target, args);
            sb.append(" = ").append(String.valueOf(result));
            Object object = result;
            return object;
        }
        catch (InvocationTargetException e2) {
            sb.append(" threw ").append(e2.getCause().toString());
            throw e2.getCause();
        }
        finally {
            this.log.debug((Object)sb);
        }
    }
}

