/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.scm;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.util.Pair;
import java.util.ArrayList;
import java.util.List;

public class DirNodeData {
    private boolean emptyOfFiles;
    private Path path;
    private List<DirNodeData> subDirs;
    private final Path selectedPath;
    private final String latestRev;
    private final boolean file;
    private boolean deleted;
    private final boolean binaryFile;
    private final int rootOffset;
    private final boolean hidden;
    private DirNodeData parent;
    private int treeLevel;
    private Pair<String, String>[] attrs;

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public DirNodeData(Path path, boolean emptyOfFiles, boolean hidden, DirNodeData parent, int rootOffset, Path selectedPath, String latestRev, boolean isFile, boolean deleted, boolean binaryFile, Pair<String, String> ... attrs) {
        this.emptyOfFiles = emptyOfFiles;
        this.path = path;
        this.hidden = hidden;
        this.parent = parent;
        this.rootOffset = rootOffset;
        this.selectedPath = selectedPath;
        this.latestRev = latestRev;
        this.file = isFile;
        this.deleted = deleted;
        this.binaryFile = binaryFile;
        this.attrs = attrs;
        this.subDirs = new ArrayList<DirNodeData>();
    }

    public DirNodeData(Path path, boolean emptyOfFiles, boolean hidden, DirNodeData parent, int rootOffset, Path selectedPath, Pair<String, String> ... attrs) {
        this(path, emptyOfFiles, hidden, parent, rootOffset, selectedPath, null, false, false, false, attrs);
    }

    public DirNodeData(Path path, boolean emptyOfFiles, boolean hidden, DirNodeData parent, int rootOffset, Path selectedPath, boolean isFile, boolean deleted, boolean binaryFile, Pair<String, String> ... attrs) {
        this(path, emptyOfFiles, hidden, parent, rootOffset, selectedPath, null, isFile, deleted, binaryFile, attrs);
    }

    public Path getPath() {
        return this.path;
    }

    public Pair<String, String>[] getAttrs() {
        return this.attrs;
    }

    public Integer getId() {
        return Math.abs(this.path.hashCode());
    }

    public List<DirNodeData> getSubDirs() {
        return this.subDirs;
    }

    public boolean isEmptyOfFiles() {
        return this.emptyOfFiles && !this.file;
    }

    public void setEmptyOfFiles(boolean emptyOfFiles) {
        this.emptyOfFiles = emptyOfFiles;
    }

    public DirNodeData getParent() {
        return this.parent;
    }

    public int getDepth() {
        if (this.parent == null) {
            return this.rootOffset;
        }
        return this.parent.getPath().numComponents() + 1;
    }

    public void setSubDirs(List<DirNodeData> subDirs) {
        this.subDirs = subDirs;
    }

    public boolean isFilled() {
        return this.subDirs != null && this.subDirs.size() > 0;
    }

    public int getTreeLevel() {
        return this.treeLevel;
    }

    public void setTreeLevel(int treeLevel) {
        this.treeLevel = treeLevel;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public boolean isOnSelectedPath() {
        return this.selectedPath != null && this.path.isAncestor(this.selectedPath);
    }

    public boolean isAtSelectedPath() {
        return this.selectedPath != null && (this.path.equals(this.selectedPath) || this.selectedPath.isAncestor(this.path) && this.path.getCommonRoot(this.selectedPath).numComponents() >= this.getDepth());
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isFile() {
        return this.file;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isBinaryFile() {
        return this.binaryFile;
    }

    public void setParent(DirNodeData parent) {
        this.parent = parent;
    }

    public String getSuffix() {
        if (this.isFile()) {
            String extension = this.getPath().getExtension();
            return extension == null ? "" : extension;
        }
        return "";
    }

    public String getLatestRev() {
        return this.latestRev;
    }
}

