/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.scm;

import com.atlassian.crucible.scm.SCMModule;
import com.atlassian.crucible.scm.SCMRepository;
import com.atlassian.event.api.EventListener;
import com.atlassian.fisheye.plugin.descriptor.SCMModuleDescriptor;
import com.atlassian.fisheye.scm.LoggingInvocationHandler;
import com.atlassian.fisheye.scm.SCMModuleManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.cenqua.fisheye.logging.Logs;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="scmModuleManager")
@AvailableToPlugins(value=SCMModuleManager.class)
public class DefaultSCMModuleManager
implements SCMModuleManager {
    private static Logger log = Logger.getLogger(DefaultSCMModuleManager.class);
    private final PluginAccessor pluginAccessor;
    private final ResettableLazyReference<Collection<SCMModule>> modules = new ResettableLazyReference<Collection<SCMModule>>(){

        protected Collection<SCMModule> create() throws Exception {
            return DefaultSCMModuleManager.this.getModulesImpl();
        }
    };

    @Autowired
    public DefaultSCMModuleManager(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @EventListener
    public void flush(PluginEnabledEvent e2) {
        this.modules.reset();
    }

    @EventListener
    public void flush(PluginDisabledEvent e2) {
        this.modules.reset();
    }

    @EventListener
    public void flush(PluginUpgradedEvent e2) {
        this.modules.reset();
    }

    @EventListener
    public void flush(PluginUninstalledEvent e2) {
        this.modules.reset();
    }

    @EventListener
    public void flush(PluginRefreshedEvent e2) {
        this.modules.reset();
    }

    @Override
    public Collection<SCMModule> getModules() {
        return (Collection)this.modules.get();
    }

    private Collection<SCMModule> getModulesImpl() {
        HashSet<SCMModule> modules = new HashSet<SCMModule>();
        for (SCMModuleDescriptor d2 : this.pluginAccessor.getEnabledModuleDescriptorsByClass(SCMModuleDescriptor.class)) {
            try {
                modules.add(d2.getModule());
            }
            catch (Throwable t2) {
                log.error((Object)("Error getting module for SCMModuleDescriptor " + d2.getCompleteKey()), t2);
            }
        }
        return modules;
    }

    @Override
    public Collection<SCMRepository> getRepositories() {
        HashSet<SCMRepository> repos = new HashSet<SCMRepository>();
        for (SCMModule m2 : this.getModules()) {
            repos.addAll(this.getRepositories(m2));
        }
        return repos;
    }

    @Override
    public SCMRepository getRepository(String sourceName) {
        for (SCMModule sm : this.getModules()) {
            for (SCMRepository repo : this.getRepositories(sm)) {
                if (!repo.getName().equals(sourceName)) continue;
                return repo;
            }
        }
        return null;
    }

    private Collection<SCMRepository> getRepositories(SCMModule sm) {
        try {
            Collection repos = sm.getRepositories();
            if (Logs.APP_LOG.isDebugEnabled()) {
                ArrayList<SCMRepository> debugRepos = new ArrayList<SCMRepository>();
                for (SCMRepository r2 : repos) {
                    debugRepos.add(this.createLoggingSCMRepository(r2));
                }
                return debugRepos;
            }
            return repos;
        }
        catch (Throwable e2) {
            Logs.APP_LOG.error((Object)("problem getting repositories for SCMModule " + sm.getName()), e2);
            return Collections.emptyList();
        }
    }

    private Class[] getAllInterfaces(Class c2) {
        List interfaces = ClassUtils.getAllInterfaces((Class)c2);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    private SCMRepository createLoggingSCMRepository(SCMRepository target) {
        return (SCMRepository)Proxy.newProxyInstance(target.getClass().getClassLoader(), this.getAllInterfaces(target.getClass()), (InvocationHandler)new LoggingInvocationHandler(Logs.APP_LOG, target){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = super.invoke(proxy, method, args);
                if (method.getName().equals("getChangelogBrowser") || method.getName().equals("getDirectoryBrowser")) {
                    return Proxy.newProxyInstance(result.getClass().getClassLoader(), DefaultSCMModuleManager.this.getAllInterfaces(result.getClass()), (InvocationHandler)new LoggingInvocationHandler(Logs.APP_LOG, result));
                }
                return result;
            }
        });
    }
}

