/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.scm;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.web.CommandString;
import java.util.Arrays;
import java.util.List;

public class CruciblePathInfo {
    private final String repname;
    private final Path fullpath;
    private final Path localpath;
    private final CommandString commandString;
    private final boolean empty;

    public CruciblePathInfo(String path) {
        Path pi = path == null ? Path.ROOT : new Path(path).simplify();
        if (pi.numComponents() > 0 && pi.getComponent(0).startsWith("~")) {
            String cmdStr = pi.getComponent(0);
            this.commandString = new CommandString(cmdStr.substring("~".length()));
            pi = pi.trimFirst();
        } else {
            this.commandString = null;
        }
        List<String> allParts = Arrays.asList(pi.getComponents());
        if (allParts.size() == 0) {
            this.fullpath = Path.ROOT;
            this.localpath = Path.ROOT;
            this.repname = null;
            this.empty = true;
        } else {
            this.repname = pi.getComponent(0);
            this.fullpath = pi;
            this.localpath = pi.trimFirst();
            this.empty = false;
        }
    }

    public Path getLocalPath() {
        return this.localpath;
    }

    public Path getFullPath() {
        return this.fullpath;
    }

    public String getSourceName() {
        return this.repname;
    }

    public CommandString getCommandString() {
        return this.commandString;
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

