/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.quicksearch.action;

public final class SearchMessage {
    private final String title;
    private final String text;
    private final String subText;
    private final boolean isLink;
    private final MessageStatus status;

    public SearchMessage(String text) {
        this(null, text, null, MessageStatus.INFO, true);
    }

    public SearchMessage(String text, MessageStatus status) {
        this(null, text, null, status, true);
    }

    public SearchMessage(String title, String text, String subText, MessageStatus status, boolean isLink) {
        this.title = title;
        this.text = text;
        this.subText = subText;
        this.status = status;
        this.isLink = isLink;
    }

    public SearchMessage(String text, String subText, MessageStatus status) {
        this(null, text, subText, status, true);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isLink() {
        return this.isLink;
    }

    public String getText() {
        return this.text;
    }

    public String getSubText() {
        return this.subText;
    }

    public boolean isError() {
        return MessageStatus.ERROR.equals((Object)this.status);
    }

    public boolean isWarning() {
        return MessageStatus.WARNING.equals((Object)this.status);
    }

    public String toString() {
        return this.text;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SearchMessage that = (SearchMessage)o2;
        if (this.isLink != that.isLink) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        if (this.subText != null ? !this.subText.equals(that.subText) : that.subText != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        return !(this.title != null ? !this.title.equals(that.title) : that.title != null);
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.subText != null ? this.subText.hashCode() : 0);
        result = 31 * result + (this.isLink ? 1 : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }

    public static enum MessageStatus {
        ERROR,
        WARNING,
        INFO;

    }
}

