/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.quicksearch.action;

import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.quicksearch.action.SearchInterceptor;
import com.atlassian.fisheye.web.NavBuilder;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ReviewKeyInterceptor
implements SearchInterceptor {
    @Resource
    private ReviewManager reviewManager;
    @Resource
    private ProjectManager projectManager;
    @Resource
    private EffectiveUserProvider effectiveUserProvider;
    @Resource
    private PermissionManager permissionManager;

    @Override
    public String getRedirectPath(String query, SearchScope scope) {
        Project project;
        PermaIdKey key = this.reviewManager.parsePermaId(query);
        if (key != null && (project = this.projectManager.getProjectByKey(key.getProjKey())) != null && this.reviewManager.reviewExists(key)) {
            Review review = this.reviewManager.getReviewByPermaId(key);
            Principal principal = this.effectiveUserProvider.getEffectivePrincipal();
            if (this.permissionManager.canPrincipalDoAction(project.getPermissionScheme(), principal, null, UserActionManager.ACTION_VIEW, review)) {
                return NavBuilder.review(review);
            }
        }
        return null;
    }
}

