/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.quicksearch.action;

import com.atlassian.fecru.search.common.api.QuickSearchService;
import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.api.SearchGroup;
import com.atlassian.fecru.search.common.api.SearchResult;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchResultsGroup;
import com.atlassian.fecru.search.common.api.SearchResultsGroups;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.quicksearch.action.HintParser;
import com.atlassian.fisheye.quicksearch.action.Licenses;
import com.atlassian.fisheye.quicksearch.action.SearchInterceptor;
import com.atlassian.fisheye.quicksearch.action.SearchMessage;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.atlassian.fisheye.stars.StarManager;
import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.Star;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.atlassian.fisheye.user.RecentlyVisitedManager;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.atlassian.fisheye.user.model.RecentlyVisitedRepository;
import com.atlassian.fugue.Option;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.util.HelpUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.ping.CrossRepositoryRescanRequest;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.paging.PagingCalculator;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.xwork.ActionSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class QuickSearchAction
extends ActionSupport {
    private static final SearchType DEFAULT_FISHEYE_TYPE = SearchType.FILE_PATHS;
    private static final SearchType DEFAULT_CRUCIBLE_TYPE = SearchType.REVIEW_DETAILS;
    private static final int RESULT_PER_PAGE = 10;
    private static final String SUCCESS_COUNTS = "success-count";
    private static final String SUCCESS_RESULTS = "success-results";
    private static final String SUCCESS_REDIRECT = "redirect";
    protected static final int SLURPING_REPO_WARNING_MAX_COUNT = 10;
    protected static final String ERROR_JSON = "error-json";
    private String query = "";
    private static final Set<SearchType> TIME_FILTER_SEARCH_TYPES = ImmutableSet.of((Object)((Object)SearchType.FILE_PATHS), (Object)((Object)SearchType.CHANGESET_COMMENTS), (Object)((Object)SearchType.CHANGESET_DIFFS), (Object)((Object)SearchType.CONTENT), (Object)((Object)SearchType.REVIEW_DETAILS), (Object)((Object)SearchType.REVIEW_COMMENTS), (Object[])new SearchType[0]);
    private QuickSearchTimeBucket timeBucket = QuickSearchTimeBucket.ANY_DATE;
    private static final Set<SearchType> USER_FILTER_SEARCH_TYPES = ImmutableSet.of((Object)((Object)SearchType.CHANGESET_COMMENTS), (Object)((Object)SearchType.REVIEW_COMMENTS), (Object)((Object)SearchType.REVIEW_DETAILS));
    private String userFilter;
    private SearchType type;
    private int page = 1;
    private String repository;
    private String projectKey;
    private boolean countsOnly = false;
    private boolean enableRedirection = false;
    private String redirectPath;
    private SearchResultsGroups results = new SearchResultsGroups();
    private int totalNumberOfResults = 0;
    private final long startTime = System.currentTimeMillis();
    private List<RepositoryHandle> repositories;
    private List<SearchMessage> messages = new ArrayList<SearchMessage>(0);
    private String countsOnlyJson;
    @Resource
    private QuickSearchService quickSearchService;
    private Collection<SearchInterceptor> searchInterceptors;
    @Resource
    private RepositoryManager repositoryManager;
    @Resource
    private UserManager userManager;
    @Resource
    private EffectiveUserProvider userProvider;
    @Resource
    private RecentlyVisitedManager recentlyVisitedManager;
    @Resource
    private StarManager starManager;
    private IndexingStatus indexingStatus;
    private SearchSortOrder sortOrder = SearchSortOrder.BY_SCORE;
    private HintParser hintParser;
    private boolean resultsOnly;
    private Option<Integer> starId;
    private final Iterable<SearchType> qsSearchTypes = ImmutableList.copyOf((Iterable)Iterables.filter(Licenses.allowedSearchTypes(), (Predicate)new Predicate<SearchType>(){

        public boolean apply(SearchType input) {
            return input.getGroup() != SearchGroup.QUICKNAV;
        }
    }));
    private int limitedRepos;
    private boolean ignoreReposLimit;
    private boolean worked = true;

    @Resource
    public void setSearchInterceptors(Collection<SearchInterceptor> interceptors) {
        this.searchInterceptors = interceptors;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        boolean isHtmlRequest = !this.resultsOnly && !this.countsOnly;
        try {
            this.type = this.getAndCheckType();
            if (this.sortOrder == null || !ArrayUtils.contains((Object[])this.type.getSortOrders(), (Object)((Object)this.sortOrder))) {
                this.sortOrder = SearchSortOrder.BY_SCORE;
            }
            this.addRecentlyVisitedRepository();
            this.handleHint();
            List<RepositoryHandle> repositories = this.getSearchableRepositories();
            SearchScope.SearchScopeBuilder searchScopeBuilder = this.newSearchScopeBuilder(repositories, this.projectKey, this.hintParser);
            if (this.enableRedirection && this.searchInterceptors != null) {
                for (SearchInterceptor interceptor : this.searchInterceptors) {
                    String redirectPath = interceptor.getRedirectPath(this.query, searchScopeBuilder.build());
                    if (redirectPath == null) continue;
                    this.redirectPath = redirectPath;
                    return isHtmlRequest ? SUCCESS_REDIRECT : SUCCESS_RESULTS;
                }
            }
            if (isHtmlRequest) {
                this.generateEmptyPage();
                return "success";
            }
            this.prepareNotifications(repositories, this.getIndexingStatus());
            if (this.countsOnly) {
                return this.searchForCountsOnly(searchScopeBuilder);
            }
            return this.search(searchScopeBuilder);
        }
        catch (Exception e2) {
            if (isHtmlRequest) {
                throw e2;
            }
            return this.isTooManyFilesException(e2) ? this.handleTooManyFileException() : this.handleError(e2);
        }
    }

    private void generateEmptyPage() {
        if (Licenses.isAllowed(SearchGroup.SOURCE)) {
            this.generateEmptyResults(SearchGroup.SOURCE, this.repository);
        }
        if (Licenses.isAllowed(SearchGroup.REVIEWS)) {
            this.generateEmptyResults(SearchGroup.REVIEWS, this.projectKey);
        }
    }

    private SearchType getAndCheckType() {
        if (this.type == null || !Licenses.isAllowed(this.type)) {
            return AppConfig.isFishEye() ? DEFAULT_FISHEYE_TYPE : DEFAULT_CRUCIBLE_TYPE;
        }
        return this.type;
    }

    private String searchForCountsOnly(SearchScope.SearchScopeBuilder searchScopeBuilder) {
        JSONObject json = new JSONObject();
        Iterable countTypes = Iterables.filter(this.qsSearchTypes, (Predicate)new Predicate<SearchType>(){

            public boolean apply(SearchType input) {
                return QuickSearchAction.this.type != input;
            }
        });
        Iterable<SearchResults<? extends SearchResult>> counts = this.quickSearchService.search(this.query, searchScopeBuilder.withCountOnly(true).build(), countTypes);
        for (SearchResults<? extends SearchResult> count : counts) {
            try {
                json.put(count.getSearchType().getName(), count.getTotalCount());
            }
            catch (JSONException e2) {
                Logs.APP_LOG.error((Object)("Error serializing counts for query: " + this.query + " - " + e2.getMessage()), (Throwable)e2);
            }
        }
        this.countsOnlyJson = json.toString();
        return SUCCESS_COUNTS;
    }

    private String search(SearchScope.SearchScopeBuilder searchScopeBuilder) {
        SearchResults searchResults = (SearchResults)Iterables.getOnlyElement(this.quickSearchService.search(this.query, searchScopeBuilder.withCountOnly(false).build(), Collections.singleton(this.type)));
        this.totalNumberOfResults = searchResults.getTotalCount();
        EnumMap results = new EnumMap(SearchType.class);
        for (SearchType type : this.qsSearchTypes) {
            results.put(type, searchResults.getSearchType() == type ? searchResults : new SearchResults(0, type));
        }
        ImmutableMap currentScopes = ImmutableMap.builder().put((Object)SearchGroup.REVIEWS, (Object)Strings.nullToEmpty((String)this.projectKey)).put((Object)SearchGroup.SOURCE, (Object)Strings.nullToEmpty((String)this.repository)).build();
        for (SearchGroup searchGroup : EnumSet.of(SearchGroup.SOURCE, SearchGroup.REVIEWS)) {
            if (!Licenses.isAllowed(searchGroup)) continue;
            SearchResultsGroup group = new SearchResultsGroup(searchGroup, results, (String)currentScopes.get((Object)searchGroup));
            this.results.addGroup(group);
        }
        return SUCCESS_RESULTS;
    }

    public String getRedirectPath() {
        return this.redirectPath;
    }

    public void setCountsOnly(boolean countsOnly) {
        this.countsOnly = countsOnly;
    }

    public String getCountsOnlyJson() {
        return this.countsOnlyJson;
    }

    private List<RepositoryHandle> getSearchableRepositories() {
        List<RepositoryHandle> searchableRepositories = Strings.isNullOrEmpty((String)this.repository) ? this.getRepositories() : this.filterRepositories(this.getRepository(this.repository));
        return searchableRepositories;
    }

    private void addRecentlyVisitedRepository() {
        if (StringUtils.isNotEmpty((String)this.repository)) {
            RepositoryHandle currentRepository = this.repositoryManager.getRepository(this.repository);
            FecruUser loggedInUser = this.userManager.getUserFor(this.userProvider.getEffectivePrincipal());
            if (loggedInUser != null && currentRepository != null) {
                this.recentlyVisitedManager.addItemToHistory(RecentlyVisitedItem.Type.REPOSITORY, loggedInUser, currentRepository.getName());
            }
        }
    }

    private void generateEmptyResults(SearchGroup group, String scope) {
        EnumMap results = new EnumMap(SearchType.class);
        for (SearchType searchType : this.qsSearchTypes) {
            if (searchType.getGroup() != group) continue;
            results.put(searchType, new SearchResults(0, searchType));
        }
        this.totalNumberOfResults = 0;
        this.results.addGroup(new SearchResultsGroup(group, results, scope));
    }

    private void handleHint() {
        this.hintParser = new HintParser(this.qsSearchTypes).parse(this.query);
        this.query = this.hintParser.getDisplayQuery();
        SearchType typeHint = this.hintParser.getHintType();
        if (typeHint != null) {
            this.type = typeHint;
        }
    }

    public void setQ(String query) {
        this.query = query != null ? query.trim() : query;
    }

    public void setT(String pageType) {
        this.type = SearchType.values()[Integer.parseInt(pageType)];
    }

    public void setS(String sortOrder) {
        if (!Strings.isNullOrEmpty((String)sortOrder)) {
            this.sortOrder = SearchSortOrder.values()[Integer.parseInt(sortOrder)];
        }
    }

    public void setR(boolean enableRedirection) {
        this.enableRedirection = enableRedirection;
    }

    public void setResultsOnly(boolean resultsOnly) {
        this.resultsOnly = resultsOnly;
    }

    public void setPage(int page) {
        if (page > 0) {
            this.page = page;
        }
    }

    SearchScope.SearchScopeBuilder newSearchScopeBuilder(List<RepositoryHandle> repoHandles, @Nullable String projectKey, HintParser hints) {
        int from = (this.page - 1) * 10;
        int to = this.page * 10;
        return SearchScope.builder().withFrom(from).withTo(to).withRepositories(repoHandles).withProjectKey(projectKey).withSort(this.sortOrder).withHints(hints).withHighlights(true).withTimeBucket(this.timeBucket).withUser(this.userFilter);
    }

    public String getQuery() {
        return this.query;
    }

    public SearchType getType() {
        return this.type;
    }

    public Map<Integer, String> getSortOrders() {
        return ImmutableMap.of((Object)SearchSortOrder.BY_SCORE.ordinal(), (Object)"By relevance", (Object)SearchSortOrder.TOWARDS_PAST.ordinal(), (Object)"By date");
    }

    public Map<String, String> getTimeBuckets() {
        return QuickSearchTimeBucket.MAP;
    }

    public double getTimeTaken() {
        return (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
    }

    public void setRepository(String repoName) {
        this.repository = repoName;
    }

    public String getRepository() {
        return this.repository;
    }

    public Integer getStarId() throws StarInvalidKeyException {
        if (this.starId == null) {
            UserLogin effectiveUserLogin = this.userProvider.getEffectiveUserLogin();
            if (effectiveUserLogin != null) {
                Star star = this.starManager.getStar(new StarKey(StarType.QUICKSEARCH.getName(), Strings.isNullOrEmpty((String)this.repository) ? "__ALL_REPOS__" : this.repository, this.query, null, null, null, null, null, null, null, null, null, null), effectiveUserLogin);
                this.starId = star == null ? Option.none() : Option.some((Object)star.getId());
            } else {
                this.starId = Option.none();
            }
        }
        return (Integer)this.starId.getOrNull();
    }

    public boolean isStarrable() {
        return this.userProvider.getEffectiveUserLogin() != null;
    }

    public String getAllReposStar() {
        return "__ALL_REPOS__";
    }

    public void setProject(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getProject() {
        return this.projectKey;
    }

    public boolean isConstrained() {
        return this.getConstraint() != null;
    }

    void prepareNotifications(Iterable<RepositoryHandle> repositories, IndexingStatus indexingStatus) {
        if (!indexingStatus.isConstraintPipelinedAndIndexing()) {
            ArrayList<String> slurpingRepositories = new ArrayList<String>();
            for (RepositoryHandle handle : repositories) {
                String name = handle.getName();
                if (!handle.getStatus().isInitialIndexingComplete() || CrossRepositoryRescanRequest.isRepositoryBeingReindexed(name)) {
                    slurpingRepositories.add(name);
                }
                if (slurpingRepositories.size() != 10) continue;
                break;
            }
            if (!slurpingRepositories.isEmpty()) {
                this.messages.add(new SearchMessage("Results might be incomplete", "The following repositor" + ExpressionUtil.pluralise("y", "ies", slurpingRepositories.size()) + " " + ExpressionUtil.pluralise("is", "are", slurpingRepositories.size()) + " still indexing, and might therefore deliver incomplete results:", StringUtils.join(slurpingRepositories, (String)", ") + (slurpingRepositories.size() == 10 ? "..." : ""), SearchMessage.MessageStatus.INFO, false));
            }
        } else if (!Iterables.isEmpty(repositories) && indexingStatus.isConstraintPipelinedAndIndexing() && indexingStatus.isConstraintSingleRepository()) {
            if (indexingStatus.isCurrentTabIncomplete()) {
                this.createIndexingWarningMessage(this.getRepository());
            } else {
                this.createIndexingHintMessage(this.getRepository());
            }
        }
        ArrayList ommittedFilters = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)this.userFilter) && !USER_FILTER_SEARCH_TYPES.contains((Object)this.getType())) {
            ommittedFilters.add("user");
        }
        if (this.timeBucket != QuickSearchTimeBucket.ANY_DATE && !TIME_FILTER_SEARCH_TYPES.contains((Object)this.getType())) {
            ommittedFilters.add("last modified");
        }
        if (!ommittedFilters.isEmpty()) {
            String message = String.format("The %s %s not available for %s search. Showing all results", Joiner.on((String)" and ").join((Iterable)ommittedFilters), ExpressionUtil.pluralise("filter is", "filters are", ommittedFilters.size()), this.getType().getDescriptionSingular().toLowerCase(Locale.US));
            this.messages.add(new SearchMessage(message));
        }
    }

    private void createIndexingHintMessage(String repoName) {
        this.messages.add(new SearchMessage("Results might be incomplete", "Scanning of repository '" + repoName + "' is complete, comprehensive indexing is in progress. Some details might be available later.", null, SearchMessage.MessageStatus.INFO, false));
    }

    private void createIndexingWarningMessage(String repoName) {
        this.messages.add(new SearchMessage("Results might be incomplete", "Repository '" + repoName + "' is still being indexed. Some of the results might not be available yet.", null, SearchMessage.MessageStatus.WARNING, false));
    }

    public IndexingStatus getIndexingStatus() {
        if (this.indexingStatus == null) {
            this.indexingStatus = this.calculateIndexingStatus();
        }
        return this.indexingStatus;
    }

    private IndexingStatus calculateIndexingStatus() {
        String constraint = this.getConstraint();
        if (constraint != null) {
            RepositoryHandle repositoryHandle;
            boolean isSingleRepository;
            boolean bl = isSingleRepository = this.getType().getGroup() == SearchGroup.SOURCE;
            if (isSingleRepository && (repositoryHandle = this.repositoryManager.getRepository(constraint)) != null) {
                RepositoryStatus status = repositoryHandle.getStatus();
                boolean isPipelinedAndIndexing = repositoryHandle.isPipelined() && status.isIndexing();
                boolean isCurrentTabIncomplete = isPipelinedAndIndexing && (status.isScanning() || this.getType().isAffectedByRepositoryIndexing() && status.isIndexing());
                return new IndexingStatus(isSingleRepository, isPipelinedAndIndexing, isCurrentTabIncomplete);
            }
        }
        return new IndexingStatus(false, false, false);
    }

    public String getConstraint() {
        return this.getType().getGroup() == SearchGroup.SOURCE ? this.getRepository() : this.getProject();
    }

    public String getRecentOrFirstRepository() {
        List recentRepos;
        Principal principal = this.userProvider.getEffectivePrincipal();
        List list = recentRepos = principal != null ? this.recentlyVisitedManager.getHistory(RecentlyVisitedItem.Type.REPOSITORY, principal) : Collections.emptyList();
        if (!recentRepos.isEmpty()) {
            RecentlyVisitedRepository visitedItem = (RecentlyVisitedRepository)recentRepos.get(0);
            return visitedItem.getEntity().getName();
        }
        if (!this.getRepositories().isEmpty()) {
            return this.getRepositories().get(0).getName();
        }
        return "";
    }

    public List<RepositoryHandle> getRepositories() {
        if (this.repositories == null) {
            this.repositories = this.filterRepositories(null);
        }
        return this.repositories;
    }

    public long getTotalNumberOfResults() {
        return this.totalNumberOfResults;
    }

    public SearchResultsGroups getResultsGroups() {
        return this.results;
    }

    public List<SearchMessage> getMessages() {
        return this.messages;
    }

    public PagingCalculator getPaging() {
        SearchResults<?> searchResults = this.results.getResults().get((Object)this.type);
        if (searchResults == null) {
            return TotalCountAwarePagingCalculator.getPagingCalculator(this.page, 0, 10);
        }
        return TotalCountAwarePagingCalculator.getPagingCalculator(this.page, searchResults.getTotalCount(), 10);
    }

    private List<RepositoryHandle> filterRepositories(List<RepositoryHandle> handles) {
        final ArrayList<RepositoryHandle> repositories = new ArrayList<RepositoryHandle>();
        StoppableVisitor<RepositoryHandle> visitor = new StoppableVisitor<RepositoryHandle>(){

            @Override
            public boolean visit(RepositoryHandle handle) {
                if (handle.isRunning()) {
                    repositories.add(handle);
                }
                if (!QuickSearchAction.this.ignoreReposLimit && QuickSearchAction.this.type.isLimitRepositoryCount() && repositories.size() >= FishEyeSysProps.SEARCH_MAX_REPOSITORIES) {
                    QuickSearchAction.this.limitedRepos = FishEyeSysProps.SEARCH_MAX_REPOSITORIES;
                    return false;
                }
                return true;
            }
        };
        if (handles != null) {
            RepositoryHandle handle;
            final Principal effectivePrincipal = this.userProvider.getEffectivePrincipal();
            Iterator iterator = Iterables.filter(handles, (Predicate)new Predicate<RepositoryHandle>(){

                public boolean apply(RepositoryHandle input) {
                    return QuickSearchAction.this.userManager.hasPermissionToAccess(effectivePrincipal, input);
                }
            }).iterator();
            while (iterator.hasNext() && visitor.visit(handle = (RepositoryHandle)iterator.next())) {
            }
        } else {
            this.repositoryManager.visitAccessibleRepositories(visitor);
        }
        return repositories;
    }

    private List<RepositoryHandle> getRepository(String repoName) {
        RepositoryHandle handle = this.repositoryManager.getRepository(repoName);
        if (handle == null) {
            SearchMessage message = new SearchMessage("The repository " + repoName + " was not found.", SearchMessage.MessageStatus.WARNING);
            this.messages.add(message);
            Logs.APP_LOG.info((Object)message);
            return Collections.emptyList();
        }
        if (!handle.isRunning()) {
            SearchMessage message = new SearchMessage("The repository " + repoName + " is currently not running. Please refer to your system administrator to enable it.", SearchMessage.MessageStatus.WARNING);
            this.messages.add(message);
            Logs.APP_LOG.info((Object)message);
            return Collections.emptyList();
        }
        return Collections.singletonList(handle);
    }

    private String handleError(Throwable e2) {
        String message = "Error while executing the search with '" + this.query + '\'';
        Logs.APP_LOG.error((Object)message, e2);
        this.messages.add(new SearchMessage(message, SearchMessage.MessageStatus.ERROR));
        this.worked = false;
        return ERROR_JSON;
    }

    protected String handleTooManyFileException() {
        String message = "It appears you have run out of file handles. This problem is easily fixed. Please consult the following Knowledge Base Article to learn how to increase the number of file handles for your OS.";
        String link = HelpUtil.getFishEyeHelpPath("fisheye.indexing.too.many.open.files");
        Logs.APP_LOG.error((Object)("It appears you have run out of file handles. This problem is easily fixed. Please consult the following Knowledge Base Article to learn how to increase the number of file handles for your OS. - " + link));
        this.messages.add(new SearchMessage("It appears you have run out of file handles. This problem is easily fixed. Please consult the following Knowledge Base Article to learn how to increase the number of file handles for your OS.", link, SearchMessage.MessageStatus.ERROR));
        this.worked = false;
        return ERROR_JSON;
    }

    private boolean isTooManyFilesException(Throwable e2) {
        while (e2 != null) {
            if (e2.getMessage() != null && e2.getMessage().contains("Too many open files")) {
                return true;
            }
            e2 = e2.getCause();
        }
        return false;
    }

    public SearchType getFILE_PATHS() {
        return SearchType.FILE_PATHS;
    }

    public SearchType getCHANGESET_COMMENTS() {
        return SearchType.CHANGESET_COMMENTS;
    }

    public SearchType getCHANGESET_DIFFS() {
        return SearchType.CHANGESET_DIFFS;
    }

    public SearchType getCONTENT() {
        return SearchType.CONTENT;
    }

    public SearchType getCOMMITTERS() {
        return SearchType.COMMITTERS;
    }

    public SearchType getREVIEW_DETAILS() {
        return SearchType.REVIEW_DETAILS;
    }

    public SearchType getREVIEW_COMMENTS() {
        return SearchType.REVIEW_COMMENTS;
    }

    public SearchGroup getSOURCE() {
        return SearchGroup.SOURCE;
    }

    public SearchGroup getREVIEWS() {
        return SearchGroup.REVIEWS;
    }

    public int getLimitedRepos() {
        return this.limitedRepos;
    }

    public void setIgnoreReposLimit(boolean ignoreReposLimit) {
        this.ignoreReposLimit = ignoreReposLimit;
    }

    public SearchSortOrder getSortOrder() {
        return this.sortOrder == null ? SearchSortOrder.BY_SCORE : this.sortOrder;
    }

    public int getSortOrderOrdinal() {
        return this.getSortOrder().ordinal();
    }

    public void setBucket(String timeBucket) {
        this.timeBucket = !Strings.isNullOrEmpty((String)timeBucket) ? QuickSearchTimeBucket.valueOf(timeBucket) : QuickSearchTimeBucket.ANY_DATE;
    }

    public String getTimeBucket() {
        return this.timeBucket.name();
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public String getUserFilterDisplayName() {
        FecruUser user;
        if (this.userFilter != null && (user = this.userManager.getUser(this.userFilter)) != null) {
            return user.getDisplayName();
        }
        return this.userFilter;
    }

    public boolean isWorked() {
        return this.worked;
    }

    public static class IndexingStatus {
        private final boolean isConstraintSingleRepository;
        private final boolean isConstraintPipelinedAndIndexing;
        private final boolean isCurrentTabIncomplete;

        public IndexingStatus(boolean constraintSingleRepository, boolean constraintPipelinedAndIndexing, boolean currentTabIncomplete) {
            this.isConstraintSingleRepository = constraintSingleRepository;
            this.isConstraintPipelinedAndIndexing = constraintPipelinedAndIndexing;
            this.isCurrentTabIncomplete = currentTabIncomplete;
        }

        public boolean isConstraintSingleRepository() {
            return this.isConstraintSingleRepository;
        }

        public boolean isConstraintPipelinedAndIndexing() {
            return this.isConstraintPipelinedAndIndexing;
        }

        public boolean isCurrentTabIncomplete() {
            return this.isCurrentTabIncomplete;
        }
    }
}

