/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.quicksearch.action;

import com.atlassian.fecru.search.common.api.SearchGroup;
import com.atlassian.fecru.search.common.api.SearchType;
import com.cenqua.fisheye.AppConfig;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;

public final class Licenses {
    public static boolean isAllowed(SearchType searchType) {
        switch (searchType) {
            case FILE_PATHS: 
            case CHANGESET_COMMENTS: 
            case CHANGESET_DIFFS: 
            case CONTENT: 
            case COMMITTERS: 
            case REPOSITORIES: {
                return AppConfig.isFishEye();
            }
            case REVIEW_DETAILS: 
            case REVIEW_COMMENTS: 
            case PROJECTS: {
                return AppConfig.isCrucible();
            }
            case USERS: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown search type: " + (Object)((Object)searchType));
    }

    public static Iterable<SearchType> allowedSearchTypes() {
        return Licenses.allowedSearchTypes(SearchType.ALL_SEARCH_TYPES);
    }

    public static Iterable<SearchType> allowedSearchTypes(Iterable<SearchType> fromTypes) {
        return Iterables.filter(fromTypes, (Predicate)new Predicate<SearchType>(){

            public boolean apply(SearchType input) {
                return Licenses.isAllowed(input);
            }
        });
    }

    static boolean isAllowed(SearchGroup searchGroup) {
        switch (searchGroup) {
            case SOURCE: {
                return AppConfig.isFishEye();
            }
            case REVIEWS: {
                return AppConfig.isCrucible();
            }
            case QUICKNAV: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown group: " + (Object)((Object)searchGroup));
    }
}

