/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.quicksearch.action;

import com.atlassian.fecru.search.common.api.SearchType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HintParser {
    private final Pattern searchtypeHint;
    private String query;
    private String displayQuery;
    private SearchType hintType;

    public HintParser(Iterable<SearchType> types) {
        Preconditions.checkArgument((boolean)types.iterator().hasNext());
        this.searchtypeHint = this.createPattern(types);
    }

    public HintParser parse(String userQuery) {
        Matcher matcher;
        this.query = userQuery;
        this.hintType = null;
        if (this.searchtypeHint != null && !Strings.isNullOrEmpty((String)this.query) && (matcher = this.searchtypeHint.matcher(this.query)).matches()) {
            this.hintType = SearchType.byHint(matcher.group(1));
            this.query = matcher.group(2);
        }
        this.displayQuery = this.query;
        return this;
    }

    private String withMatcher(Pattern pattern, Function<Matcher, String> onMatch) {
        Matcher matcher;
        String lastMatch = null;
        do {
            if (!(matcher = pattern.matcher(this.query)).matches()) continue;
            lastMatch = (String)onMatch.apply((Object)matcher);
        } while (matcher.matches());
        return lastMatch;
    }

    public String getQuery() {
        return this.query;
    }

    public SearchType getHintType() {
        return this.hintType;
    }

    private Pattern createPattern(Iterable<SearchType> types) {
        StringBuilder pattern = new StringBuilder("(");
        boolean hasPattern = false;
        for (SearchType type : types) {
            String hint = type.getHint();
            if (Strings.isNullOrEmpty((String)hint)) continue;
            pattern.append(hint).append('|');
            hasPattern = true;
        }
        if (!hasPattern) {
            return null;
        }
        pattern.setLength(pattern.length() - 1);
        pattern.append(")\\s*:\\s?(\\S.*)");
        return Pattern.compile(pattern.toString());
    }

    public String getDisplayQuery() {
        return this.displayQuery;
    }
}

