/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.quicksearch.action;

import com.atlassian.crucible.explorers.ChangeSetPair;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fisheye.quicksearch.action.SearchInterceptor;
import com.atlassian.fisheye.web.NavBuilder;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.crossrepo.ChangesetSearcher;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChangesetIdInterceptor
implements SearchInterceptor {
    private final ChangesetSearcher changesetSearcher;
    private static final Pattern SVN_P4_CSID_PATTERN = Pattern.compile("[0-9]+");
    private static final Pattern GIT_HG_CSID_PATTERN = Pattern.compile("^[0-9a-fA-F]{4,40}$");
    private static final Pattern CVS_CSID_PATTERN = Pattern.compile("^([^:]+):([^:]+):(\\d{1,14})(:(\\d+))?$");
    private static final EnumSet<ScmType> EXACT_MATCH_CSIDS_SCM_TYPES = EnumSet.of(ScmType.SVN, ScmType.P4);

    @Autowired
    public ChangesetIdInterceptor(ChangesetSearcher changesetSearcher) {
        this.changesetSearcher = changesetSearcher;
    }

    @Override
    public String getRedirectPath(String query, SearchScope scope) {
        if (Strings.isNullOrEmpty((String)query) || !SVN_P4_CSID_PATTERN.matcher(query).matches() && !GIT_HG_CSID_PATTERN.matcher(query).matches() && !CVS_CSID_PATTERN.matcher(query).matches()) {
            return null;
        }
        ChangesetQueryBuilder.QueryBuilder queryBuilder = ChangesetQueryBuilder.newCrossRepoBuilder();
        if (scope.getRepositories().size() == 0) {
            return null;
        }
        queryBuilder.fromTheseRepos(Collections2.transform(scope.getRepositories(), RepositoryHandle.TO_REPO_NAME));
        queryBuilder.withChangeSetId(query);
        List<ChangeSetPair> changesets = this.changesetSearcher.getChangesetsForQuery(queryBuilder, 2);
        ChangeSetPair bestMatch = (ChangeSetPair)Iterables.getFirst(changesets, null);
        if (bestMatch == null) {
            return null;
        }
        RepositoryHandle repo = scope.getRepositoryForName(bestMatch.getRepository());
        if (repo != null && EXACT_MATCH_CSIDS_SCM_TYPES.contains((Object)repo.getCfg().getRepositoryType()) && !Objects.equal((Object)bestMatch.getCsid(), (Object)query)) {
            return null;
        }
        if (changesets.size() == 2 && (!Objects.equal((Object)bestMatch.getCsid(), (Object)query) || Objects.equal((Object)changesets.get(1).getCsid(), (Object)query))) {
            return null;
        }
        return NavBuilder.changeset(bestMatch.getRepository(), bestMatch.getCsid());
    }
}

