/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.quartz;

import com.atlassian.fisheye.quartz.JobInfo;
import com.atlassian.fisheye.quartz.QuartzManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.springframework.stereotype.Service;

@Service(value="quartzManager")
public class DefaultQuartzManager
implements QuartzManager {
    private static final String TRIGGER_PREFIX = "trigger.";
    private static final String FILE_NAME = "quartzcron.properties";
    private File file;
    private Properties props;
    private File dir = new File(AppConfig.getInstanceDir(), "var/data");
    @Resource(name="quartzScheduler")
    private Scheduler quartzScheduler;

    protected void setDir(File dir) {
        this.dir = dir;
    }

    @Override
    public synchronized void start() throws IOException, SchedulerException {
        try {
            if (this.props != null) {
                this.resumeScheduler();
                return;
            }
            this.props = new Properties();
            this.file = new File(this.dir, FILE_NAME);
            if (this.file.exists()) {
                FileInputStream in = new FileInputStream(this.file);
                try {
                    this.props.load(in);
                }
                catch (Throwable throwable) {
                    IOHelper.close(in);
                    throw throwable;
                }
                IOHelper.close(in);
            }
            HashSet<Object> badKeys = new HashSet<Object>();
            for (Object key : this.props.keySet()) {
                try {
                    int separator = ((String)key).indexOf(";");
                    String jobName = ((String)key).substring(0, separator);
                    String groupName = ((String)key).substring(separator + 1);
                    String value = this.props.getProperty((String)key);
                    separator = value.indexOf(";");
                    String cronExp = value.substring(0, separator);
                    String className = value.substring(separator + 1);
                    this.registerJob(jobName, groupName, cronExp, className, false);
                }
                catch (Exception e2) {
                    badKeys.add(key);
                    Logs.APP_LOG.debug((Object)("Error scheduling: " + e2.getMessage()), (Throwable)e2);
                }
            }
            if (!badKeys.isEmpty()) {
                for (Object key : badKeys) {
                    this.props.remove(key);
                }
                this.writeProperties();
            }
            this.quartzScheduler.start();
        }
        catch (IOException e3) {
            Logs.APP_LOG.error((Object)("Could not read scheduler config: " + e3.getMessage()), (Throwable)e3);
            throw new RuntimeException(e3);
        }
        catch (SchedulerException e4) {
            Logs.APP_LOG.error((Object)("Could not start quartz scheduler: " + e4.getMessage()), (Throwable)e4);
            throw new RuntimeException(e4);
        }
    }

    @Override
    public void registerJob(String jobName, String groupName, String cronExp, String className, boolean write) throws SchedulerException, IllegalArgumentException, ClassNotFoundException {
        this.props.setProperty(jobName + ";" + groupName, cronExp + ";" + className);
        Class<?> clazz = Class.forName(className);
        try {
            this.scheduleCronJob(jobName, groupName, clazz, cronExp, true);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Error parsing cron expression: " + cronExp, pe);
        }
        if (write) {
            this.writeProperties();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void writeProperties() {
        FileOutputStream out = null;
        try {
            if (this.file != null && (this.file.exists() || this.file.createNewFile()) && this.file.canWrite()) {
                out = new FileOutputStream(this.file);
                this.props.store(out, null);
            } else {
                Logs.APP_LOG.warn((Object)("Could not save cron properties file " + (this.file == null ? "'null'" : this.file.getAbsolutePath())));
            }
            if (out == null) return;
        }
        catch (IOException e2) {
            try {
                Logs.APP_LOG.warn((Object)("Error saving cron properties file " + this.file.getAbsolutePath()));
                Logs.APP_LOG.debug((Object)"Error saving cron properties file ", (Throwable)e2);
                if (out == null) return;
            }
            catch (Throwable throwable) {
                if (out == null) throw throwable;
                IOHelper.close(out);
                throw throwable;
            }
            IOHelper.close(out);
            return;
        }
        IOHelper.close(out);
        return;
    }

    @Override
    public List<JobInfo> getSystemJobs() throws SchedulerException {
        ArrayList<JobInfo> jobs = new ArrayList<JobInfo>();
        for (String groupName : this.quartzScheduler.getJobGroupNames()) {
            if (!"system".equals(groupName)) continue;
            for (String jobName : this.quartzScheduler.getJobNames(groupName)) {
                JobInfo jobInfo = this.getJobInfo(jobName, groupName);
                if (jobInfo == null) continue;
                jobs.add(jobInfo);
            }
        }
        return jobs;
    }

    @Override
    public List<JobInfo> getAllJobs() throws SchedulerException {
        ArrayList<JobInfo> jobs = new ArrayList<JobInfo>();
        for (String groupName : this.quartzScheduler.getJobGroupNames()) {
            if ("system".equals(groupName)) continue;
            for (String jobName : this.quartzScheduler.getJobNames(groupName)) {
                JobInfo jobInfo = this.getJobInfo(jobName, groupName);
                if (jobInfo == null) continue;
                jobs.add(jobInfo);
            }
        }
        return jobs;
    }

    @Override
    public void pauseScheduler() throws SchedulerException {
        this.writeProperties();
        this.quartzScheduler.pauseAll();
        while (this.quartzScheduler.getCurrentlyExecutingJobs().size() > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e2) {
                break;
            }
        }
    }

    @Override
    public void resumeScheduler() throws SchedulerException {
        this.quartzScheduler.resumeAll();
    }

    @Override
    public Scheduler getQuartzScheduler() {
        return this.quartzScheduler;
    }

    @Override
    public void setQuartzScheduler(Scheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
    }

    @Override
    public void triggerJob(String jobName, String groupName) throws SchedulerException {
        Trigger trigger = this.quartzScheduler.getTrigger(TRIGGER_PREFIX + jobName, groupName);
        if (trigger != null) {
            this.quartzScheduler.triggerJob(jobName, groupName);
            if (trigger instanceof SimpleTrigger) {
                this.quartzScheduler.unscheduleJob(TRIGGER_PREFIX + jobName, groupName);
            }
        }
    }

    @Override
    public JobInfo getJobInfo(String jobName, String groupName) throws SchedulerException {
        JobDetail job = this.quartzScheduler.getJobDetail(jobName, groupName);
        Trigger trigger = this.quartzScheduler.getTrigger(TRIGGER_PREFIX + jobName, groupName);
        if (trigger != null) {
            String cronExp = "";
            if (trigger instanceof CronTrigger) {
                cronExp = ((CronTrigger)trigger).getCronExpression();
            }
            return new JobInfo(job, trigger, cronExp);
        }
        return null;
    }

    @Override
    public boolean scheduleCronJob(String jobName, String groupName, Class<? extends Job> jobClass, String cronExp, boolean overwrite) throws SchedulerException, ParseException {
        return this.scheduleCronJob(jobName, groupName, jobClass, cronExp, overwrite, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean scheduleCronJob(String jobName, String groupName, Class<? extends Job> jobClass, String cronExp, boolean overwrite, Map<String, Object> jobData) throws SchedulerException, ParseException {
        CronTrigger trigger = new CronTrigger(TRIGGER_PREFIX + jobName, groupName, jobName, groupName, cronExp, this.getTimeZone());
        trigger.setMisfireInstruction(2);
        Trigger oldTrigger = this.quartzScheduler.getTrigger(TRIGGER_PREFIX + jobName, groupName);
        JobDetail job = this.quartzScheduler.getJobDetail(jobName, groupName);
        if (job != null) {
            if (!overwrite) {
                this.resumeJob(jobName, groupName);
                return false;
            }
            this.quartzScheduler.unscheduleJob(TRIGGER_PREFIX + jobName, groupName);
            Logs.APP_LOG.debug((Object)("Rescheduling " + jobName + " " + groupName + " from"));
        } else {
            job = new JobDetail(jobName, groupName, jobClass);
        }
        this.setJobData(job, jobData);
        try {
            this.quartzScheduler.scheduleJob(job, (Trigger)trigger);
        }
        catch (SchedulerException se) {
            this.quartzScheduler.scheduleJob(job, oldTrigger);
            throw se;
        }
        if (!"system".equals(groupName)) {
            this.props.setProperty(jobName + ";" + groupName, cronExp + ";" + jobClass.getCanonicalName());
            this.writeProperties();
        }
        return true;
    }

    private void setJobData(JobDetail job, Map<String, Object> jobData) {
        if (jobData != null) {
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.setAllowsTransientData(true);
            jobDataMap.putAll(jobData);
            job.setJobDataMap(jobDataMap);
        }
    }

    @Override
    public void scheduleOneOffJob(String jobName, String groupName, Class jobClass, Date date) throws SchedulerException {
        JobDetail job = new JobDetail(jobName, groupName, jobClass);
        SimpleTrigger trigger = new SimpleTrigger(TRIGGER_PREFIX + jobName, groupName, date);
        this.quartzScheduler.scheduleJob(job, (Trigger)trigger);
    }

    @Override
    public void schedulePeriodicJob(String jobName, String groupName, Class<? extends Job> jobClass, long period, boolean overwrite, Map<String, Object> jobData) throws SchedulerException {
        JobDetail job = this.quartzScheduler.getJobDetail(jobName, groupName);
        if (job == null) {
            job = new JobDetail(jobName, groupName, jobClass);
        } else if (overwrite) {
            this.quartzScheduler.deleteJob(jobName, groupName);
        } else {
            throw new SchedulerException("Job " + jobName + " in group " + groupName + " already exists");
        }
        this.setJobData(job, jobData);
        SimpleTrigger trigger = new SimpleTrigger(TRIGGER_PREFIX + jobName, groupName, SimpleTrigger.REPEAT_INDEFINITELY, period);
        this.quartzScheduler.scheduleJob(job, (Trigger)trigger);
    }

    @Override
    public void unscheduleJob(String jobName, String groupName) throws SchedulerException {
        JobDetail job;
        if (!this.quartzScheduler.isShutdown() && (job = this.quartzScheduler.getJobDetail(jobName, groupName)) != null) {
            this.quartzScheduler.unscheduleJob(TRIGGER_PREFIX + jobName, groupName);
        }
    }

    @Override
    public void pauseJob(String jobName, String groupName) throws SchedulerException {
        this.quartzScheduler.pauseTrigger(TRIGGER_PREFIX + jobName, groupName);
    }

    @Override
    public void resumeJob(String jobName, String groupName) throws SchedulerException {
        this.quartzScheduler.resumeTrigger(TRIGGER_PREFIX + jobName, groupName);
    }

    @Override
    public TimeZone getTimeZone() {
        return AppConfig.getsConfig().getTimezone();
    }

    @Override
    public void deleteJob(String jobName, String groupName) throws SchedulerException {
        this.unscheduleJob(jobName, groupName);
        JobDetail job = this.quartzScheduler.getJobDetail(jobName, groupName);
        if (job != null) {
            this.quartzScheduler.deleteJob(jobName, groupName);
        }
    }
}

