/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.webresource;

import com.atlassian.cache.CacheFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceBatchingStateCounter;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import com.atlassian.sal.api.message.I18nResolver;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.web.ServletUtils;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="webResourceIntegration")
@AvailableToPlugins(value=WebResourceIntegration.class)
public class FisheyeWebResourceIntegration
implements WebResourceIntegration {
    private final PluginAccessor pluginAccessor;
    private final PluginEventManager pluginEventManager;
    private final CacheFactory cacheFactory;
    private final WebResourceBatchingStateCounter webResourceBatchingStateCounter;
    private ThreadLocal<Map> requestCache = new ThreadLocal();
    private I18nResolver i18nResolver;
    private static ThreadLocal<String> contextPathThreadLocal = new ThreadLocal();
    private static ThreadLocal<String> absoluteBaseUrlThreadLocal = new ThreadLocal();

    @Autowired
    public FisheyeWebResourceIntegration(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager, CacheFactory cacheFactory, WebResourceBatchingStateCounter webResourceBatchingStateCounter, I18nResolver i18nResolver) {
        this.pluginAccessor = pluginAccessor;
        this.pluginEventManager = pluginEventManager;
        this.cacheFactory = cacheFactory;
        this.webResourceBatchingStateCounter = webResourceBatchingStateCounter;
        this.i18nResolver = i18nResolver;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public PluginEventManager getPluginEventManager() {
        return this.pluginEventManager;
    }

    public CacheFactory getCacheFactory() {
        return this.cacheFactory;
    }

    public Map getRequestCache() {
        HashMap map = this.requestCache.get();
        if (map == null) {
            map = new HashMap();
            this.requestCache.set(map);
        }
        return map;
    }

    public String getSystemCounter() {
        return Long.toString(this.webResourceBatchingStateCounter.getBatchingStateCounter());
    }

    public String getSystemBuildNumber() {
        return "20160506105158";
    }

    public static void setContextPath(HttpServletRequest request) {
        contextPathThreadLocal.set(request.getContextPath());
        absoluteBaseUrlThreadLocal.set(ServletUtils.getBaseUrl(request));
    }

    public String getBaseUrl() {
        return this.getBaseUrl(UrlMode.AUTO);
    }

    public String getBaseUrl(UrlMode urlMode) {
        switch (urlMode) {
            case RELATIVE: 
            case AUTO: {
                return FisheyeWebResourceIntegration.useSiteUrlWhenNull(contextPathThreadLocal.get());
            }
            case ABSOLUTE: {
                return FisheyeWebResourceIntegration.useSiteUrlWhenNull(absoluteBaseUrlThreadLocal.get());
            }
        }
        throw new AssertionError((Object)("Unsupported URLMode: " + urlMode));
    }

    public String getSuperBatchVersion() {
        return Long.toString(this.webResourceBatchingStateCounter.getBatchingStateCounter());
    }

    public String getStaticResourceLocale() {
        return this.getLocale().getLanguage();
    }

    public File getTemporaryDirectory() {
        return new File(AppConfig.getTempDir(), "webresources");
    }

    public CDNStrategy getCDNStrategy() {
        return new CDNStrategy(){

            public boolean supportsCdn() {
                return false;
            }

            public String transformRelativeUrl(String url) {
                return url;
            }
        };
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public String getI18nRawText(Locale locale, String key) {
        return this.i18nResolver.getRawText(key);
    }

    public String getI18nText(Locale locale, String key) {
        return this.i18nResolver.getText(locale, key);
    }

    public Set<String> allowedCondition1Keys() {
        return Collections.emptySet();
    }

    public Set<String> allowedTransform1Keys() {
        return Collections.emptySet();
    }

    public boolean forbidCondition1AndTransformer1() {
        return false;
    }

    private static String useSiteUrlWhenNull(String baseUrl) {
        if (baseUrl == null) {
            baseUrl = AppConfig.getsConfig().getSiteURL();
        }
        return baseUrl;
    }

    private static String trimTrailingSlash(String baseUrl) {
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }
}

