/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.web.helpers;

import com.atlassian.fisheye.plugin.web.helpers.ContextClassLoaderResourceLoader;
import com.atlassian.fisheye.plugin.web.helpers.VelocityHelper;
import com.atlassian.plugin.osgi.hostcomponents.ContextClassLoaderStrategy;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins(contextClassLoaderStrategy=ContextClassLoaderStrategy.USE_PLUGIN)
public class DefaultVelocityHelper
implements VelocityHelper {
    private final VelocityEngine velocity = new VelocityEngine();

    public DefaultVelocityHelper() {
        try {
            Properties p2 = new Properties();
            p2.setProperty("resource.loader", "context, class, file");
            p2.setProperty("context.resource.loader.description", "FishEye Context ClassLoader Classpath Resource Loader");
            p2.setProperty("context.resource.loader.class", ContextClassLoaderResourceLoader.class.getName());
            p2.setProperty("class.resource.loader.description", "Velocity Classpath Resource Loader");
            p2.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            p2.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.SimpleLog4JLogSystem");
            p2.setProperty("runtime.log.logsystem.log4j.category", "org.apache.velocity.runtime.log.SimpleLog4JLogSystem");
            p2.setProperty("velocimacro.permissions.allow.inline.local.scope", "true");
            this.velocity.init(p2);
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to init Velocity.", e2);
        }
    }

    public String renderVelocityFragment(String fragment, Map<String, Object> params) {
        StringWriter writer = new StringWriter();
        VelocityContext context = new VelocityContext(null, (Context)new VelocityContext(params));
        try {
            if (this.velocity.evaluate((Context)context, (Writer)writer, DefaultVelocityHelper.class.getName(), fragment)) {
                return writer.toString();
            }
            return this.wrapMessage("Failed to render velocity fragment '" + fragment + "'");
        }
        catch (Exception e2) {
            String message = "Failed to render velocity fragment '" + fragment + "', " + e2.getMessage();
            Logs.APP_LOG.error((Object)message, (Throwable)e2);
            return this.wrapMessage(message);
        }
    }

    public void renderVelocityTemplate(String template, Map<String, Object> params, Writer writer) throws IOException {
        try {
            this.velocity.mergeTemplate(template, (Context)new VelocityContext(params), writer);
        }
        catch (Exception e2) {
            String message = "Failed to render velocity fragment '" + template + "', " + e2.getMessage();
            Logs.APP_LOG.error((Object)message, (Throwable)e2);
            writer.write(this.wrapMessage(message));
        }
    }

    public void renderVelocityTemplate(InputStream velocityStream, Map<String, Object> params, Writer writer) throws IOException {
        try {
            this.velocity.evaluate((Context)new VelocityContext(params), writer, DefaultVelocityHelper.class.getName(), (Reader)new InputStreamReader(velocityStream));
        }
        catch (Exception e2) {
            String message = "Failed to render velocity stream, " + e2.getMessage();
            Logs.APP_LOG.error((Object)message, (Throwable)e2);
            writer.write(this.wrapMessage(message));
        }
    }

    private String wrapMessage(String message) {
        return "<span class=\"error\">" + message + "</span>";
    }
}

