/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.web.helpers;

import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.services.ImpersonationService;
import com.atlassian.crucible.spi.services.ProjectService;
import com.atlassian.crucible.spi.services.ReviewService;
import com.atlassian.fisheye.plugin.web.helpers.DefaultHelper;
import com.atlassian.fisheye.spi.services.RepositoryService;
import com.atlassian.fisheye.spi.services.RevisionDataService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="helperFactory")
public class DefaultHelperFactory {
    private final RepositoryService repositoryService;
    private final ProjectService projectService;
    private final ReviewService reviewService;
    private final RevisionDataService revisionDataService;
    private final SPIUserUtils spiUserUtils;
    private final ImpersonationService impersonationService;

    @Autowired
    public DefaultHelperFactory(RepositoryService repositoryService, ProjectService projectService, ReviewService reviewService, RevisionDataService revisionDataService, SPIUserUtils spiUserUtils, ImpersonationService impersonationService) {
        this.repositoryService = repositoryService;
        this.projectService = projectService;
        this.reviewService = reviewService;
        this.revisionDataService = revisionDataService;
        this.spiUserUtils = spiUserUtils;
        this.impersonationService = impersonationService;
    }

    public DefaultHelper forRequest(HttpServletRequest request) {
        return this.makeHelper(request, null, null, null, null, null, null, null, null, null);
    }

    public DefaultHelper forRepo(HttpServletRequest request, String repoPath) {
        return this.makeHelper(request, repoPath, null, null, null, null, null, null, null, null);
    }

    public DefaultHelper forProject(HttpServletRequest request, String projectKey) {
        this.require("projectService", this.projectService);
        return this.makeHelper(request, null, projectKey, null, null, null, null, null, null, null);
    }

    public DefaultHelper forReview(HttpServletRequest request, String reviewPermId) {
        this.require("reviewService", this.reviewService);
        return this.makeHelper(request, null, null, reviewPermId, null, null, null, null, null, null);
    }

    public DefaultHelper forReviewItem(HttpServletRequest request, String reviewPermId, String itemPermaId) {
        this.require("reviewService", this.reviewService);
        return this.makeHelper(request, null, null, reviewPermId, itemPermaId, null, null, null, null, null);
    }

    public DefaultHelper forReviewParticipant(HttpServletRequest request, String reviewPermId, String participantUserName) {
        this.require("reviewService", this.reviewService);
        return this.makeHelper(request, null, null, reviewPermId, null, null, null, null, null, participantUserName);
    }

    public DefaultHelper forReviewComment(HttpServletRequest request, String reviewPermId, String commentPermId) {
        this.require("reviewService", this.reviewService);
        return this.makeHelper(request, null, null, reviewPermId, null, commentPermId, null, null, null, null);
    }

    public DefaultHelper forReviewItemComment(HttpServletRequest request, String reviewPermId, String itemPermaId, String commentPermId) {
        this.require("reviewService", this.reviewService);
        return this.makeHelper(request, null, null, reviewPermId, itemPermaId, commentPermId, null, null, null, null);
    }

    public DefaultHelper forChangeset(HttpServletRequest request, String repoPath, String csid) {
        this.require("revisionDataService", this.revisionDataService);
        return this.makeHelper(request, repoPath, null, null, null, null, csid, null, null, null);
    }

    public DefaultHelper forRevision(HttpServletRequest request, String repo, String csid, String filepath, String rev) {
        this.require("revisionDataService", this.revisionDataService);
        return this.makeHelper(request, repo, null, null, null, null, csid, filepath, rev, null);
    }

    private void require(String serviceName, Object serviceBean) {
        if (serviceBean == null) {
            throw new RuntimeException("The service '" + serviceName + "' is not available.");
        }
    }

    private DefaultHelper makeHelper(HttpServletRequest request, String repoPath, String projectKey, String reviewPermId, String itemPermaId, String commentPermId, String csid, String filepath, String revision, String participant) {
        return new DefaultHelper(this.repositoryService, this.revisionDataService, this.projectService, this.reviewService, this.impersonationService, this.spiUserUtils, request, repoPath, projectKey, reviewPermId, itemPermaId, commentPermId, csid, filepath, revision, participant);
    }
}

