/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.web.helpers;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.CommentData;
import com.atlassian.crucible.spi.data.DetailedReviewData;
import com.atlassian.crucible.spi.data.ProjectData;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.ReviewItemData;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.services.ImpersonationService;
import com.atlassian.crucible.spi.services.ProjectService;
import com.atlassian.crucible.spi.services.ReviewService;
import com.atlassian.fisheye.plugin.web.helpers.DefaultGlobalHelper;
import com.atlassian.fisheye.plugin.web.helpers.DefaultRepositoryHelper;
import com.atlassian.fisheye.plugin.web.helpers.GlobalHelper;
import com.atlassian.fisheye.plugin.web.helpers.Helper;
import com.atlassian.fisheye.plugin.web.helpers.RepositoryHelper;
import com.atlassian.fisheye.spi.data.ChangesetDataFE;
import com.atlassian.fisheye.spi.data.FileRevisionData;
import com.atlassian.fisheye.spi.services.RepositoryService;
import com.atlassian.fisheye.spi.services.RevisionDataService;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import javax.servlet.http.HttpServletRequest;

public class DefaultHelper
implements Helper {
    private final ProjectService projectService;
    private final RepositoryService repositoryService;
    private final RevisionDataService revisionDataService;
    private final ReviewService reviewService;
    private final ImpersonationService impersonationService;
    private final HttpServletRequest request;
    private final String repoPath;
    private final String projectKey;
    private final String reviewPermaId;
    private final String itemPermaId;
    private final String commentPermId;
    private final String csid;
    private final String filepath;
    private final String revision;
    private final UserData participant;
    private GlobalHelper global;
    private RepositoryHelper repository;
    private ChangesetDataFE changesetDataFE;
    private FileRevisionData fileRevisionData;
    private ProjectData projectData;
    private ReviewData reviewData;
    private DetailedReviewData detailedReviewData;
    private ReviewItemData reviewItemData;
    private CommentData commentData;

    public DefaultHelper(RepositoryService repositoryService, RevisionDataService revisionDataService, ProjectService projectService, ReviewService reviewService, ImpersonationService impersonationService, SPIUserUtils spiUserUtils, HttpServletRequest request, String repoPath, String projectKey, String reviewPermaId, String itemPermaId, String commentPermId, String csid, String filepath, String revision, String participantName) {
        this.repositoryService = repositoryService;
        this.revisionDataService = revisionDataService;
        this.projectService = projectService;
        this.reviewService = reviewService;
        this.impersonationService = impersonationService;
        this.request = request;
        this.repoPath = repoPath;
        this.projectKey = projectKey;
        this.reviewPermaId = reviewPermaId;
        this.itemPermaId = itemPermaId;
        this.commentPermId = commentPermId;
        this.csid = csid;
        this.filepath = filepath;
        this.revision = revision;
        this.participant = participantName != null ? spiUserUtils.createUserData(spiUserUtils.getUserByName(participantName)) : null;
    }

    public String urlEncode(String s2) {
        return ExpressionUtil.deprecatedUrlPathEncode(s2);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public GlobalHelper getGlobal() {
        if (this.global == null) {
            String baseUrl = AppConfig.getsConfig().getSiteURL();
            UserData userData = this.impersonationService.getCurrentUser(null);
            if (userData == null) {
                userData = UserData.ANONYMOUS;
            }
            this.global = new DefaultGlobalHelper(userData, baseUrl);
        }
        return this.global;
    }

    public RepositoryHelper getRepository() {
        if (this.repository == null && this.repoPath != null) {
            this.repository = new DefaultRepositoryHelper(this.repoPath, this.repositoryService);
        }
        return this.repository;
    }

    public ProjectData getProject() {
        if (this.projectData == null) {
            if (this.projectKey != null) {
                this.projectData = this.projectService.getProject(this.projectKey);
            } else if (this.getReview().getProjectKey() != null) {
                this.projectData = this.projectService.getProject(this.getReview().getProjectKey());
            }
        }
        return this.projectData;
    }

    public String getChangesetId() {
        return this.csid;
    }

    public ChangesetDataFE getChangeset() {
        if (this.changesetDataFE == null && this.csid != null && this.getRepository() != null) {
            this.changesetDataFE = this.revisionDataService.getChangeset(this.getRepository().getRepositoryData().getName(), this.csid);
        }
        return this.changesetDataFE;
    }

    public FileRevisionData getRevision() {
        if (this.fileRevisionData == null && this.filepath != null && this.revision != null && this.getRepository() != null) {
            this.fileRevisionData = this.revisionDataService.getRevision(this.getRepository().getRepositoryData().getName(), this.filepath, this.revision);
        }
        return this.fileRevisionData;
    }

    public ReviewData getReview() {
        if (this.reviewData == null && this.reviewPermaId != null) {
            this.reviewData = this.reviewService.getReview(new PermId(this.reviewPermaId));
        }
        return this.reviewData;
    }

    public PermId<ReviewData> getReviewPermId() {
        return new PermId(this.reviewPermaId);
    }

    public DetailedReviewData getReviewDetails() {
        if (this.detailedReviewData == null && this.reviewPermaId != null) {
            this.detailedReviewData = this.reviewService.getReviewDetails(new PermId(this.reviewPermaId));
        }
        return this.detailedReviewData;
    }

    public UserData getParticipant() {
        return this.participant;
    }

    public ReviewItemData getReviewItem() {
        if (this.reviewItemData == null && this.itemPermaId != null && this.reviewPermaId != null) {
            this.reviewItemData = this.reviewService.getReviewItem(new PermId(this.reviewPermaId), new PermId(this.itemPermaId));
        }
        return this.reviewItemData;
    }

    public Integer getCommentId() {
        return this.commentPermId == null ? null : this.getCommentId(this.commentPermId);
    }

    private Integer getCommentId(String commentPermId) {
        String[] cIdTokens = commentPermId.split(":");
        String id = cIdTokens.length > 1 ? cIdTokens[1] : cIdTokens[0];
        return Integer.parseInt(id);
    }

    public CommentData getComment() {
        if (this.commentData == null && this.commentPermId != null) {
            this.commentData = this.reviewService.getComment(new PermId(this.commentPermId));
        }
        return this.commentData;
    }

    public ProjectService getProjectService() {
        return this.projectService;
    }

    public ReviewService getReviewService() {
        return this.reviewService;
    }

    public RevisionDataService getRevisionDataService() {
        return this.revisionDataService;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }
}

