/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.web.conditions;

import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.fisheye.plugin.web.conditions.AbstractFisheyeCondition;
import com.atlassian.fisheye.plugin.web.helpers.Helper;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;

public class UserCanAccessCrucible
extends AbstractFisheyeCondition {
    protected boolean shouldDisplay(Helper context) {
        if (!AppConfig.isCrucible()) {
            return false;
        }
        UserData user = context.getGlobal().getUser();
        RootConfig root = AppConfig.getsConfig();
        if (user == null) {
            return root.getConfig().getSecurity().getAllowCruAnon();
        }
        UserManager um = root.getUserManager();
        try {
            return um.isCrucibleEnabled(user.getUserName());
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)("Error evaluating " + UserCanAccessCrucible.class + " condition"), (Throwable)e2);
            return false;
        }
    }
}

