/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.web;

import com.atlassian.fisheye.plugin.PluginManagerInterfaces;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.DefaultWebInterfaceManager;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugin.web.model.DefaultWebLabel;
import com.atlassian.plugin.web.model.DefaultWebLink;
import com.atlassian.plugin.web.model.WebIcon;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.web.model.WebLink;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.plugin.web.model.WebParam;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Text;
import org.dom4j.dom.DOMElement;
import org.dom4j.dom.DOMText;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins
@Component(value="webInterfaceManager")
public class FisheyeWebInterfaceManager
extends DefaultWebInterfaceManager {
    private final PluginManagerInterfaces manager;

    @Autowired
    public FisheyeWebInterfaceManager(PluginAccessor pluginManager, WebFragmentHelper webFragmentHelper) {
        super(pluginManager, webFragmentHelper);
        this.manager = (PluginManagerInterfaces)pluginManager;
    }

    public boolean hasSectionsForLocation(String location) {
        return this.manager.isDevModeEnabled() || super.hasSectionsForLocation(location);
    }

    public List<WebItemModuleDescriptor> getItems(String section) {
        if (this.manager.isDevModeEnabled()) {
            ArrayList<WebItemModuleDescriptor> list = new ArrayList<WebItemModuleDescriptor>();
            list.addAll(super.getItems(section));
            list.add(new DevModeWebItem(section, this.getWebFragmentHelper()));
            return list;
        }
        return super.getItems(section);
    }

    public List<WebSectionModuleDescriptor> getSections(String location) {
        if (this.manager.isDevModeEnabled()) {
            ArrayList<WebSectionModuleDescriptor> items = new ArrayList<WebSectionModuleDescriptor>();
            items.addAll(super.getSections(location));
            items.add(new DevModeWebSection(this.getWebFragmentHelper(), location));
            return items;
        }
        return super.getSections(location);
    }

    public List<WebPanelModuleDescriptor> getWebPanelDescriptors(String location) {
        List actualPanels = super.getWebPanelDescriptors(location);
        if (this.manager.isDevModeEnabled()) {
            return ImmutableList.builder().addAll((Iterable)actualPanels).add((Object)new DevModeWebPanel(this.getWebFragmentHelper(), location)).build();
        }
        return actualPanels;
    }

    public static abstract class AbstractDevModeWebFragmenteDescriptor<T>
    implements WebFragmentModuleDescriptor<T> {
        protected WebFragmentHelper fragmentHelper;
        private String tooltip;

        public AbstractDevModeWebFragmenteDescriptor(WebFragmentHelper fragmentHelper, String tooltip) {
            this.tooltip = tooltip;
            this.fragmentHelper = fragmentHelper;
        }

        public WebLink getLink() {
            DOMElement link = new DOMElement("a");
            link.add((Text)new DOMText("http://confluence.atlassian.com/display/FECRUDEV/Web+Item+Module+Type"));
            return new DefaultWebLink((Element)link, this.fragmentHelper, null, (WebFragmentModuleDescriptor)this);
        }

        public WebIcon getIcon() {
            return null;
        }

        public String getStyleClass() {
            return "plugin-point";
        }

        public int getWeight() {
            return 10;
        }

        public WebLabel getTooltip() {
            DOMElement link = new DOMElement("<span>");
            link.add((Text)new DOMText("Add your own links here using this section key: " + this.tooltip));
            return new DefaultWebLabel((Element)link, this.fragmentHelper, null, (WebFragmentModuleDescriptor)this);
        }

        public Condition getCondition() {
            return null;
        }

        public ContextProvider getContextProvider() {
            return null;
        }

        public WebParam getWebParams() {
            return null;
        }

        public void enabled() {
        }

        public void disabled() {
        }

        public String getCompleteKey() {
            return "com.atlassian.devmode:webitem";
        }

        public String getPluginKey() {
            return "com.atlassian.devmode";
        }

        public String getKey() {
            return "webitem";
        }

        public String getName() {
            return "devmode";
        }

        public String getDescription() {
            return null;
        }

        public Class<T> getModuleClass() {
            return null;
        }

        public T getModule() {
            return null;
        }

        public void init(Plugin plugin, Element element) throws PluginParseException {
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public boolean isSystemModule() {
            return false;
        }

        public void destroy(Plugin plugin) {
        }

        public Float getMinJavaVersion() {
            return Float.valueOf(0.0f);
        }

        public boolean satisfiesMinJavaVersion() {
            return true;
        }

        public Map<String, String> getParams() {
            return Maps.newHashMap();
        }

        public String getI18nNameKey() {
            return null;
        }

        public String getDescriptionKey() {
            return null;
        }

        public Plugin getPlugin() {
            return null;
        }

        public List<ResourceDescriptor> getResourceDescriptors() {
            return null;
        }

        public List<ResourceDescriptor> getResourceDescriptors(String type) {
            return null;
        }

        public ResourceDescriptor getResourceDescriptor(String type, String name) {
            return null;
        }

        public ResourceLocation getResourceLocation(String type, String name) {
            return null;
        }

        public void destroy() {
        }
    }

    public static class DevModeWebPanel
    extends AbstractDevModeWebFragmenteDescriptor<WebPanel>
    implements WebPanelModuleDescriptor {
        private final String location;

        public DevModeWebPanel(WebFragmentHelper fragmentHelper, String location) {
            super(fragmentHelper, location);
            this.location = location;
        }

        public String getLocation() {
            return this.location;
        }

        @Override
        public Class<WebPanel> getModuleClass() {
            return WebPanel.class;
        }

        @Override
        public WebPanel getModule() {
            return new WebPanel(){

                public String getHtml(Map<String, Object> context) {
                    return fragmentHelper.renderVelocityFragment("<div class='plugin-point web-panel'><strong>Web panel</strong>: $location</div>", (Map)ImmutableMap.of((Object)"location", (Object)location));
                }

                public void writeHtml(Writer writer, Map<String, Object> context) throws IOException {
                    writer.append(this.getHtml(context));
                }
            };
        }

        public WebLabel getWebLabel() {
            DOMElement link = new DOMElement("<span class=\"plugin-point\">");
            link.add((Text)new DOMText("Web panel: " + this.location));
            return new DefaultWebLabel((Element)link, this.fragmentHelper, null, (WebFragmentModuleDescriptor)this);
        }

        public boolean isEnabled() {
            return true;
        }
    }

    public static class DevModeWebSection
    extends AbstractDevModeWebFragmenteDescriptor<Void>
    implements WebSectionModuleDescriptor {
        private String location;

        public DevModeWebSection(WebFragmentHelper fragmentHelper, String location) {
            super(fragmentHelper, location);
            this.location = location;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSection() {
            return null;
        }

        public WebLabel getWebLabel() {
            DOMElement link = new DOMElement("<span class=\"plugin-point\">");
            link.add((Text)new DOMText("Web section: " + this.location));
            return new DefaultWebLabel((Element)link, this.fragmentHelper, null, (WebFragmentModuleDescriptor)this);
        }

        public boolean isEnabled() {
            return true;
        }
    }

    public static class DevModeWebItem
    extends AbstractDevModeWebFragmenteDescriptor<Void>
    implements WebItemModuleDescriptor {
        private String section;

        public DevModeWebItem(String section, WebFragmentHelper fragmentHelper) {
            super(fragmentHelper, section);
            this.section = section;
        }

        public String getSection() {
            return this.section;
        }

        public String getLocation() {
            return null;
        }

        public WebLabel getWebLabel() {
            DOMElement link = new DOMElement("<span class=\"plugin-point\">");
            link.add((Text)new DOMText("Web item: " + this.section));
            return new DefaultWebLabel((Element)link, this.fragmentHelper, null, (WebFragmentModuleDescriptor)this);
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

