/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.web;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.fisheye.plugin.web.helpers.VelocityHelper;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.sal.api.message.I18nResolver;
import com.cenqua.fisheye.web.util.PluginModuleInstanceTracker;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class FisheyeWebFragmentHelper
implements WebFragmentHelper {
    private final VelocityHelper velocityHelper;
    private final PluginModuleInstanceTracker<I18nResolver> moduleTracker;
    private final ApplicationContext defaultApplicationContext;

    @Autowired
    public FisheyeWebFragmentHelper(VelocityHelper velocityHelper, PluginAccessor pluginAccessor, PluginEventManager pluginEventManager, ApplicationContext defaultApplicationContext) {
        this.velocityHelper = velocityHelper;
        this.defaultApplicationContext = defaultApplicationContext;
        this.moduleTracker = new PluginModuleInstanceTracker<I18nResolver>(pluginAccessor, pluginEventManager, I18nResolver.class);
    }

    public Condition loadCondition(String className, Plugin plugin) throws ConditionLoadingException {
        this.assertClassNameNotBlank(className, plugin, "condition");
        return (Condition)this.loadComponent(className, plugin);
    }

    private void assertClassNameNotBlank(String className, Plugin plugin, String type) throws ConditionLoadingException {
        if (StringUtils.isBlank((String)className)) {
            throw new ConditionLoadingException("null or empty " + type + " class name in plugin " + plugin.getKey());
        }
    }

    public ContextProvider loadContextProvider(String className, Plugin plugin) throws ConditionLoadingException {
        this.assertClassNameNotBlank(className, plugin, "context provider");
        return (ContextProvider)this.loadComponent(className, plugin);
    }

    private <T> T loadComponent(String className, Plugin plugin) throws ConditionLoadingException {
        Class clazz;
        try {
            clazz = plugin.loadClass(className, FisheyeWebFragmentHelper.class);
        }
        catch (ClassNotFoundException e2) {
            try {
                clazz = ClassLoaderUtils.loadClass((String)className, FisheyeWebFragmentHelper.class);
            }
            catch (ClassNotFoundException e1) {
                throw new ConditionLoadingException("Failed to load class '" + className + "' for plugin " + plugin.getName(), (Throwable)e2);
            }
        }
        if (plugin instanceof ContainerManagedPlugin) {
            return (T)((ContainerManagedPlugin)plugin).getContainerAccessor().createBean(clazz);
        }
        return (T)this.defaultApplicationContext.getAutowireCapableBeanFactory().createBean(clazz);
    }

    public String getI18nValue(String key, List<?> arguments, Map<String, Object> context) {
        return this.moduleTracker.getModule().getText(key, arguments == null ? new Serializable[]{} : arguments.toArray(new Serializable[arguments.size()]));
    }

    public String renderVelocityFragment(String fragment, Map<String, Object> params) {
        return this.velocityHelper.renderVelocityFragment(fragment, params);
    }
}

