/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.servlet;

import com.atlassian.fisheye.plugin.descriptor.FisheyeServletModuleDescriptor;
import com.atlassian.fisheye.plugin.web.RequiresXsrfCheck;
import com.atlassian.plugin.servlet.DelegatingPluginServlet;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.admin.interceptors.LoginInterceptor;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ReflectionUtils;

public class FisheyeServletModuleContainerServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(FisheyeServletModuleContainerServlet.class);
    private ServletConfig servletConfig;
    private ServletModuleManager servletModuleManager;
    private XsrfTokenValidator xsrfTokenValidator;

    public FisheyeServletModuleContainerServlet() {
        this(null, null);
    }

    FisheyeServletModuleContainerServlet(ServletModuleManager servletModuleManager, XsrfTokenValidator xsrfTokenValidator) {
        this.servletModuleManager = servletModuleManager;
        this.xsrfTokenValidator = xsrfTokenValidator;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletConfig = servletConfig;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            HttpServlet servlet;
            if (this.getServletModuleManager() == null) {
                LOG.error((Object)"Could not get ServletModuleManager?");
                response.sendError(500, "Could not get ServletModuleManager.");
                return;
            }
            String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (pathInfo == null) {
                pathInfo = request.getPathInfo();
            }
            HttpServlet servletImplementation = servlet = this.getServletModuleManager().getServlet(pathInfo, this.servletConfig);
            if (servlet != null) {
                boolean validToken;
                if (servlet instanceof DelegatingPluginServlet) {
                    FisheyeServletModuleDescriptor fisheyeDescriptor;
                    ServletModuleDescriptor descriptor = ((DelegatingPluginServlet)servlet).getModuleDescriptor();
                    servletImplementation = (HttpServlet)descriptor.getModule();
                    if (descriptor instanceof FisheyeServletModuleDescriptor && (fisheyeDescriptor = (FisheyeServletModuleDescriptor)descriptor).isAdminPlugin() && !LoginInterceptor.checkLogin(request)) {
                        response.sendRedirect(request.getContextPath() + "/admin/login-default.do");
                        return;
                    }
                }
                if (this.isRequiredXsrfCheck(request, servletImplementation) && !(validToken = this.getXsrfTokenValidator().validateFormEncodedToken(request))) {
                    ServletUtils.sendXsrfError(request, response);
                    return;
                }
                servlet.service((ServletRequest)request, (ServletResponse)response);
            } else {
                LOG.warn((Object)("No servlet found for: " + request.getRequestURI()));
                response.sendError(404, "Could not find servlet for: " + request.getRequestURI());
            }
        }
        catch (DbException e2) {
            throw new ServletException((Throwable)e2);
        }
    }

    private boolean isRequiredXsrfCheck(HttpServletRequest request, HttpServlet servlet) {
        String method = request.getMethod().toUpperCase();
        return method.equals("POST") && this.hasDoPostXsrfAnnotation(servlet) || method.equals("GET") && this.hasDoGetXsrfAnnotation(servlet) || this.hasServiceXsrfAnnotation(servlet);
    }

    private boolean hasDoGetXsrfAnnotation(HttpServlet servlet) {
        return this.hasXsrfOptInAnnotation(servlet, "doGet", HttpServletRequest.class, HttpServletResponse.class);
    }

    private boolean hasDoPostXsrfAnnotation(HttpServlet servlet) {
        return this.hasXsrfOptInAnnotation(servlet, "doPost", HttpServletRequest.class, HttpServletResponse.class);
    }

    private boolean hasServiceXsrfAnnotation(HttpServlet servlet) {
        return this.hasXsrfOptInAnnotation(servlet, "service", HttpServletRequest.class, HttpServletResponse.class) || this.hasXsrfOptInAnnotation(servlet, "service", ServletRequest.class, ServletResponse.class);
    }

    private boolean hasXsrfOptInAnnotation(Object o2, String methodName, Class ... args) {
        Method m2 = ReflectionUtils.findMethod(o2.getClass(), (String)methodName, (Class[])args);
        return m2 != null && m2.getAnnotation(RequiresXsrfCheck.class) != null;
    }

    private ServletModuleManager getServletModuleManager() {
        if (this.servletModuleManager == null && SpringContext.isSetup()) {
            this.servletModuleManager = (ServletModuleManager)SpringContext.getApplicationContext().getBean("servletModuleManager");
        }
        return this.servletModuleManager;
    }

    private XsrfTokenValidator getXsrfTokenValidator() {
        if (this.xsrfTokenValidator == null && SpringContext.isSetup()) {
            this.xsrfTokenValidator = SpringContext.getComponentByClass(XsrfTokenValidator.class);
        }
        return this.xsrfTokenValidator;
    }
}

