/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.descriptor;

import com.atlassian.crucible.scm.SCMModule;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.module.ModuleFactory;
import com.cenqua.fisheye.logging.Logs;

public class SCMModuleDescriptor
extends AbstractModuleDescriptor<SCMModule>
implements StateAware {
    private SCMModule module;

    public SCMModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public synchronized SCMModule getModule() {
        if (this.module == null) {
            if (this.plugin instanceof ContainerManagedPlugin) {
                try {
                    this.module = (SCMModule)((ContainerManagedPlugin)this.plugin).getContainerAccessor().createBean(this.getModuleClass());
                    this.module.setModuleDescriptor((ModuleDescriptor)this);
                }
                catch (Throwable e2) {
                    Logs.APP_LOG.warn((Object)("Unable to autowire SCMModule: " + this.plugin));
                    Throwable trail = e2;
                    while (trail != null) {
                        Logs.APP_LOG.debug((Object)("Exception: " + trail.getClass() + ":" + trail.getMessage()));
                        if (trail instanceof ExceptionInInitializerError) {
                            trail = ((ExceptionInInitializerError)trail).getException();
                            Logs.APP_LOG.debug((Object)"Initializer exception", trail);
                            continue;
                        }
                        trail = trail.getCause();
                    }
                    throw new RuntimeException(e2);
                }
            } else {
                throw new IllegalArgumentException("SCMModules must be autowire capable");
            }
        }
        return this.module;
    }

    public void disabled() {
        super.disabled();
        this.module = null;
    }
}

