/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.descriptor;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.module.ModuleFactory;
import com.cenqua.fisheye.config.SpringContext;

public abstract class BaseModuleDescriptor<T>
extends AbstractModuleDescriptor<T>
implements StateAware {
    private T module;

    protected BaseModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public T getModule() {
        if (this.module == null) {
            Class clazz = this.getModuleClass();
            this.module = BaseModuleDescriptor.instantiatePluginModule(this.plugin, clazz);
        }
        return this.module;
    }

    public void enabled() {
        super.enabled();
        T m2 = this.getModule();
        if (m2 instanceof StateAware) {
            StateAware stateAware = (StateAware)m2;
            stateAware.enabled();
        }
    }

    public void disabled() {
        super.disabled();
        T m2 = this.getModule();
        if (m2 instanceof StateAware) {
            StateAware stateAware = (StateAware)m2;
            stateAware.disabled();
        }
    }

    private static <T> T instantiatePluginModule(Plugin plugin, Class<T> cls) {
        if (plugin instanceof ContainerManagedPlugin) {
            return (T)((ContainerManagedPlugin)plugin).getContainerAccessor().createBean(cls);
        }
        return SpringContext.createComponent(cls);
    }
}

