/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.configuration;

import com.atlassian.fisheye.plugin.FisheyePluginDirectoryConfiguration;
import com.atlassian.fisheye.plugin.configuration.ModuleConfigurationStore;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins
@Component(value="moduleConfigurationStore")
public class DefaultModuleConfigurationStore
implements ModuleConfigurationStore {
    private FisheyePluginDirectoryConfiguration directoryConfiguration;

    @Autowired
    public DefaultModuleConfigurationStore(FisheyePluginDirectoryConfiguration directoryConfiguration) {
        this.directoryConfiguration = directoryConfiguration;
    }

    /*
     * Loose catch block
     */
    public byte[] getConfiguration(ModuleDescriptor descriptor) {
        byte[] byArray;
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.getConfigFile(descriptor));
            byArray = IOUtils.toByteArray((InputStream)is);
        }
        catch (FileNotFoundException e2) {
            byte[] byArray2 = null;
            IOUtils.closeQuietly((InputStream)is);
            return byArray2;
        }
        catch (IOException e3) {
            throw new RuntimeException("Error reading configuration for module " + descriptor.getCompleteKey());
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return byArray;
    }

    public void putConfiguration(ModuleDescriptor descriptor, byte[] configuration) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.getConfigFile(descriptor));
            os.write(configuration);
        }
        catch (IOException e2) {
            try {
                throw new RuntimeException("Error writing configuration for module " + descriptor.getCompleteKey());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    private File getConfigFile(ModuleDescriptor descriptor) {
        return new File(this.directoryConfiguration.getConfigDirectory(), this.normaliseFileName(descriptor.getCompleteKey() + ".config"));
    }

    protected String normaliseFileName(String rawName) {
        return rawName.replaceAll("[:/\\\\]", "_");
    }
}

