/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin;

import com.atlassian.fisheye.plugin.FisheyePluginDirectoryConfiguration;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pluginStateStore")
public class PropertyFilePluginStateStore
implements PluginPersistentStateStore {
    private final File propertyFile;
    private final ResettableLazyReference<PluginPersistentState> cache = new ResettableLazyReference<PluginPersistentState>(){

        protected PluginPersistentState create() throws Exception {
            Map map = Maps.transformValues(PropertyFilePluginStateStore.this.loadProperties(), (Function)new Function<String, Boolean>(){

                public Boolean apply(String from) {
                    return Boolean.parseBoolean(from);
                }
            });
            return PluginPersistentState.Builder.create().addState(map).toState();
        }
    };

    @Autowired
    public PropertyFilePluginStateStore(FisheyePluginDirectoryConfiguration directoryConfiguration) {
        this.propertyFile = new File(directoryConfiguration.getConfigDirectory(), "pluginstate.properties");
    }

    public synchronized void save(PluginPersistentState state) {
        Properties props = new Properties();
        Map map = state.getMap();
        for (Map.Entry p2 : map.entrySet()) {
            props.setProperty((String)p2.getKey(), ((Boolean)p2.getValue()).toString());
        }
        this.saveProperties(props);
        this.cache.reset();
    }

    public PluginPersistentState load() {
        return (PluginPersistentState)this.cache.get();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Map<String, String> loadProperties() {
        Properties props = new Properties();
        if (!this.propertyFile.exists()) return Maps.fromProperties((Properties)props);
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.propertyFile);
            props.load(is);
        }
        catch (FileNotFoundException e2) {
            try {
                throw new RuntimeException("Couldn't find file " + this.propertyFile.getAbsolutePath(), e2);
                catch (IOException e3) {
                    throw new RuntimeException("Error reading file " + this.propertyFile.getAbsolutePath(), e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return Maps.fromProperties((Properties)props);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveProperties(Properties props) {
        FileOutputStream os = null;
        try {
            this.propertyFile.getParentFile().mkdirs();
            os = new FileOutputStream(this.propertyFile);
            props.store(os, "List of departures from default state for plugins and plugin modules");
        }
        catch (FileNotFoundException e2) {
            try {
                throw new RuntimeException("Error creating file " + this.propertyFile.getAbsolutePath(), e2);
                catch (IOException e3) {
                    throw new RuntimeException("Error writing file " + this.propertyFile.getAbsolutePath(), e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }
}

