/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import java.io.FilenameFilter;
import org.springframework.stereotype.Component;

@Component(value="pluginDirectoryConfiguration")
public class FisheyePluginDirectoryConfiguration {
    public FisheyePluginDirectoryConfiguration() {
        this.fixConfigFileLocations();
    }

    private void fixConfigFileLocations() {
        File[] filesToMove;
        for (File f2 : filesToMove = this.getPluginDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".config") || name.endsWith(".properties");
            }
        })) {
            File newFile = new File(this.getConfigDirectory(), f2.getName());
            String message = f2.getAbsolutePath() + " to " + newFile.getAbsolutePath();
            if (!f2.renameTo(newFile)) {
                Logs.APP_LOG.error((Object)("Failed to move " + message));
                continue;
            }
            Logs.APP_LOG.info((Object)("Moved " + message));
        }
    }

    public File getBundledPluginDirectory() {
        return IOHelper.ensureDirectoryExists(this.getVarPluginsDir(), "bundled");
    }

    public File getBundledPluginsZipFile() {
        File dir = new File(AppConfig.getAppHome(), "plugins");
        return new File(dir, "bundled-plugins.zip");
    }

    public File getPluginDirectory() {
        return IOHelper.ensureDirectoryExists(this.getVarPluginsDir(), "user");
    }

    public File getConfigDirectory() {
        return IOHelper.ensureDirectoryExists(this.getVarPluginsDir(), "config");
    }

    public File getPluginCacheDirectory(String pluginKey) {
        return IOHelper.ensureDirectoryExists(this.getVarCachePluginsDir(), "cache/" + pluginKey);
    }

    public File getPluginDataDirectory(String pluginKey) {
        return IOHelper.ensureDirectoryExists(AppConfig.getDataDir(), "plugins/data/" + pluginKey);
    }

    private File getVarPluginsDir() {
        return IOHelper.ensureDirectoryExists(AppConfig.getVarDir(), "plugins");
    }

    private File getVarCachePluginsDir() {
        return IOHelper.ensureDirectoryExists(AppConfig.getCacheDir(), "plugins");
    }
}

