/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin;

import com.atlassian.fisheye.plugin.EmptyPluginManager;
import com.atlassian.fisheye.plugin.FisheyePluginDirectoryConfiguration;
import com.atlassian.fisheye.plugin.FisheyePluginManager;
import com.atlassian.fisheye.plugin.PluginManagerInterfaces;
import com.atlassian.fisheye.plugin.ProxyPluginFactory;
import com.atlassian.plugin.Application;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginRestartState;
import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.BundledPluginLoader;
import com.atlassian.plugin.loaders.DirectoryPluginLoader;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.loaders.SinglePluginLoader;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.factory.OsgiBundleFactory;
import com.atlassian.plugin.osgi.factory.OsgiPluginFactory;
import com.atlassian.plugin.osgi.factory.RemotablePluginFactory;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.plugin.predicate.PluginPredicate;
import com.atlassian.plugin.repositories.FilePluginInstaller;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.ctl.Restore;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component(value="pluginManager")
@AvailableToPlugins
public class DelegatingFisheyePluginManager
implements PluginManagerInterfaces {
    public static final Set<Application> APPLICATION_KEYS = ImmutableSet.of((Object)new FecruApplication("fisheye"), (Object)new FecruApplication("crucible"), (Object)new FecruApplication("fecru"));
    public static boolean startOsgi = true;
    PluginManagerInterfaces instance;
    final PluginPersistentStateStore store;
    final ModuleDescriptorFactory moduleDescriptorFactory;
    final PluginEventManager pluginEventManager;
    final FisheyePluginDirectoryConfiguration directoryConfiguration;
    final OsgiPersistentCache osgiCache;
    final OsgiContainerManager osgiContainerManager;
    String[] pluginNamesToInclude;

    @Autowired
    public DelegatingFisheyePluginManager(PluginPersistentStateStore store, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager, FisheyePluginDirectoryConfiguration directoryConfiguration, OsgiPersistentCache osgiCache, OsgiContainerManager osgiContainerManager) {
        this.store = store;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
        this.pluginEventManager = pluginEventManager;
        this.directoryConfiguration = directoryConfiguration;
        this.osgiCache = osgiCache;
        this.osgiContainerManager = osgiContainerManager;
    }

    public void setPluginNamesToInclude(String[] pluginNamesToInclude) {
        this.pluginNamesToInclude = pluginNamesToInclude;
    }

    @PostConstruct
    public void startOsgi() {
        if (startOsgi) {
            BundledPluginLoader bundledPluginLoader;
            Logs.APP_LOG.info((Object)"Starting plugin system...");
            ProxyPluginFactory osgiPluginFactory = new ProxyPluginFactory((PluginFactory)new OsgiPluginFactory("atlassian-plugin.xml", APPLICATION_KEYS, this.osgiCache, this.osgiContainerManager, this.pluginEventManager)){

                @Override
                public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
                    return DelegatingFisheyePluginManager.this.canCreate(super.canCreate(pluginArtifact), pluginArtifact);
                }
            };
            ProxyPluginFactory osgiBundleFactory = new ProxyPluginFactory((PluginFactory)new OsgiBundleFactory(this.osgiContainerManager)){

                @Override
                public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
                    return DelegatingFisheyePluginManager.this.canCreate(super.canCreate(pluginArtifact), pluginArtifact);
                }
            };
            ProxyPluginFactory remotablePluginFactory = new ProxyPluginFactory((PluginFactory)new RemotablePluginFactory("atlassian-plugin.xml", APPLICATION_KEYS, this.osgiContainerManager, this.pluginEventManager)){

                @Override
                public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
                    return DelegatingFisheyePluginManager.this.canCreate(super.canCreate(pluginArtifact), pluginArtifact);
                }
            };
            List<PluginFactory> pluginFactories = Arrays.asList(osgiPluginFactory, osgiBundleFactory, remotablePluginFactory);
            DirectoryPluginLoader directoryPluginLoader = new DirectoryPluginLoader(this.directoryConfiguration.getPluginDirectory(), pluginFactories, this.pluginEventManager);
            try {
                bundledPluginLoader = new BundledPluginLoader(this.directoryConfiguration.getBundledPluginsZipFile().toURI().toURL(), this.directoryConfiguration.getBundledPluginDirectory(), pluginFactories, this.pluginEventManager);
            }
            catch (MalformedURLException e2) {
                throw new RuntimeException("Bad URL for bundled plugins zip file", e2);
            }
            this.instance = new FisheyePluginManager(this.store, (List<PluginLoader>)ImmutableList.builder().addAll(this.getSystemPluginLoaders()).add((Object)bundledPluginLoader).add((Object)directoryPluginLoader).build(), this.moduleDescriptorFactory, this.pluginEventManager, (PluginInstaller)new FilePluginInstaller(this.directoryConfiguration.getPluginDirectory()));
        } else {
            Logs.APP_LOG.info((Object)"Not starting plugin system...");
            this.instance = new EmptyPluginManager();
        }
    }

    private Iterable<PluginLoader> getSystemPluginLoaders() {
        return ImmutableList.of((Object)new SinglePluginLoader("com/atlassian/fisheye/plugin/systemplugins/system-crucible-review-addcontent-items.xml"), (Object)new SinglePluginLoader("com/atlassian/fisheye/plugin/systemplugins/system-admin-items.xml"), (Object)new SinglePluginLoader("com/atlassian/fisheye/plugin/systemplugins/system-webresources.xml"), (Object)new SinglePluginLoader("com/atlassian/fisheye/plugin/systemplugins/system-webresources-models.xml"), (Object)new SinglePluginLoader("com/atlassian/fisheye/plugin/systemplugins/system-webresources-components.xml"), (Object)new SinglePluginLoader("com/atlassian/fisheye/plugin/systemplugins/system-webresources-pages.xml"));
    }

    private String canCreate(String pluginKey, PluginArtifact pluginArtifact) {
        if (this.pluginNamesToInclude == null) {
            return pluginKey;
        }
        for (String pluginName : this.pluginNamesToInclude) {
            if (!pluginArtifact.getName().startsWith(pluginName)) continue;
            return pluginKey;
        }
        return null;
    }

    public void onContextRefreshedEvent(ContextRefreshedEvent event) {
        try {
            if (event.getSource() instanceof WebApplicationContext || event.getSource() instanceof Restore.RestoreApplicationContext) {
                this.instance.init();
                Logs.APP_LOG.info((Object)"Plugin system started.");
            }
        }
        catch (PluginParseException e2) {
            throw new RuntimeException("Error initialising plugin manager", e2);
        }
    }

    public void onContextClosedEvent(ContextClosedEvent event) {
        this.instance.shutdown();
        Logs.APP_LOG.info((Object)"*** application context closed ***");
    }

    @Override
    public boolean isDevModeEnabled() {
        return this.instance.isDevModeEnabled();
    }

    public void enablePlugin(String s2) {
        this.instance.enablePlugin(s2);
    }

    public void enablePlugins(String ... strings) {
        this.instance.enablePlugins(strings);
    }

    public void disablePlugin(String s2) {
        this.instance.disablePlugin(s2);
    }

    public void disablePluginWithoutPersisting(String s2) {
        this.instance.disablePluginWithoutPersisting(s2);
    }

    public void enablePluginModule(String s2) {
        this.instance.enablePluginModule(s2);
    }

    public void disablePluginModule(String s2) {
        this.instance.disablePluginModule(s2);
    }

    public String installPlugin(PluginArtifact pluginArtifact) throws PluginParseException {
        return this.instance.installPlugin(pluginArtifact);
    }

    public Set<String> installPlugins(PluginArtifact ... pluginArtifacts) throws PluginParseException {
        return this.instance.installPlugins(pluginArtifacts);
    }

    public void uninstall(Plugin plugin) throws PluginException {
        this.instance.uninstall(plugin);
    }

    public void revertRestartRequiredChange(String s2) throws PluginException {
        this.instance.revertRestartRequiredChange(s2);
    }

    public int scanForNewPlugins() throws PluginParseException {
        return this.instance.scanForNewPlugins();
    }

    public Collection<Plugin> getPlugins() {
        return this.instance.getPlugins();
    }

    public Collection<Plugin> getPlugins(PluginPredicate pluginPredicate) {
        return this.instance.getPlugins(pluginPredicate);
    }

    public Collection<Plugin> getEnabledPlugins() {
        return this.instance.getEnabledPlugins();
    }

    public <M> Collection<M> getModules(ModuleDescriptorPredicate<M> mModuleDescriptorPredicate) {
        return this.instance.getModules(mModuleDescriptorPredicate);
    }

    public <M> Collection<ModuleDescriptor<M>> getModuleDescriptors(ModuleDescriptorPredicate<M> mModuleDescriptorPredicate) {
        return this.instance.getModuleDescriptors(mModuleDescriptorPredicate);
    }

    public Plugin getPlugin(String s2) throws IllegalArgumentException {
        return this.instance.getPlugin(s2);
    }

    public Plugin getEnabledPlugin(String s2) throws IllegalArgumentException {
        return this.instance.getEnabledPlugin(s2);
    }

    public ModuleDescriptor<?> getPluginModule(String s2) {
        return this.instance.getPluginModule(s2);
    }

    public ModuleDescriptor<?> getEnabledPluginModule(String s2) {
        return this.instance.getEnabledPluginModule(s2);
    }

    public boolean isPluginEnabled(String s2) throws IllegalArgumentException {
        return this.instance.isPluginEnabled(s2);
    }

    public boolean isPluginModuleEnabled(String s2) {
        return this.instance.isPluginModuleEnabled(s2);
    }

    public <M> List<M> getEnabledModulesByClass(Class<M> mClass) {
        return this.instance.getEnabledModulesByClass(mClass);
    }

    @Deprecated
    public <M> List<M> getEnabledModulesByClassAndDescriptor(Class<ModuleDescriptor<M>>[] classes, Class<M> mClass) {
        return this.instance.getEnabledModulesByClassAndDescriptor(classes, mClass);
    }

    @Deprecated
    public <M> List<M> getEnabledModulesByClassAndDescriptor(Class<ModuleDescriptor<M>> moduleDescriptorClass, Class<M> mClass) {
        return this.instance.getEnabledModulesByClassAndDescriptor(moduleDescriptorClass, mClass);
    }

    public <D extends ModuleDescriptor<?>> List<D> getEnabledModuleDescriptorsByClass(Class<D> dClass) {
        return this.instance.getEnabledModuleDescriptorsByClass(dClass);
    }

    public <D extends ModuleDescriptor<?>> List<D> getEnabledModuleDescriptorsByClass(Class<D> dClass, boolean b2) {
        return this.instance.getEnabledModuleDescriptorsByClass(dClass, b2);
    }

    @Deprecated
    public <M> List<ModuleDescriptor<M>> getEnabledModuleDescriptorsByType(String s2) throws PluginParseException {
        return this.instance.getEnabledModuleDescriptorsByType(s2);
    }

    public InputStream getDynamicResourceAsStream(String s2) {
        return this.instance.getDynamicResourceAsStream(s2);
    }

    @Deprecated
    public InputStream getPluginResourceAsStream(String s2, String s1) {
        return this.instance.getPluginResourceAsStream(s2, s1);
    }

    @Deprecated
    public Class<?> getDynamicPluginClass(String s2) throws ClassNotFoundException {
        return this.instance.getDynamicPluginClass(s2);
    }

    public ClassLoader getClassLoader() {
        return this.instance.getClassLoader();
    }

    public boolean isSystemPlugin(String s2) {
        return this.instance.isSystemPlugin(s2);
    }

    public PluginRestartState getPluginRestartState(String s2) {
        return this.instance.getPluginRestartState(s2);
    }

    public void init() throws PluginParseException, NotificationException {
        this.instance.init();
    }

    public void shutdown() {
        this.instance.shutdown();
    }

    public void warmRestart() {
        this.instance.warmRestart();
    }

    public Iterable<ModuleDescriptor<?>> getDynamicModules(Plugin plugin) {
        return this.instance.getDynamicModules(plugin);
    }

    public ModuleDescriptor<?> addDynamicModule(Plugin plugin, Element module) {
        return this.instance.addDynamicModule(plugin, module);
    }

    public void removeDynamicModule(Plugin plugin, ModuleDescriptor<?> module) {
        this.instance.removeDynamicModule(plugin, module);
    }

    private static class FecruApplication
    implements Application {
        private final String key;

        private FecruApplication(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String getVersion() {
            return new FisheyeVersionInfo().getReleaseNum();
        }

        public String getBuildNumber() {
            return new FisheyeVersionInfo().getBuildNumber();
        }
    }
}

