/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.pipeline;

import com.atlassian.fisheye.pipeline.ChangeSetEntry;
import com.atlassian.fisheye.pipeline.ChangeSetPhaseQueues;
import com.atlassian.fisheye.pipeline.PipelinePhase;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.FileUtils;
import com.persistit.Configuration;
import com.persistit.Exchange;
import com.persistit.Key;
import com.persistit.Persistit;
import com.persistit.Transaction;
import com.persistit.Value;
import com.persistit.Volume;
import com.persistit.VolumeSpecification;
import com.persistit.exception.PersistitException;
import com.persistit.logging.Log4JAdapter;
import com.persistit.logging.PersistitLogger;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class PartitionedChangeSetPhaseQueues
implements ChangeSetPhaseQueues {
    public static final String PIPELINE_VOL = "pipeline";
    public static final String ROOT_TREE = PartitionedChangeSetPhaseQueues.class.getCanonicalName();
    private final Persistit db;
    private boolean fair = false;
    private static final AtomicLong takeSequence = new AtomicLong(0L);
    private static final int INITIAL_POLL_DELAY_MS = 10;
    private static final int MAX_POLL_DELAY_MS = 3000;
    private static final int MAX_TX_RETRIES = 60;
    private static final int TX_RETRY_DELAY_MS = 10;
    private static final int REPO_STATUS_ROOT = 0;
    private static final int STATUS_REPO_ROOT = 5;
    private static final int PER_REPO_QUEUE_ROOT = 10;
    private static final int PHASE_HEADS_ROOT = 20;
    private static final int PHASE_REPOS_ROOT = 30;
    private static final int PHASE_SEQ_ROOT = 40;
    private static final int PHASE_REPO_SEQ_ROOT = 50;
    private static final int TREE_PHASE_WRITER = 60;
    private static final int PRI_PHASE_OFFSET = 1;
    private static final int PRI_REP_OFFSET = 2;
    private static final int PRI_TS_OFFSET = 3;
    private static final int PRI_CSID_OFFSET = 4;
    private static final int PTSI_PHASE_OFFSET = 1;
    private static final int PTSI_TS_OFFSET = 2;
    private static final int PTSI_REP_OFFSET = 3;
    private static final int PTSI_CSID_OFFSET = 4;
    private static final int PSI_PHASE_OFFSET = 1;
    private static final int PSI_REPO_OFFSET = 3;
    private static final int RQ_REP_OFFSET = 1;
    private static final int RQ_PHASE_OFFSET = 2;
    private static final int RQ_TS_OFFSET = 3;
    private static final int RQ_CSID_OFFSET = 4;
    private boolean shutdown = false;
    private final Map<PipelinePhase, AtomicInteger> queueDepths = new LinkedHashMap<PipelinePhase, AtomicInteger>();
    private final ConcurrentMap<String, ConcurrentMap<PipelinePhase, AtomicInteger>> perRepoQueueDepths = new ConcurrentHashMap<String, ConcurrentMap<PipelinePhase, AtomicInteger>>();
    private final Logger persistitLog = Logger.getLogger((String)"persistit");

    public PartitionedChangeSetPhaseQueues(File queueDir) {
        this(queueDir, false);
    }

    public PartitionedChangeSetPhaseQueues(File queueDir, boolean fair) {
        FileUtils.deleteTree(queueDir);
        if (!(queueDir.exists() || queueDir.isDirectory() || queueDir.mkdirs())) {
            throw new DbException("Unable to create directory for queue storage: " + queueDir.getAbsolutePath());
        }
        this.fair = fair;
        String parentPath = queueDir.getAbsolutePath();
        Logs.APP_LOG.debug((Object)("Phase queues: disk overflow path = " + queueDir));
        Logs.APP_LOG.debug((Object)("Phase queues: fairness = " + fair));
        Configuration cfg = new Configuration();
        cfg.setCommitPolicy(Transaction.CommitPolicy.SOFT);
        cfg.setJournalPath(parentPath + "/pipeline_journal");
        cfg.setTmpVolMaxSize(Long.MAX_VALUE);
        VolumeSpecification volSpec = new VolumeSpecification(parentPath + "/" + PIPELINE_VOL, null, 16384, 100L, 100000L, 10L, true, false, false);
        cfg.getVolumeList().add(volSpec);
        Configuration.BufferPoolConfiguration bufferPoolCfg = (Configuration.BufferPoolConfiguration)cfg.getBufferPoolMap().get(16384);
        bufferPoolCfg.setMaximumCount(100);
        bufferPoolCfg.setFraction(0.3f);
        this.db = new Persistit();
        this.db.setPersistitLogger((PersistitLogger)new Log4JAdapter(this.persistitLog));
        try {
            this.db.setConfiguration(cfg);
            this.db.initialize();
        }
        catch (PersistitException e2) {
            throw new DbException(e2);
        }
        for (PipelinePhase phase : PipelinePhase.values()) {
            this.queueDepths.put(phase, new AtomicInteger());
        }
    }

    @Override
    public void put(final ChangeSetEntry entry, final PipelinePhase phase) {
        Logs.APP_LOG.debug((Object)("PartitionedChangeSetPhaseQueues.put " + entry + ", " + (Object)((Object)phase)));
        this.withRetriableTransaction(this.db, new TxRunnable(){

            @Override
            public void execute(Exchange root, Exchange repo) throws PersistitException {
                EntryStatus status = PartitionedChangeSetPhaseQueues.getStatusForRepo(root, entry.getRepository());
                if (status != EntryStatus.PARKED && status != EntryStatus.QUEUED) {
                    Logs.APP_LOG.warn((Object)("Received changeset " + entry + " for phase " + (Object)((Object)phase) + " but repo '" + entry.getRepository() + "' is in state " + (Object)((Object)status) + ". discarding."));
                    return;
                }
                PartitionedChangeSetPhaseQueues.lockSubTree(repo, phase);
                PartitionedChangeSetPhaseQueues.lockSubTree(root, phase);
                PartitionedChangeSetPhaseQueues.perRepoQueue(repo, phase, entry).store();
                if (PartitionedChangeSetPhaseQueues.getStatusForRepo(root, entry.getRepository()) == EntryStatus.QUEUED) {
                    PartitionedChangeSetPhaseQueues.this.updateRepoHead(root, phase, entry);
                }
            }
        }, 60, ROOT_TREE, entry.getRepository());
        this.queueDepths.get((Object)phase).incrementAndGet();
        int phaseDepth = this.getRepoPhaseDepth(entry.getRepository(), phase).incrementAndGet();
        Logs.APP_LOG.debug((Object)("PUT " + (Object)((Object)phase) + "," + entry + ", depth = " + phaseDepth));
    }

    /*
     * Exception decompiling
     */
    @Override
    public ChangeSetEntry take(String ownerId, PipelinePhase phase) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void updateAndRelease(String ownerId, final ChangeSetEntry entry, final PipelinePhase oldPhase, final PipelinePhase newPhase) {
        final AtomicBoolean repoQueued = new AtomicBoolean(false);
        Logs.APP_LOG.debug((Object)("PartitionedChangeSetPhaseQueues.updateAndRelease " + ownerId + "," + entry + "," + (Object)((Object)oldPhase) + ">" + (Object)((Object)newPhase)));
        this.withRetriableTransaction(this.db, new TxRunnable(){

            @Override
            public void execute(Exchange root, Exchange repo) throws PersistitException {
                PartitionedChangeSetPhaseQueues.lockSubTree(repo, oldPhase);
                PartitionedChangeSetPhaseQueues.lockSubTree(repo, newPhase);
                PartitionedChangeSetPhaseQueues.lockSubTree(root, newPhase);
                PartitionedChangeSetPhaseQueues.perRepoQueue(repo, oldPhase, entry).remove();
                PartitionedChangeSetPhaseQueues.perRepoQueue(repo, newPhase, entry).store();
                if (PartitionedChangeSetPhaseQueues.getStatusForRepo(root, entry.getRepository()) == EntryStatus.QUEUED) {
                    PartitionedChangeSetPhaseQueues.this.updateRepoHead(root, newPhase, entry);
                    repoQueued.set(true);
                }
            }
        }, 60, ROOT_TREE, entry.getRepository());
        if (repoQueued.get()) {
            this.queueDepths.get((Object)oldPhase).decrementAndGet();
            this.queueDepths.get((Object)newPhase).incrementAndGet();
        }
        this.getRepoPhaseDepth(entry.getRepository(), oldPhase).decrementAndGet();
        this.getRepoPhaseDepth(entry.getRepository(), newPhase).incrementAndGet();
    }

    @Override
    public void parkEntries(final String repository) {
        this.withRetriableTransaction(this.db, new TxRunnable(){

            @Override
            public void execute(Exchange root, Exchange ignore) throws PersistitException {
                PartitionedChangeSetPhaseQueues.setStatusForRepo(root, repository, EntryStatus.PARKED);
                PartitionedChangeSetPhaseQueues.removePhaseHeadsForRepo(root, repository);
            }
        });
        ConcurrentMap<PipelinePhase, AtomicInteger> repoDepths = this.getQueueDepthsForRepo(repository);
        for (PipelinePhase phase : PipelinePhase.values()) {
            AtomicInteger phaseDepth = this.getDepthForRepoAndPhase(repoDepths, phase);
            this.queueDepths.get((Object)phase).addAndGet(-phaseDepth.intValue());
        }
    }

    @Override
    public void unparkEntries(final String repository) {
        this.withRetriableTransaction(this.db, new TxRunnable(){

            @Override
            public void execute(Exchange root, Exchange repo) throws PersistitException {
                PartitionedChangeSetPhaseQueues.setStatusForRepo(root, repository, EntryStatus.QUEUED);
                for (PipelinePhase phase : PipelinePhase.values()) {
                    ChangeSetEntry head;
                    if (phase == PipelinePhase.DONE || (head = PartitionedChangeSetPhaseQueues.getFirstUnownedInPhase(repo, repository, phase)) == null) continue;
                    PartitionedChangeSetPhaseQueues.addPhaseHeadEntry(root, phase, head);
                }
            }
        }, 60, ROOT_TREE, repository);
        ConcurrentMap<PipelinePhase, AtomicInteger> repoDepths = this.getQueueDepthsForRepo(repository);
        for (PipelinePhase phase : PipelinePhase.values()) {
            AtomicInteger phaseDepth = this.getDepthForRepoAndPhase(repoDepths, phase);
            this.queueDepths.get((Object)phase).addAndGet(phaseDepth.intValue());
        }
    }

    @Override
    public void removeEntries(final String repository, final boolean repoDeleted) {
        this.withRetriableTransaction(this.db, new TxRunnable(){

            @Override
            public void execute(Exchange root, Exchange repo) throws PersistitException {
                PartitionedChangeSetPhaseQueues.removePhaseHeadsForRepo(root, repository);
                if (repoDeleted) {
                    PartitionedChangeSetPhaseQueues.setStatusForRepo(root, repository, EntryStatus.REMOVED);
                    repo.removeTree();
                } else {
                    repo.removeAll();
                }
            }
        }, 60, ROOT_TREE, repository);
        ConcurrentMap<PipelinePhase, AtomicInteger> repoDepths = this.getQueueDepthsForRepo(repository);
        for (PipelinePhase phase : PipelinePhase.values()) {
            this.getDepthForRepoAndPhase(repoDepths, phase).set(0);
        }
    }

    private ConcurrentMap<PipelinePhase, AtomicInteger> getQueueDepthsForRepo(String repo) {
        ConcurrentHashMap newDepths;
        ConcurrentHashMap depths = (ConcurrentHashMap)this.perRepoQueueDepths.get(repo);
        if (depths == null && (depths = (ConcurrentMap)this.perRepoQueueDepths.putIfAbsent(repo, newDepths = new ConcurrentHashMap(PipelinePhase.values().length))) == null) {
            depths = newDepths;
        }
        return depths;
    }

    private AtomicInteger getDepthForRepoAndPhase(ConcurrentMap<PipelinePhase, AtomicInteger> repoDepths, PipelinePhase phase) {
        AtomicInteger depth = new AtomicInteger();
        AtomicInteger existing = repoDepths.putIfAbsent(phase, depth);
        return existing != null ? existing : depth;
    }

    private AtomicInteger getRepoPhaseDepth(String repo, PipelinePhase phase) {
        return this.getDepthForRepoAndPhase(this.getQueueDepthsForRepo(repo), phase);
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        Logs.APP_LOG.debug((Object)"Queue shutdown");
        this.persistitLog.setLevel(Level.OFF);
        try {
            this.db.close(false);
        }
        catch (PersistitException e2) {
            Logs.APP_LOG.error((Object)"An exception occurred shutting down the phase queues.", (Throwable)e2);
        }
    }

    @Override
    public Map<PipelinePhase, AtomicInteger> getQueueDepths() {
        return this.queueDepths;
    }

    public ConcurrentMap<String, ConcurrentMap<PipelinePhase, AtomicInteger>> getPerRepoQueueDepths() {
        return this.perRepoQueueDepths;
    }

    @Override
    public void insertChangeSetsIntoQueue(final PipelinePhase phase, String repository, final Iterable<ChangeSetEntry> changesets) {
        this.withRetriableTransaction(this.db, new TxRunnable(){

            @Override
            public void execute(Exchange rootTree, Exchange repoTree) throws PersistitException {
                ChangeSetEntry latest = null;
                PartitionedChangeSetPhaseQueues.lockSubTree(repoTree, phase);
                PartitionedChangeSetPhaseQueues.lockSubTree(rootTree, phase);
                for (ChangeSetEntry entry : changesets) {
                    if (latest == null || entry.getTimestamp() > latest.getTimestamp()) {
                        latest = entry;
                    }
                    PartitionedChangeSetPhaseQueues.perRepoQueue(repoTree, phase, entry).store();
                }
                if (latest != null) {
                    PartitionedChangeSetPhaseQueues.this.updateRepoHead(rootTree, phase, latest);
                }
            }
        }, 60, ROOT_TREE, repository);
    }

    @Override
    public void clearAll() {
        if (this.shutdown || !this.pipelineVolumeExists()) {
            return;
        }
        try {
            Volume volume = this.db.getVolume(PIPELINE_VOL);
            for (final String treeName : volume.getTreeNames()) {
                this.withRetriableTransaction(this.db, new TxRunnable(){

                    @Override
                    public void execute(Exchange exchange, Exchange ignore) throws PersistitException {
                        if (exchange.hasChildren() && !exchange.removeAll()) {
                            Logs.APP_LOG.warn((Object)"Unable to clear phase queues.");
                            Logs.APP_LOG.debug((Object)("Key removal failed for tree " + treeName));
                        }
                    }
                }, 60, treeName, null);
            }
        }
        catch (PersistitException e2) {
            throw new DbException(e2);
        }
        this.resetQueueDepthCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpDbState(String header) {
        Logs.APP_LOG.debug((Object)"START <<<-----------------");
        try {
            Exchange ex = null;
            Transaction tx = null;
            Logs.APP_LOG.debug((Object)header);
            if (!this.pipelineVolumeExists()) {
                Logs.APP_LOG.debug((Object)"<empty>");
                return;
            }
            Volume v2 = this.db.getVolume(PIPELINE_VOL);
            try {
                for (String tree : v2.getTreeNames()) {
                    try {
                        Logs.APP_LOG.debug((Object)("TREE: " + tree));
                        ex = this.db.getExchange(PIPELINE_VOL, tree, false);
                        if (tx == null) {
                            tx = ex.getTransaction();
                            tx.begin();
                        }
                        ex.clear().append((Object)Key.BEFORE);
                        while (ex.next(true)) {
                            Logs.APP_LOG.debug((Object)(ex.getKey() + " -> " + ex.getValue()));
                        }
                    }
                    catch (PersistitException e2) {
                        try {
                            throw new DbException(e2);
                        }
                        catch (Throwable throwable) {
                            PartitionedChangeSetPhaseQueues.release(this.db, ex);
                            throw throwable;
                        }
                    }
                    PartitionedChangeSetPhaseQueues.release(this.db, ex);
                }
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (PersistitException e3) {
                throw new DbException(e3);
            }
            finally {
                PartitionedChangeSetPhaseQueues.cleanupTx(tx);
            }
        }
        finally {
            Logs.APP_LOG.debug((Object)"END >>>-----------------");
        }
    }

    private void resetQueueDepthCounts() {
        for (PipelinePhase phase : PipelinePhase.values()) {
            this.queueDepths.get((Object)phase).set(0);
        }
        this.perRepoQueueDepths.clear();
    }

    private static ChangeSetEntry getPhaseHeadForRepo(Exchange rootTree, PipelinePhase phase, String repo) throws PersistitException {
        PartitionedChangeSetPhaseQueues.phaseHeadRepoIndex(rootTree, phase, repo).append((Object)Key.BEFORE);
        if (rootTree.next(true) && rootTree.getKey().indexTo(0).decodeInt() == 30) {
            PipelinePhase pipelinePhase = PipelinePhase.valueOf(rootTree.getKey().indexTo(1).decodeString());
            String repoName = rootTree.getKey().indexTo(2).decodeString();
            long ts = rootTree.getKey().indexTo(3).decodeLong();
            String csid = rootTree.getKey().indexTo(4).decodeString();
            if (pipelinePhase == phase && repo.equals(repoName)) {
                return new ChangeSetEntry(repo, ts, csid);
            }
        }
        return null;
    }

    private boolean updateRepoHead(Exchange rootTree, PipelinePhase phase, ChangeSetEntry entry) throws PersistitException {
        ChangeSetEntry currentPhaseHead = PartitionedChangeSetPhaseQueues.getPhaseHeadForRepo(rootTree, phase, entry.getRepository());
        Logs.APP_LOG.debug((Object)("current phase " + (Object)((Object)phase) + " head = " + currentPhaseHead));
        if (!this.fair && currentPhaseHead != null) {
            if (currentPhaseHead.getTimestamp() > entry.getTimestamp()) {
                Logs.APP_LOG.debug((Object)"current is newer, leaving");
                return false;
            }
            Logs.APP_LOG.debug((Object)"current is older, removing");
            PartitionedChangeSetPhaseQueues.removePhaseHeadEntry(rootTree, phase, currentPhaseHead);
            currentPhaseHead = null;
        }
        if (currentPhaseHead == null) {
            Logs.APP_LOG.debug((Object)("storing new phase head " + entry));
            PartitionedChangeSetPhaseQueues.addPhaseHeadEntry(rootTree, phase, entry);
            return true;
        }
        return false;
    }

    private static void lockSubTree(Exchange exchange, PipelinePhase phase) throws PersistitException {
        Key lockKey = new Key(exchange.getPersistitInstance());
        lockKey.append(60).append((Object)phase.name());
        exchange.lock(lockKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EntryStatus getStatusForRepo(Exchange rootTree, String repo) throws PersistitException {
        try {
            rootTree.clear().append(0).append((Object)repo).fetch();
            Value v2 = rootTree.getValue();
            if (v2.isDefined()) {
                EntryStatus entryStatus = EntryStatus.valueOf(v2.getString());
                return entryStatus;
            }
            EntryStatus entryStatus = EntryStatus.UNKNOWN;
            return entryStatus;
        }
        finally {
            rootTree.getValue().clear();
        }
    }

    private static void setStatusForRepo(Exchange rootTree, String repo, EntryStatus status) throws PersistitException {
        EntryStatus oldStatus = PartitionedChangeSetPhaseQueues.getStatusForRepo(rootTree, repo);
        if (oldStatus != EntryStatus.UNKNOWN) {
            rootTree.clear().append(5).append((Object)oldStatus.name()).append((Object)repo).remove();
        }
        rootTree.getValue().clear();
        rootTree.clear().append(5).append((Object)status.name()).append((Object)repo).store();
        rootTree.getValue().put((Object)status.name());
        rootTree.clear().append(0).append((Object)repo).store();
        rootTree.getValue().clear();
    }

    private static Exchange phaseHeadRepoIndex(Exchange rootTree, PipelinePhase phase, String repo) {
        return rootTree.clear().append(30).append((Object)phase.name()).append((Object)repo);
    }

    private static Exchange phaseHeadRepoIndex(Exchange rootTree, PipelinePhase phase, ChangeSetEntry entry) {
        return rootTree.clear().append(30).append((Object)phase.name()).append((Object)entry.getRepository()).append(entry.getTimestamp()).append((Object)entry.getId());
    }

    private static Exchange phaseHeadTimestampIndex(Exchange rootTree, PipelinePhase phase) {
        return rootTree.clear().append(20).append((Object)phase.name());
    }

    private static Exchange phaseHeadTimestampIndex(Exchange rootTree, PipelinePhase phase, ChangeSetEntry entry) {
        return rootTree.clear().append(20).append((Object)phase.name()).append(entry.getTimestamp()).append((Object)entry.getRepository()).append((Object)entry.getId());
    }

    private static Exchange phaseHeadSeqIndex(Exchange rootTree, PipelinePhase phase) {
        return rootTree.clear().append(40).append((Object)phase.name());
    }

    private static Exchange phaseRepoSeqIndex(Exchange rootTree, PipelinePhase phase, String repo) {
        return rootTree.clear().append(50).append((Object)phase.name()).append((Object)repo);
    }

    private static Exchange perRepoQueue(Exchange repoTree, PipelinePhase phase, ChangeSetEntry csEntry) {
        return repoTree.clear().append(10).append((Object)csEntry.getRepository()).append((Object)phase.name()).append(csEntry.getTimestamp()).append((Object)csEntry.getId());
    }

    private static Exchange perRepoQueue(Exchange repoTree, String repo, PipelinePhase phase) {
        return repoTree.clear().append(10).append((Object)repo).append((Object)phase.name());
    }

    private ChangeSetEntry removePhaseHead(Exchange rootTree, PipelinePhase phase) throws PersistitException {
        PartitionedChangeSetPhaseQueues.lockSubTree(rootTree, phase);
        ChangeSetEntry entry = this.findPhaseHead(rootTree, phase);
        if (entry != null) {
            PartitionedChangeSetPhaseQueues.removePhaseHeadEntry(rootTree, phase, entry);
            return entry;
        }
        return null;
    }

    private ChangeSetEntry findPhaseHead(Exchange rootTree, PipelinePhase phase) throws PersistitException {
        if (this.fair) {
            if (PartitionedChangeSetPhaseQueues.phaseHeadSeqIndex(rootTree, phase).append((Object)Key.BEFORE).next(true) && rootTree.getKey().indexTo(0).decodeLong() == 40L && rootTree.getKey().indexTo(1).decodeString().equals(phase.name())) {
                String repo = rootTree.getKey().indexTo(3).decodeString();
                return PartitionedChangeSetPhaseQueues.getPhaseHeadForRepo(rootTree, phase, repo);
            }
        } else if (PartitionedChangeSetPhaseQueues.phaseHeadTimestampIndex(rootTree, phase).append((Object)Key.AFTER).previous(true) && rootTree.getKey().indexTo(0).decodeLong() == 20L && rootTree.getKey().indexTo(1).decodeString().equals(phase.name())) {
            long ts = rootTree.getKey().indexTo(2).decodeLong();
            String rep = rootTree.getKey().indexTo(3).decodeString();
            String csid = rootTree.getKey().indexTo(4).decodeString();
            return new ChangeSetEntry(rep, ts, csid);
        }
        return null;
    }

    private static void addPhaseHeadEntry(Exchange rootTree, PipelinePhase phase, ChangeSetEntry entry) throws PersistitException {
        rootTree.getValue().clear();
        PartitionedChangeSetPhaseQueues.phaseHeadTimestampIndex(rootTree, phase, entry).store();
        PartitionedChangeSetPhaseQueues.phaseHeadRepoIndex(rootTree, phase, entry).store();
        long seq = takeSequence.getAndIncrement();
        PartitionedChangeSetPhaseQueues.phaseHeadSeqIndex(rootTree, phase).append(seq).append((Object)entry.getRepository()).store();
        rootTree.getValue().put(seq);
        PartitionedChangeSetPhaseQueues.phaseRepoSeqIndex(rootTree, phase, entry.getRepository()).store();
    }

    private static void removePhaseHeadEntry(Exchange rootTree, PipelinePhase phase, ChangeSetEntry entry) throws PersistitException {
        PartitionedChangeSetPhaseQueues.phaseHeadTimestampIndex(rootTree, phase, entry).remove();
        PartitionedChangeSetPhaseQueues.phaseHeadRepoIndex(rootTree, phase, entry).remove();
        if (PartitionedChangeSetPhaseQueues.phaseRepoSeqIndex(rootTree, phase, entry.getRepository()).fetchAndRemove()) {
            long seq = rootTree.getValue().getLong();
            PartitionedChangeSetPhaseQueues.phaseHeadSeqIndex(rootTree, phase).append(seq).append((Object)entry.getRepository()).remove();
        }
    }

    private static void markAsOwned(Exchange repoTree, String ownerId, PipelinePhase phase, ChangeSetEntry entry) throws PersistitException {
        PartitionedChangeSetPhaseQueues.perRepoQueue(repoTree, phase, entry).getValue().putString(ownerId);
        Logs.APP_LOG.debug((Object)("marking " + entry.getId() + " as owned by " + ownerId));
        repoTree.store();
    }

    private static ChangeSetEntry getFirstUnownedInPhase(Exchange repoTree, String repo, PipelinePhase phase) throws PersistitException {
        PartitionedChangeSetPhaseQueues.perRepoQueue(repoTree, repo, phase).append((Object)Key.AFTER);
        while (repoTree.previous(true) && repoTree.getKey().indexTo(0).decodeLong() == 10L && repoTree.getKey().indexTo(2).decodeString().equals(phase.name())) {
            Value owner = repoTree.getValue();
            if (owner.isDefined() && !owner.isNull()) continue;
            long ts = repoTree.getKey().indexTo(3).decodeLong();
            String rep = repoTree.getKey().indexTo(1).decodeString();
            String csid = repoTree.getKey().indexTo(4).decodeString();
            return new ChangeSetEntry(rep, ts, csid);
        }
        return null;
    }

    private static void removePhaseHeadsForRepo(Exchange rootTree, String repo) throws PersistitException {
        for (PipelinePhase phase : PipelinePhase.values()) {
            ChangeSetEntry head = PartitionedChangeSetPhaseQueues.getPhaseHeadForRepo(rootTree, phase, repo);
            if (head == null) continue;
            PartitionedChangeSetPhaseQueues.removePhaseHeadEntry(rootTree, phase, head);
        }
    }

    private void withRetriableTransaction(Persistit db, TxRunnable txRunnable) {
        this.withRetriableTransaction(db, txRunnable, 60, ROOT_TREE, null);
    }

    /*
     * Exception decompiling
     */
    private void withRetriableTransaction(Persistit db, TxRunnable txRunnable, int maxRetries, String primaryTreeName, String secondaryTreeName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void cleanupTx(Transaction tx) {
        if (tx != null && tx.isActive()) {
            if (!tx.isCommitted() && !tx.isRollbackPending()) {
                tx.rollback();
            }
            tx.end();
        }
    }

    private static void release(Persistit db, Exchange ... exchanges) {
        if (exchanges != null) {
            for (Exchange exchange : exchanges) {
                if (exchange == null) continue;
                db.releaseExchange(exchange);
            }
        }
    }

    private boolean pipelineVolumeExists() {
        return this.db.getVolume(PIPELINE_VOL) != null;
    }

    static interface TxRunnable {
        public void execute(Exchange var1, Exchange var2) throws PersistitException;
    }

    private static enum EntryStatus {
        UNKNOWN,
        QUEUED,
        PARKED,
        REMOVED;

    }
}

