/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.pipeline;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fisheye.RuntimeWrappedException;
import com.atlassian.fisheye.event.RepositoryCacheDeletedEvent;
import com.atlassian.fisheye.event.RepositoryDeletedEvent;
import com.atlassian.fisheye.event.RepositoryScanningPausedEvent;
import com.atlassian.fisheye.event.RepositoryScanningResumedEvent;
import com.atlassian.fisheye.event.RepositoryStartedEvent;
import com.atlassian.fisheye.event.RepositoryStartingEvent;
import com.atlassian.fisheye.event.RepositoryStoppingEvent;
import com.atlassian.fisheye.pipeline.ChangeSetEntry;
import com.atlassian.fisheye.pipeline.ChangeSetPhaseQueues;
import com.atlassian.fisheye.pipeline.ChangeSetPipeline;
import com.atlassian.fisheye.pipeline.PartitionedChangeSetPhaseQueues;
import com.atlassian.fisheye.pipeline.PhaseProcessor;
import com.atlassian.fisheye.pipeline.PipelinePhase;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.ConfigurableThreadFactory;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.NamedExecution;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="defaultChangeSetPipeline")
public class DefaultChangeSetPipeline
implements ChangeSetPipeline {
    private int totalWorkers;
    private final LifecycleControl lifecycle = new LifecycleControl();
    private final EnumMap<PipelinePhase, PhaseProcessingPool> phaseProcessingPools = new EnumMap(PipelinePhase.class);
    private ChangeSetPhaseQueues queues;
    private RepositoryManager repositoryManager;
    private static final EnumMap<ChangeSetIndexingState, PipelinePhase> INDEXING_STATE_TO_PIPELINE_PHASE = new EnumMap<ChangeSetIndexingState, PipelinePhase>(ChangeSetIndexingState.class){
        {
            this.put(ChangeSetIndexingState.INFILLED, PipelinePhase.METADATA);
            this.put(ChangeSetIndexingState.METADATA_INDEXED, PipelinePhase.INDEXING);
        }
    };
    private final ConcurrentMap<String, Long> reconstructedRepos = new ConcurrentHashMap<String, Long>();
    private final EventPublisher eventPublisher;

    private static ExecutorService getFixedThreadPoolForPhase(int workers, PipelinePhase phase) {
        return Executors.newFixedThreadPool(workers, new ConfigurableThreadFactory(phase.name() + "-", false));
    }

    @Autowired
    public DefaultChangeSetPipeline(EventPublisher eventPublisher) throws DbException {
        this(new PartitionedChangeSetPhaseQueues(new File(AppConfig.getCacheDir(), "pipeline"), FishEyeSysProps.PIPELINE_FAIRNESS), eventPublisher);
    }

    public DefaultChangeSetPipeline(ChangeSetPhaseQueues queues, EventPublisher eventPublisher) throws DbException {
        this.queues = queues;
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void release() {
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    public void registerPhaseProcessor(PipelinePhase phase, PhaseProcessor processor, int workers) {
        this.guardAlreadyStarted();
        if (this.phaseProcessingPools.get((Object)phase) != null) {
            throw new IllegalArgumentException("There is already a phase processor defined for phase " + phase.name());
        }
        if (workers < 1) {
            throw new IllegalArgumentException("Need at least one worker for phase " + phase.name());
        }
        if (phase == PipelinePhase.DONE) {
            throw new IllegalArgumentException("No PhaseProcessors are allowed for the DONE phase");
        }
        PhaseProcessingPool phasePool = new PhaseProcessingPool(phase, processor, workers);
        this.phaseProcessingPools.put(phase, phasePool);
        this.totalWorkers += workers;
    }

    private void startPhasePools() {
        for (PhaseProcessingPool phasePool : this.phaseProcessingPools.values()) {
            phasePool.start();
        }
    }

    private void stopPhasePools() {
        for (PhaseProcessingPool phasePool : this.phaseProcessingPools.values()) {
            phasePool.shutdown();
        }
    }

    @Override
    public void startup(RepositoryManager repositoryManager) {
        this.guardAlreadyStarted();
        this.guardPhaseProcessorsConfigured();
        this.repositoryManager = repositoryManager;
        this.reconstructedRepos.clear();
        this.startPhasePools();
        this.lifecycle.start();
    }

    @Override
    public void shutdown() {
        this.guardNotStarted();
        this.lifecycle.shutdown();
        this.stopPhasePools();
        this.reconstructedRepos.clear();
        this.queues.shutdown();
        this.queues = null;
    }

    @EventListener
    public void onRepositoryStarting(RepositoryStartingEvent event) {
        if (this.lifecycle.isStarted() && this.isPipelined(event.getRepositoryName())) {
            this.queues.unparkEntries(event.getRepositoryName());
        }
    }

    @EventListener
    public void onRepositoryStarted(RepositoryStartedEvent event) {
        if (this.lifecycle.isStarted() && this.isPipelined(event.getRepositoryName()) && (event.isInitialStart() || !this.isQueueReconstructed(event.getRepositoryName()))) {
            this.reconstructQueue(event.getRepositoryName());
        }
    }

    @EventListener
    public void onRepositoryStopping(RepositoryStoppingEvent event) {
        if (this.lifecycle.isStarted() && this.isPipelined(event.getRepositoryName())) {
            this.queues.parkEntries(event.getRepositoryName());
        }
    }

    @EventListener
    public void onRepositoryScanningPaused(RepositoryScanningPausedEvent event) {
        if (this.lifecycle.isStarted() && this.isPipelined(event.getRepositoryName())) {
            this.queues.parkEntries(event.getRepositoryName());
        }
    }

    @EventListener
    public void onRepositoryScanningResumed(RepositoryScanningResumedEvent event) {
        if (this.lifecycle.isStarted() && this.isPipelined(event.getRepositoryName())) {
            this.queues.unparkEntries(event.getRepositoryName());
        }
    }

    @EventListener
    public void onRepositoryCacheDeleted(RepositoryCacheDeletedEvent event) {
        if (this.lifecycle.isStarted() && this.isPipelined(event.getRepositoryName())) {
            this.queues.removeEntries(event.getRepositoryName(), false);
            this.removeQueueReconstructedRecord(event.getRepositoryName());
        }
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        if (this.lifecycle.isStarted() && this.isPipelined(event.getRepositoryName())) {
            this.queues.removeEntries(event.getRepositoryName(), true);
            this.removeQueueReconstructedRecord(event.getRepositoryName());
        }
    }

    @Override
    public void put(ChangeSetEntry entry) {
        if (this.lifecycle.isStarted()) {
            this.queues.put(entry, PipelinePhase.first());
        }
    }

    @Override
    public Map<PipelinePhase, AtomicInteger> getQueueDepths() {
        return this.queues.getQueueDepths();
    }

    @Override
    public boolean isStarted() {
        return this.lifecycle.isStarted();
    }

    @Override
    public boolean isPaused() {
        return this.lifecycle.isPaused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        LifecycleControl lifecycleControl = this.lifecycle;
        synchronized (lifecycleControl) {
            if (this.lifecycle.isStarted()) {
                this.lifecycle.pause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        LifecycleControl lifecycleControl = this.lifecycle;
        synchronized (lifecycleControl) {
            if (this.lifecycle.isStarted()) {
                this.lifecycle.resume();
            }
        }
    }

    @Override
    public void dumpPipelineState() {
        this.queues.dumpDbState("");
    }

    private boolean isPipelined(String repo) {
        RepositoryHandle handle = this.repositoryManager.getRepository(repo);
        return handle != null && handle.isPipelined();
    }

    static Iterable<? extends ChangeSet> numericallySortChangesetIterable(Iterable<? extends ChangeSet> changesets) {
        ArrayList sortedChangesets = Lists.newArrayList(changesets);
        Collections.sort(sortedChangesets, new Comparator<ChangeSet>(){

            @Override
            public int compare(ChangeSet o1, ChangeSet o2) {
                return Long.valueOf(o1.getId()).compareTo(Long.valueOf(o2.getId()));
            }
        });
        return sortedChangesets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconstructQueue(String repo) {
        RepositoryHandle handle = this.repositoryManager.getRepository(repo);
        if (handle == null) {
            Logs.APP_LOG.warn((Object)("Unknown repo '" + repo + "'"));
        } else if (handle.isPipelined()) {
            this.queues.removeEntries(repo, false);
            Disposer.pushThreadInstance();
            try {
                RepositoryEngine engine = handle.acquireEngine();
                RevisionCache<? extends ChangeSet> csimpl = engine.getRevisionCache();
                for (ChangeSetIndexingState indexingState : ChangeSetIndexingState.values()) {
                    PipelinePhase phase = INDEXING_STATE_TO_PIPELINE_PHASE.get((Object)indexingState);
                    if (phase == null) continue;
                    Iterable<Object> changesets = csimpl.getChangeSetsInState(indexingState);
                    if (handle.isChangesetIdNumeric()) {
                        changesets = DefaultChangeSetPipeline.numericallySortChangesetIterable(changesets);
                    }
                    int batchSize = engine.getPipelineBatchSize();
                    Logs.APP_LOG.debug((Object)("reconstructing queue " + (Object)((Object)phase) + " for repo " + repo + ", batch size " + batchSize));
                    if (batchSize == 1) {
                        this.queues.insertChangeSetsIntoQueue(phase, repo, Iterables.transform(changesets, (Function)new Function<ChangeSet, ChangeSetEntry>(){

                            public ChangeSetEntry apply(ChangeSet input) {
                                return ChangeSetEntry.fromChangeSet(input);
                            }
                        }));
                        continue;
                    }
                    if (batchSize > 1) {
                        String from = null;
                        int count = 0;
                        ArrayList<ChangeSetEntry> entries = new ArrayList<ChangeSetEntry>();
                        Iterator<Object> changeSetIterator = changesets.iterator();
                        while (changeSetIterator.hasNext()) {
                            ChangeSet cs = (ChangeSet)changeSetIterator.next();
                            if (from == null) {
                                from = cs.getId();
                            }
                            if (from == null || ++count != batchSize && changeSetIterator.hasNext()) continue;
                            count = 0;
                            String to = cs.getId();
                            if (from.equals(to)) {
                                entries.add(new ChangeSetEntry(handle.getName(), cs.getDate(), to));
                            } else {
                                entries.add(new ChangeSetEntry(handle.getName(), cs.getDate(), from, to));
                            }
                            from = null;
                        }
                        if (entries.isEmpty()) continue;
                        this.queues.insertChangeSetsIntoQueue(phase, repo, entries);
                        continue;
                    }
                    throw new IllegalStateException("illegal pipeline batch size of " + batchSize);
                }
                this.recordQueueReconstructed(repo);
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)("pipeline reconstruction failed for repository '" + repo + "': " + e2.getMessage()));
            }
            catch (RepositoryHandle.StateException e3) {
                Logs.APP_LOG.warn((Object)("pipeline reconstruction failed for repository '" + repo + "': " + e3.getMessage()));
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
    }

    private boolean isQueueReconstructed(String repo) {
        return this.reconstructedRepos.containsKey(repo);
    }

    private void recordQueueReconstructed(String repo) {
        this.reconstructedRepos.put(repo, System.currentTimeMillis());
    }

    private void removeQueueReconstructedRecord(String repo) {
        this.reconstructedRepos.remove(repo);
    }

    private void guardPhaseProcessorsConfigured() {
        for (PipelinePhase phase : PipelinePhase.values()) {
            if (phase.equals((Object)PipelinePhase.DONE) || this.phaseProcessingPools.get((Object)phase) != null) continue;
            throw new IllegalStateException("No phase processor defined for phase " + phase.name());
        }
    }

    private void guardAlreadyStarted() {
        if (this.lifecycle.isStarted()) {
            throw new IllegalStateException("Pipeline is already running");
        }
    }

    private void guardNotStarted() {
        if (!this.lifecycle.isStarted()) {
            throw new IllegalStateException("Pipeline is not running");
        }
    }

    class LifecycleControl {
        boolean shutdown;
        boolean started;
        boolean paused;
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch shutdownLatch = new CountDownLatch(1);
        Semaphore pauser;

        LifecycleControl() {
        }

        public void start() {
            this.pauser = new Semaphore(DefaultChangeSetPipeline.this.totalWorkers);
            this.startLatch.countDown();
            this.started = true;
            this.paused = false;
        }

        public void shutdown() {
            if (!this.isStarted()) {
                this.start();
            }
            this.shutdownLatch.countDown();
            this.shutdown = true;
            this.started = false;
            this.paused = false;
        }

        public void awaitStart() throws InterruptedException {
            this.startLatch.await();
        }

        public void awaitShutdown() throws InterruptedException {
            this.shutdownLatch.await();
        }

        public boolean isStarted() {
            return this.started;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public boolean isShutdown() {
            return this.shutdown;
        }

        public void blockIfPaused() throws InterruptedException {
            this.pauser.acquire();
            this.pauser.release();
        }

        public void pause() {
            if (!this.paused) {
                try {
                    this.pauser.acquire(DefaultChangeSetPipeline.this.totalWorkers);
                    this.paused = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void resume() {
            if (this.paused) {
                this.pauser.release(DefaultChangeSetPipeline.this.totalWorkers);
                this.paused = false;
            }
        }
    }

    class PhaseProcessingPool {
        private final PipelinePhase phase;
        private final PhaseProcessor processor;
        private final int workers;
        private ExecutorService workerPool;

        PhaseProcessingPool(PipelinePhase phase, PhaseProcessor processor, int workers) {
            this.phase = phase;
            this.processor = processor;
            this.workers = workers;
        }

        public void start() {
            this.workerPool = DefaultChangeSetPipeline.getFixedThreadPoolForPhase(this.workers, this.phase);
            for (int i2 = 0; i2 < this.workers; ++i2) {
                this.workerPool.execute(new PhaseProcessorRunnable(this.phase.name() + "-" + (i2 + 1), this.phase, this.processor));
            }
        }

        public void shutdown() {
            this.workerPool.shutdownNow();
        }
    }

    class PhaseProcessorRunnable
    implements Runnable {
        private final String name;
        private final PipelinePhase phase;
        private final PhaseProcessor processor;

        PhaseProcessorRunnable(String name, PipelinePhase phase, PhaseProcessor processor) {
            this.name = name;
            this.phase = phase;
            this.processor = processor;
        }

        @Override
        public void run() {
            try {
                DefaultChangeSetPipeline.this.lifecycle.awaitStart();
                while (!DefaultChangeSetPipeline.this.lifecycle.isShutdown()) {
                    ChangeSetPhaseQueues localQueues = DefaultChangeSetPipeline.this.queues;
                    if (localQueues == null) continue;
                    DefaultChangeSetPipeline.this.lifecycle.blockIfPaused();
                    final ChangeSetEntry entry = localQueues.take(this.name, this.phase);
                    if (entry == null) continue;
                    final AtomicBoolean processed = new AtomicBoolean(false);
                    try {
                        new NamedExecution(entry.getRepository() + "[" + entry.getId() + "]").run(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    processed.set(PhaseProcessorRunnable.this.processor.processChangesetEntry(entry));
                                }
                                catch (InterruptedException e2) {
                                    throw new RuntimeWrappedException(e2);
                                }
                                catch (Exception e3) {
                                    Logs.APP_LOG.debug((Object)("Exception processing " + entry), (Throwable)e3);
                                    processed.set(false);
                                }
                            }
                        });
                    }
                    catch (RuntimeWrappedException e2) {
                        break;
                    }
                    if (DefaultChangeSetPipeline.this.lifecycle.isShutdown()) continue;
                    if (processed.get()) {
                        PipelinePhase nextPhase = this.phase.next();
                        localQueues.updateAndRelease(this.name, entry, this.phase, nextPhase);
                        continue;
                    }
                    localQueues.updateAndRelease(this.name, entry, this.phase, this.phase);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

