/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.pipeline;

import com.cenqua.fisheye.rep.ChangeSet;

public class ChangeSetEntry {
    private String repository;
    private long timestamp;
    private String id;

    public static ChangeSetEntry fromChangeSet(ChangeSet changeSet) {
        return new ChangeSetEntry(changeSet.getRepName(), changeSet.getDate(), changeSet.getId());
    }

    public ChangeSetEntry(String repository, long timestamp, String fromID, String toID) {
        this(repository, timestamp, fromID + "-" + toID);
    }

    public ChangeSetEntry(String repository, long timestamp, String id) {
        this.repository = repository;
        this.timestamp = timestamp;
        this.id = id;
    }

    public String getRepository() {
        return this.repository;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRange() {
        return this.id.indexOf(45) > 0;
    }

    public String getFromID() {
        if (!this.isRange()) {
            return this.id;
        }
        return this.id.split("-")[0];
    }

    public String getToID() {
        if (!this.isRange()) {
            return this.id;
        }
        return this.id.split("-")[1];
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ChangeSetEntry that = (ChangeSetEntry)o2;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.repository.equals(that.repository);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.repository.hashCode();
        return result;
    }

    public String toString() {
        return "ChangeSetEntry{repository='" + this.repository + '\'' + ", timestamp=" + this.timestamp + ", id='" + this.id + '\'' + '}';
    }
}

