/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.model.managers;

import com.atlassian.crucible.event.cscomment.CsCommentCreatedEventImpl;
import com.atlassian.crucible.event.cscomment.CsCommentDeletedEventImpl;
import com.atlassian.crucible.event.cscomment.CsCommentUpdatedEventImpl;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.crucible.spi.data.CsCommentData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.event.RepositoryDeletedEvent;
import com.atlassian.fisheye.model.ChangesetComment;
import com.atlassian.fisheye.model.managers.ChangesetCommentManager;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
public class DefaultChangesetCommentManager
implements ChangesetCommentManager {
    private TxTemplate txTemplate;
    private RepositoryManager repositoryManager;
    private UserManager userManager;
    private RootConfig rootConfig;
    private final EventPublisher eventPublisher;
    private SPIUserUtils spiUserUtils;

    @Autowired
    public DefaultChangesetCommentManager(TxTemplate txTemplate, RepositoryManager repositoryManager, UserManager userManager, RootConfig rootConfig, EventPublisher eventPublisher, SPIUserUtils spiUserUtils) {
        this.txTemplate = txTemplate;
        this.repositoryManager = repositoryManager;
        this.userManager = userManager;
        this.rootConfig = rootConfig;
        this.eventPublisher = eventPublisher;
        this.spiUserUtils = spiUserUtils;
    }

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void release() {
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    public List<ChangesetComment> getCommentsForChangeset(String repository, String changeset) {
        FecruUser currentUser = this.txTemplate.getEffectiveCrucibleUser();
        String draftTerm = currentUser == null ? "(comment.draft = false)" : "((comment.draft = false) or (comment.user = :user))";
        StringBuilder sb = new StringBuilder("from ChangesetComment comment where comment.deleted = false and comment.repository = :rep and comment.csid = :csid and " + draftTerm + " order by comment.createDateTime");
        Query q2 = DefaultChangesetCommentManager.session().createQuery(sb.toString());
        if (currentUser != null) {
            q2.setEntity("user", (Object)currentUser);
        }
        q2.setString("rep", repository);
        q2.setString("csid", changeset);
        return HibernateUtil.typedList(q2);
    }

    private static Session session() {
        return HibernateUtil.currentSession();
    }

    @Override
    public ChangesetComment addNewComment(final FecruUser user, final String repname, final String csid, final String text, final Integer parent, final boolean defect, final boolean draft) throws Exception {
        return this.txTemplate.execute(new TxCallback<ChangesetComment>(){

            @Override
            public ChangesetComment doInTransaction(TransactionStatus status) throws Exception {
                ChangesetComment parentComment = null;
                if (parent != null && (parentComment = (ChangesetComment)DefaultChangesetCommentManager.session().get(ChangesetComment.class, (Serializable)parent)) == null) {
                    throw new Exception("Could not add reply. Parent comment " + parent + " has been deleted. Original text: " + text);
                }
                ChangesetComment newComment = new ChangesetComment(user, repname, csid, text, parentComment, defect, draft);
                DefaultChangesetCommentManager.session().save((Object)newComment);
                DefaultChangesetCommentManager.this.eventPublisher.publish((Object)new CsCommentCreatedEventImpl(DefaultChangesetCommentManager.this.spiUserUtils.createUserData(user), repname, csid, newComment.getPermaId()));
                return newComment;
            }
        });
    }

    @Override
    public ChangesetComment updateComment(final int id, final String newText, final boolean defect, final boolean draft) throws Exception {
        return this.txTemplate.execute(new TxCallback<ChangesetComment>(){

            @Override
            public ChangesetComment doInTransaction(TransactionStatus status) throws Exception {
                ChangesetComment comment = (ChangesetComment)DefaultChangesetCommentManager.session().get(ChangesetComment.class, (Serializable)Integer.valueOf(id));
                if (comment == null) {
                    throw new Exception("Could not find comment to edit. Comment id: " + id + "; update text: " + newText);
                }
                if (!DefaultChangesetCommentManager.this.canEdit(DefaultChangesetCommentManager.this.txTemplate.getEffectiveCrucibleUser(), comment)) {
                    throw new Exception("You don't have permission to edit this comment. Comment id: " + id + "; update text: " + newText);
                }
                String oldText = comment.getMessage();
                comment.setMessage(newText);
                comment.setDefectRaised(defect);
                comment.setDraft(draft);
                DefaultChangesetCommentManager.this.eventPublisher.publish((Object)new CsCommentUpdatedEventImpl(DefaultChangesetCommentManager.this.spiUserUtils.createUserData(DefaultChangesetCommentManager.this.txTemplate.getEffectiveCrucibleUser()), comment.getRepository(), comment.getCsid(), comment.getPermaId(), oldText));
                return comment;
            }
        });
    }

    @Override
    public Boolean deleteComment(final int id) throws Exception {
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                ChangesetComment comment = (ChangesetComment)DefaultChangesetCommentManager.session().get(ChangesetComment.class, (Serializable)Integer.valueOf(id));
                if (comment == null) {
                    return true;
                }
                if (!DefaultChangesetCommentManager.this.canEdit(DefaultChangesetCommentManager.this.txTemplate.getEffectiveCrucibleUser(), comment)) {
                    throw new Exception("You don't have permission to delete this comment. Comment id: " + id);
                }
                DefaultChangesetCommentManager.session().delete((Object)comment);
                DefaultChangesetCommentManager.this.eventPublisher.publish((Object)new CsCommentDeletedEventImpl(DefaultChangesetCommentManager.this.spiUserUtils.createUserData(DefaultChangesetCommentManager.this.txTemplate.getEffectiveCrucibleUser()), comment.getRepository(), comment.getCsid(), comment.getPermaId()));
                return true;
            }
        });
    }

    private boolean canEdit(FecruUser user, ChangesetComment comment) {
        return comment.getUser().equals(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChangesetComment.Info> getCommentsForRep(String repository, int startCommentId, int maxResults) {
        try {
            Query q2 = HibernateUtil.currentSession().createQuery("from ChangesetComment comment where comment.repository = :rep and comment.id > :startCommentId order by comment.id asc");
            q2.setString("rep", repository);
            q2.setInteger("startCommentId", startCommentId);
            q2.setMaxResults(maxResults);
            ImmutableList immutableList = ImmutableList.copyOf((Collection)Lists.transform(HibernateUtil.typedList(q2), (Function)new Function<ChangesetComment, ChangesetComment.Info>(){

                public ChangesetComment.Info apply(ChangesetComment csc) {
                    return csc.toInfo();
                }
            }));
            return immutableList;
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    @Override
    public ChangesetComment getComment(String stringId) {
        try {
            int id = Integer.parseInt(stringId);
            return this.getComment(id);
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.warn((Object)("Error retrieving changeset comment: id not an integer [" + stringId + "]"));
            return null;
        }
    }

    @Override
    public ChangesetComment getComment(int id) {
        return (ChangesetComment)DefaultChangesetCommentManager.session().get(ChangesetComment.class, (Serializable)Integer.valueOf(id));
    }

    @Override
    public ChangesetComment getComment(PermId<CsCommentData> id) {
        String stringId = id.getId().substring("CSCMT:".length());
        return this.getComment(stringId);
    }

    @Override
    public boolean canSeeComments(String repository) {
        RepositoryHandle r2;
        if (AppConfig.isCrucible() && (r2 = this.repositoryManager.getRepository(repository)) != null && this.isAllowChangesetDiscussions(r2) && this.userCanAccessRepo(r2)) {
            FecruUser user = this.txTemplate.getEffectiveCrucibleUser();
            return user != null || this.rootConfig.isCruAnonAccessAllowed();
        }
        return false;
    }

    private boolean userCanAccessRepo(RepositoryHandle r2) {
        return this.userManager.hasPermissionToAccess(this.txTemplate.getEffectivePrincipal(), r2);
    }

    private boolean isAllowChangesetDiscussions(RepositoryHandle repository) {
        return repository.getCfg().isAllowChangesetDiscussions();
    }

    @Override
    public boolean canAddComments(String repository) {
        RepositoryHandle r2;
        if (AppConfig.isCrucible() && (r2 = this.repositoryManager.getRepository(repository)) != null && this.isAllowChangesetDiscussions(r2) && this.userCanAccessRepo(r2)) {
            FecruUser user = this.txTemplate.getEffectiveCrucibleUser();
            return user != null;
        }
        return false;
    }

    private void deleteChangesetCommentsForRep(final String repository) {
        this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                Query q2 = DefaultChangesetCommentManager.session().createQuery("delete from ChangesetComment where repository = :rep");
                q2.setString("rep", repository).executeUpdate();
                return true;
            }
        });
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent e2) {
        this.deleteChangesetCommentsForRep(e2.getRepositoryName());
    }
}

