/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.model;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.ModelUtils;
import com.cenqua.fisheye.util.StringUtil;
import java.util.Date;
import javax.annotation.Nonnull;

public class ChangesetComment
implements Comparable<ChangesetComment> {
    private static final int DISPLAY_TRUNCATE_LENGTH = 47;
    public static final String PERMAID_PREFIX = "CSCMT:";
    @Nonnull
    private String message;
    private boolean draft = false;
    private boolean deleted = false;
    private boolean defectRaised = false;
    @Nonnull
    private FecruUser user;
    private Integer id;
    private long createDateTime;
    private long updatedDateTime;
    @Nonnull
    private String repository;
    @Nonnull
    private String csid;
    private ChangesetComment replyToComment;

    ChangesetComment() {
        long time = System.currentTimeMillis();
        this.setCreateDateTime(time);
        this.setUpdatedDateTime(time);
    }

    public ChangesetComment(FecruUser user, String repname, String csid, String newComment, ChangesetComment parentComment, boolean defect, boolean draft) {
        this();
        this.setUser(user);
        this.setReplyToComment(parentComment);
        this.setDefectRaised(defect);
        this.setDraft(draft);
        this.setCsid(csid);
        this.setMessage(newComment);
        this.setRepository(repname);
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        ModelUtils.ensureNotNullOrEmpty("Changeset comment messages", message);
        this.message = message;
    }

    public boolean getDraft() {
        return this.draft;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean getDefectRaised() {
        return this.defectRaised;
    }

    public void setDefectRaised(boolean defectRaised) {
        this.defectRaised = defectRaised;
    }

    public boolean isDefectRaised() {
        return this.defectRaised;
    }

    public FecruUser getUser() {
        return this.user;
    }

    public void setUser(FecruUser user) {
        this.user = user;
    }

    public ChangesetComment getReplyToComment() {
        return this.replyToComment;
    }

    public void setReplyToComment(ChangesetComment replyToComment) {
        this.replyToComment = replyToComment;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        ModelUtils.ensureNotNullOrEmpty("Comment repository", repository);
        this.repository = repository;
    }

    public String getCsid() {
        return this.csid;
    }

    public void setCsid(String csid) {
        ModelUtils.ensureNotNullOrEmpty("Changeset comment csids", csid);
        this.csid = csid;
    }

    public long getUpdatedDateTime() {
        return this.updatedDateTime;
    }

    public Date getUpdatedDate() {
        return new Date(this.updatedDateTime);
    }

    public void setUpdatedDateTime(long updatedDateTime) {
        this.updatedDateTime = updatedDateTime;
    }

    public long getCreateDateTime() {
        return this.createDateTime;
    }

    public Date getCreateDate() {
        return new Date(this.createDateTime);
    }

    public void setCreateDateTime(long createDateTime) {
        this.createDateTime = createDateTime;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (!(o2 instanceof ChangesetComment)) {
            return false;
        }
        Integer oid = ((ChangesetComment)o2).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        if (this.id == null) {
            throw new IllegalStateException("Called hashCode with null id");
        }
        return this.id;
    }

    public String toString() {
        return super.toString() + "(" + this.getId() + ": " + this.getUser().getUsername() + ", " + this.getCreateDate() + (this.isDraft() ? ", Draft" : "") + (this.isDefectRaised() ? ", Defect" : "") + ", " + this.getMessage() + ")";
    }

    @Override
    public int compareTo(ChangesetComment o2) {
        if (o2 == null) {
            return 1;
        }
        if (this.updatedDateTime != o2.updatedDateTime) {
            return (int)Math.signum(this.updatedDateTime - o2.updatedDateTime);
        }
        return this.id - o2.getId();
    }

    public String getTruncatedMessage() {
        return StringUtil.truncate(this.message, 47, true);
    }

    public String getPermaId() {
        return PERMAID_PREFIX + this.id;
    }

    public Info toInfo() {
        return new Info(this.getId(), this.getUpdatedDateTime(), this.getRepository(), this.getCsid(), this.getMessage(), this.getUser().getUsername());
    }

    public static class Info {
        private final Integer id;
        private final long timestamp;
        private final String repository;
        private final String csid;
        private final String message;
        private final String author;

        Info(Integer id, long timestamp, String repository, String csid, String message, String author) {
            this.id = id;
            this.timestamp = timestamp;
            this.repository = repository;
            this.csid = csid;
            this.message = message;
            this.author = author;
        }

        public Integer getId() {
            return this.id;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getCsid() {
            return this.csid;
        }

        public String getMessage() {
            return this.message;
        }

        public String getAuthor() {
            return this.author;
        }
    }
}

