/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.manifest;

import com.atlassian.fecru.util.ListIterable;
import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.dvcs.client.DvcsCommandBuilder;
import com.atlassian.fisheye.dvcs.handler.DvcsProcessException;
import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.client.GitAction;
import com.atlassian.fisheye.git.client.GitChangeParser;
import com.atlassian.fisheye.git.client.GitChangePath;
import com.atlassian.fisheye.git.client.GitCommandBuilder;
import com.atlassian.fisheye.git.client.GitCommitDetails;
import com.atlassian.fisheye.git.client.GitContext;
import com.atlassian.fisheye.git.db.GitChangeSet;
import com.atlassian.fisheye.git.db.GitRevInfo;
import com.atlassian.fisheye.manifest.CommonManifest;
import com.atlassian.fisheye.manifest.CommonManifestDAO;
import com.atlassian.fisheye.manifest.ManifestProcessor;
import com.atlassian.utils.process.OutputHandler;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.crossrepo.PathIndexer;
import com.cenqua.fisheye.csindex.ChangesetIndexer;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.LogicalPathMatcher;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.google.common.collect.Iterables;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;

public class ManifestUpgrader {
    private final String repoName;
    private final GitCache cache;
    private final RepositoryStatus status;
    private final CommonManifestDAO manifestDAO;
    private final ChangesetIndexer changesetIndexer;
    private final PathIndexer pathCrossRepoIndexer;
    private final LogicalPathMatcher pathMatcher;
    private final ManifestProcessor manifestProcessor;
    private final String[] renameOption;
    private final GitContext context;

    public ManifestUpgrader(String repoName, GitCache cache, RepositoryStatus status, ChangesetIndexer changesetIndexer, PathIndexer pathCrossRepoIndexer, LogicalPathMatcher pathMatcher, ManifestProcessor manifestProcessor, String[] renameOption, GitContext context) {
        this.repoName = repoName;
        this.cache = cache;
        this.status = status;
        this.changesetIndexer = changesetIndexer;
        this.pathCrossRepoIndexer = pathCrossRepoIndexer;
        this.pathMatcher = pathMatcher;
        this.manifestProcessor = manifestProcessor;
        this.manifestDAO = manifestProcessor.getManifestDAO();
        this.renameOption = renameOption;
        this.context = context;
    }

    public void doUpgrade(long timeLimit) throws DvcsProcessException {
        boolean upgradeRequired;
        this.context.refreshMainBranchNameIfStale(false);
        ListIterable<GitChangeSet> changeSetsIterable = this.cache.getChangeSetDAO().getChangeSets();
        boolean bl = upgradeRequired = !Iterables.isEmpty(changeSetsIterable);
        if (!upgradeRequired) {
            this.markUpgradeComplete();
            return;
        }
        if (this.upgradeChangesetIterable(changeSetsIterable, timeLimit)) {
            this.markUpgradeComplete();
            this.status.setMessage("Manifest upgrade complete");
            Logs.APP_LOG.info((Object)("Manifest upgrade complete for repository " + this.repoName));
        }
    }

    private void markUpgradeComplete() {
        this.cache.setScanProperty(CommonProperties.GIT_MANIFEST_UPGRADE.value, System.currentTimeMillis());
        this.cache.commit();
    }

    private boolean upgradeChangesetIterable(ListIterable<GitChangeSet> iterable, long timeLimit) throws DvcsProcessException {
        int totalUpgradeCount = 0;
        int batchUpgradeCount = 0;
        int pathCount = 0;
        boolean oneUpgraded = false;
        long changesetTotal = this.cache.countChangeSets();
        HashSet<String> requireCrossRepoIndexing = new HashSet<String>();
        for (GitChangeSet changeset : iterable) {
            ++totalUpgradeCount;
            if (!this.manifestDAO.exists(changeset.getId())) {
                if (!oneUpgraded) {
                    if (totalUpgradeCount == 1) {
                        this.status.setMessage("Starting background manifest upgrade process for " + changesetTotal + " changesets");
                    } else {
                        this.status.setMessage("Resuming background manifest upgrade process at changeset " + totalUpgradeCount + " of " + changesetTotal);
                    }
                    oneUpgraded = true;
                }
                ++batchUpgradeCount;
                if ((pathCount += this.upgradeChangesetManifest(changeset, requireCrossRepoIndexing)) > FishEyeSysProps.maxManifestUpgradePaths) {
                    this.completeBatch(requireCrossRepoIndexing);
                    this.status.setMessage("Upgraded " + totalUpgradeCount + " manifests of " + changesetTotal + " changesets");
                    pathCount = 0;
                }
                if (this.status.isStopRequested()) {
                    this.completeBatch(requireCrossRepoIndexing);
                    return false;
                }
            }
            if (timeLimit <= 0L || System.currentTimeMillis() <= timeLimit || batchUpgradeCount < FishEyeSysProps.manifestUpgradeBatchSize) continue;
            this.completeBatch(requireCrossRepoIndexing);
            return false;
        }
        this.completeBatch(requireCrossRepoIndexing);
        return true;
    }

    private void completeBatch(Set<String> requireCrossRepoIndexing) {
        if (!requireCrossRepoIndexing.isEmpty()) {
            this.pathCrossRepoIndexer.indexPathsForChangeSetIds(this.repoName, this.cache, requireCrossRepoIndexing, this.pathMatcher, this.status);
            this.changesetIndexer.indexChangesetsAndAuthors(this.cache.getCrossRepLuceneConnection(), this.cache, requireCrossRepoIndexing, this.status, true, null, false);
            requireCrossRepoIndexing.clear();
        }
        this.cache.commit();
    }

    private int upgradeChangesetManifest(GitChangeSet changeset, Set<String> requireCrossRepoIndexing) throws DvcsProcessException {
        if (changeset.getParents().size() > 1) {
            Logs.APP_LOG.debug((Object)("Upgrading merge manifest for " + changeset.getId()));
            return this.upgradeMergeManifest(changeset, requireCrossRepoIndexing);
        }
        Logs.APP_LOG.debug((Object)("Upgrading simple manifest for " + changeset.getId()));
        return this.upgradeSimpleManifest(changeset);
    }

    private int upgradeSimpleManifest(GitChangeSet changeset) {
        List<String> parents = changeset.getParents();
        String parent = parents.size() == 1 ? parents.get(0) : null;
        return this.manifestProcessor.saveSimpleManifest(changeset.getId(), parent);
    }

    private int upgradeMergeManifest(final GitChangeSet changeset, final Set<String> requireCrossRepoIndexing) throws DvcsProcessException {
        final GitCommitDetails commitDetails = this.getCommitDetails(changeset);
        return this.manifestProcessor.saveMergeManifest(commitDetails, new ManifestProcessor.MergeDeleteCallback(){

            @Override
            public void deleteInMerge(String deletedFromParent, GitChangePath path) {
                ManifestUpgrader.this.createMergeDelete(changeset, commitDetails, deletedFromParent, path);
                requireCrossRepoIndexing.add(changeset.getId());
            }
        });
    }

    private void createMergeDelete(GitChangeSet changeset, GitCommitDetails commitDetails, String deletedFromParent, GitChangePath changePath) {
        String branch;
        GitRevInfo revInfo = new GitRevInfo();
        revInfo.setComment(changeset.getComment());
        revInfo.setAuthor(changeset.getAuthor());
        revInfo.setEmail(commitDetails.getEmail());
        revInfo.setDate(changeset.getDate());
        revInfo.setPath(this.context.getLocalPath(changePath.getPath()));
        revInfo.setRevision(commitDetails.getCommitHash());
        revInfo.setFileType(1);
        final AtomicReference<String> branchRef = new AtomicReference<String>(changeset.getBranch());
        if (branchRef.get() == null) {
            changeset.visitRevisions(new StoppableVisitor<FileRevision>(){

                @Override
                public boolean visit(FileRevision revision) {
                    if (revision.getBranch() != null) {
                        branchRef.set(revision.getBranch());
                        return false;
                    }
                    return true;
                }
            });
        }
        if (branchRef.get() == null) {
            branchRef.set(this.context.getMainBranchName());
        }
        revInfo.addBranch((branch = branchRef.get()) == null ? "master" : branch);
        revInfo.setTrunkLike(branch == null || branch.equals(this.context.getMainBranchName()));
        revInfo.setDestHash(changePath.getDestHash());
        revInfo.setDestMode(changePath.getDestMode());
        revInfo.setSrcHash(changePath.getSrcHash());
        revInfo.setDead(true);
        revInfo.setLineCount(0);
        revInfo.setLinesAdded(0);
        CommonManifest deletedFromParentManifest = this.manifestDAO.load(deletedFromParent);
        if (deletedFromParentManifest == null) {
            Logs.APP_LOG.warn((Object)("Unable to load manifest for parent " + deletedFromParent + " commit of " + commitDetails.getCommitHash()));
        } else {
            String ancestorCommit = deletedFromParentManifest.getPathCommit(revInfo.getPath());
            if (ancestorCommit != null) {
                GitRevInfo ancestor = (GitRevInfo)this.cache.getFileRevision(new RevInfoKey(revInfo.getPath(), ancestorCommit));
                revInfo.setLinesRemoved(ancestor.getLineCount());
                AncestorLink ancestorLink = new AncestorLink(AncestorLink.Type.DIRECT, ancestor.getRevID());
                Logs.APP_LOG.debug((Object)("Creating delete for a merge delete: " + revInfo.getRevInfoKey()));
                try {
                    this.cache.getFileRevisionDAO().insertNew(revInfo, ancestorLink, false);
                }
                catch (LicensePolicyException e2) {
                    Logs.APP_LOG.debug((Object)"Ignoring license policy exception during manifest upgrade", (Throwable)e2);
                }
            }
        }
    }

    private GitCommitDetails getCommitDetails(GitChangeSet changeset) {
        GitCommandBuilder command = new GitCommandBuilder("whatchanged", "--always", "-m", "-1", "--no-abbrev");
        command.append(this.renameOption);
        command.append(changeset.getId());
        command.append("--pretty=format:C:%H%nP:%P%nA:%aN%nE:%aE%nR:%cN%nF:%cE%nD:%at%nS:%s%nB:%b%n@@fe_body_end@@");
        if (StringUtils.isNotBlank((String)this.context.getPath())) {
            command.append("--", this.context.getPath());
        }
        final AtomicReference commitDetailsRef = new AtomicReference();
        Charset encoding = this.context.getScmConfig().getEncoding();
        try {
            this.context.executeCommand((DvcsCommandBuilder)command, (OutputHandler)new GitChangeParser(encoding, this.status){

                @Override
                protected boolean processCommit(GitCommitDetails details) throws DbException {
                    commitDetailsRef.set(details);
                    return true;
                }
            });
        }
        catch (DvcsProcessException e2) {
            Logs.APP_LOG.debug((Object)("Unable to get commit details for " + changeset.getId() + ", synthesizing details"), (Throwable)e2);
        }
        if (commitDetailsRef.get() != null) {
            return (GitCommitDetails)commitDetailsRef.get();
        }
        GitCommitDetails synthDetails = new GitCommitDetails(changeset.getBranch(), changeset.getId());
        synthDetails.setCommitter(changeset.getAuthor());
        synthDetails.setAuthor(changeset.getAuthor());
        synthDetails.setDate(changeset.getDateValue());
        synthDetails.setParents(changeset.getParents());
        for (GitRevInfo revInfo : changeset.getFileRevisions()) {
            synthDetails.addPath(this.synthesizeChangePath(revInfo));
        }
        if (!synthDetails.hasAllPathSets()) {
            synthDetails.addEmptyParents();
        }
        return synthDetails;
    }

    private GitChangePath synthesizeChangePath(GitRevInfo revInfo) {
        GitChangePath changePath = new GitChangePath(this.context.getServerPath(revInfo.getPath()));
        changePath.setDestHash(revInfo.getDestHash());
        changePath.setSrcHash(revInfo.getSrcHash());
        changePath.setDestMode(revInfo.getDestMode());
        GitAction action = revInfo.isAdded() ? GitAction.ADD : (revInfo.isCopy() ? GitAction.COPY : (revInfo.isDead() ? GitAction.DELETE : (revInfo.isModify() ? GitAction.MODIFY : (revInfo.isMove() ? GitAction.RENAME : GitAction.UNKNOWN))));
        changePath.setAction(action);
        return changePath;
    }
}

