/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.manifest;

import com.atlassian.fisheye.manifest.ManifestDbEntry;
import java.util.Comparator;
import java.util.Iterator;

public class ManifestTraversal
implements Iterator<ManifestDbEntry> {
    private Iterator<ManifestDbEntry> iterator;
    private ManifestDbEntry current;
    private int depth;

    public ManifestTraversal(int depth, Iterator<ManifestDbEntry> iterator) {
        this.iterator = iterator;
        this.depth = depth;
        this.current = iterator.hasNext() ? iterator.next() : null;
    }

    @Override
    public ManifestDbEntry next() {
        ManifestDbEntry result = this.current;
        this.current = this.iterator.hasNext() ? this.iterator.next() : null;
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Manifest paths cannot be removed by this iterator");
    }

    public static class TraversalComparator
    implements Comparator<ManifestTraversal> {
        @Override
        public int compare(ManifestTraversal o1, ManifestTraversal o2) {
            if (o2.current == null) {
                return o1.current == null ? 0 : -1;
            }
            if (o1.current == null) {
                return 1;
            }
            if (o1.current.getPathId() == o2.current.getPathId()) {
                return o2.depth - o1.depth;
            }
            return (int)(o1.current.getPathId() - o2.current.getPathId());
        }
    }
}

