/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.manifest;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.client.GitAction;
import com.atlassian.fisheye.git.client.GitChangePath;
import com.atlassian.fisheye.git.client.GitCommitDetails;
import com.atlassian.fisheye.git.client.GitContext;
import com.atlassian.fisheye.git.db.GitRevInfoDAO;
import com.atlassian.fisheye.manifest.CommonManifest;
import com.atlassian.fisheye.manifest.CommonManifestDAO;
import com.atlassian.fisheye.manifest.CommonManifestDAOImpl;
import com.atlassian.fisheye.manifest.ManifestEntry;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.util.Timer;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ManifestProcessor {
    private final RepositoryStatus status;
    private final GitContext context;
    private CommonManifestDAO commonManifestDAO;
    private GitRevInfoDAO fileRevDAO;
    private int maxManifestDepth;

    public void setMaxManifestDepth(int maxManifestDepth) {
        this.maxManifestDepth = maxManifestDepth;
    }

    public CommonManifestDAO getManifestDAO() {
        return this.commonManifestDAO;
    }

    public boolean exists(String commit) {
        return this.commonManifestDAO.exists(commit);
    }

    public ManifestProcessor(RepositoryStatus status, GitCache cache, GitContext context, GitRevInfoDAO fileRevDAO) {
        this.status = status;
        this.context = context;
        this.commonManifestDAO = new CommonManifestDAOImpl(cache.getInfDb(), (CommonStringTables)cache.getStringTables());
        this.fileRevDAO = fileRevDAO;
        this.maxManifestDepth = FishEyeSysProps.maxManifestDepth;
    }

    public void writeNewManifest(String commitHash, Set<Long> writtenPaths) {
        this.commonManifestDAO.createFullManifest(commitHash);
        this.writeCommitManifestPaths(commitHash, writtenPaths);
    }

    public void writeCommitManifestPaths(final String commitHash, final Set<Long> writtenPaths) {
        this.fileRevDAO.visitChangeSetRevisions(commitHash, new StoppableVisitor<FileRevision>(){

            @Override
            public boolean visit(FileRevision fileRevision) {
                long pathId = ManifestProcessor.this.commonManifestDAO.getPathId(fileRevision.getPath());
                if (!writtenPaths.contains(pathId)) {
                    ManifestProcessor.this.commonManifestDAO.addManifestEntry(commitHash, fileRevision.getPath(), commitHash, fileRevision.isDead());
                    writtenPaths.add(pathId);
                }
                return true;
            }
        });
    }

    public void writeFullManifest(CommonManifest parentManifest, final String commitHash, final Set<Long> writtenPaths) {
        this.writeNewManifest(commitHash, writtenPaths);
        if (parentManifest != null) {
            parentManifest.visitPaths(new Visitor<ManifestEntry>(){

                @Override
                public void visit(ManifestEntry manifestEntry) {
                    if (!writtenPaths.contains(manifestEntry.getPathId())) {
                        ManifestProcessor.this.commonManifestDAO.addManifestEntry(commitHash, manifestEntry);
                        writtenPaths.add(manifestEntry.getPathId());
                    }
                }
            });
        }
    }

    public int saveSimpleManifest(String commitHash, String parentCommit) {
        LongOpenHashSet storedManifestPathIds = new LongOpenHashSet();
        if (parentCommit == null) {
            this.writeNewManifest(commitHash, (Set<Long>)storedManifestPathIds);
        } else {
            CommonManifest parentManifest = this.commonManifestDAO.load(parentCommit);
            if (parentManifest == null || parentManifest.getDepth() >= this.maxManifestDepth) {
                this.writeFullManifest(parentManifest, commitHash, (Set<Long>)storedManifestPathIds);
            } else {
                this.commonManifestDAO.createDeltaManifest(commitHash, parentManifest);
                this.writeCommitManifestPaths(commitHash, (Set<Long>)storedManifestPathIds);
            }
        }
        return storedManifestPathIds.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveMergeManifest(GitCommitDetails commitDetails, MergeDeleteCallback callback) {
        Timer timer = new Timer("Saving merge manifest");
        try {
            boolean isFullManifest;
            if (!commitDetails.hasAllPathSets()) {
                this.context.addEmptyPathSets(commitDetails);
            }
            this.checkForMergeDeletes(commitDetails, callback);
            String commitHash = commitDetails.getCommitHash();
            int minDepth = Integer.MAX_VALUE;
            CommonManifest referenceManifest = null;
            HashSet<String> parents = new HashSet<String>(commitDetails.getParents());
            HashMap<String, CommonManifest> parentManifests = new HashMap<String, CommonManifest>(parents.size());
            for (String parentCommit : parents) {
                CommonManifest manifest = this.commonManifestDAO.load(parentCommit);
                if (manifest == null) continue;
                parentManifests.put(parentCommit, manifest);
                if (manifest.getDepth() >= minDepth) continue;
                minDepth = manifest.getDepth();
                referenceManifest = manifest;
            }
            LongOpenHashSet storedManifestPathIds = new LongOpenHashSet();
            if (referenceManifest == null) {
                this.writeNewManifest(commitHash, (Set<Long>)storedManifestPathIds);
                int parentCommit = minDepth;
                return parentCommit;
            }
            boolean bl = isFullManifest = minDepth >= this.maxManifestDepth;
            if (isFullManifest) {
                this.commonManifestDAO.createFullManifest(commitHash);
            } else {
                this.commonManifestDAO.createDeltaManifest(commitHash, referenceManifest);
            }
            this.writeCommitManifestPaths(commitHash, (Set<Long>)storedManifestPathIds);
            for (CommonManifest manifest : parentManifests.values()) {
                this.visitParentManifest(commitDetails, manifest, referenceManifest, parentManifests, isFullManifest, (Set<Long>)storedManifestPathIds);
            }
            int n2 = storedManifestPathIds.size();
            return n2;
        }
        finally {
            timer.end();
        }
    }

    private void checkForMergeDeletes(GitCommitDetails commitDetails, MergeDeleteCallback callback) {
        ArrayList<CommonManifest> parentManifests = new ArrayList<CommonManifest>();
        for (String parentId : commitDetails.getParents()) {
            CommonManifest parentManifest = this.commonManifestDAO.load(parentId);
            if (parentManifest == null) continue;
            parentManifests.add(parentManifest);
        }
        for (String parentId : commitDetails.getParents()) {
            Collection<GitChangePath> parentPaths = commitDetails.getChangedPaths(parentId);
            for (GitChangePath path : parentPaths) {
                Path localPath;
                if (path.getAction() != GitAction.DELETE || this.fileRevDAO.exists(new RevInfoKey(localPath = this.context.getLocalPath(path.getPath()), commitDetails.getCommitHash())) || this.isDeletedInAnyParent(parentManifests, localPath)) continue;
                callback.deleteInMerge(parentId, path);
            }
        }
    }

    private void visitParentManifest(final GitCommitDetails commitDetails, CommonManifest parentManifest, final CommonManifest referenceManifest, final Map<String, CommonManifest> parentManifests, final boolean fullManifest, final Set<Long> storedManifestPathIds) {
        final String commitHash = commitDetails.getCommitHash();
        final HashSet<String> parents = new HashSet<String>(commitDetails.getParents());
        parentManifest.visitPaths(new Visitor<ManifestEntry>(){

            @Override
            public void visit(ManifestEntry manifestEntry) {
                ManifestProcessor.this.status.throwOnStopRequested();
                if (storedManifestPathIds.contains(manifestEntry.getPathId())) {
                    return;
                }
                storedManifestPathIds.add(manifestEntry.getPathId());
                RevInfoKey key = manifestEntry.getRevInfoKey();
                String serverPath = ManifestProcessor.this.context.getServerPath(key.getPath());
                Map<String, GitChangePath> changePaths = commitDetails.getChangePathsByParent(serverPath);
                if (changePaths == null || changePaths.isEmpty()) {
                    if (fullManifest) {
                        ManifestProcessor.this.commonManifestDAO.addManifestEntry(commitHash, manifestEntry);
                    } else {
                        boolean isNotPresent = false;
                        for (Map.Entry entry : parentManifests.entrySet()) {
                            if (((CommonManifest)entry.getValue()).getPathCommit(key.getPath()) != null) continue;
                            isNotPresent = true;
                            break;
                        }
                        if (isNotPresent) {
                            ManifestProcessor.this.commonManifestDAO.addManifestEntry(commitHash, manifestEntry);
                        }
                    }
                    return;
                }
                Set<String> diffParents = changePaths.keySet();
                if (diffParents.size() == parents.size()) {
                    ManifestProcessor.this.commonManifestDAO.addManifestEntry(commitHash, key.getPath(), commitHash, false);
                } else {
                    Sets.SetView unchangedFromParents = Sets.difference((Set)parents, diffParents);
                    String unchangedParent = (String)unchangedFromParents.iterator().next();
                    CommonManifest manifest = (CommonManifest)parentManifests.get(unchangedParent);
                    if (manifest != null) {
                        String parentCommit = manifest.getPathCommit(key.getPath());
                        if (parentCommit != null) {
                            boolean isDeleted = manifest.isDeleted(key.getPath());
                            if (fullManifest) {
                                ManifestProcessor.this.commonManifestDAO.addManifestEntry(commitHash, key.getPath(), parentCommit, isDeleted);
                            } else if (manifest != referenceManifest) {
                                ManifestProcessor.this.commonManifestDAO.addManifestEntry(commitHash, key.getPath(), parentCommit, isDeleted);
                            }
                        }
                    } else {
                        Logs.APP_LOG.warn((Object)("Unable to find parent manifest for parent " + unchangedParent + " of " + commitHash));
                    }
                }
            }
        });
    }

    private boolean isDeletedInAnyParent(List<CommonManifest> parentManifests, Path path) {
        for (CommonManifest manifest : parentManifests) {
            if (!manifest.isDeleted(path)) continue;
            return true;
        }
        return false;
    }

    public static interface MergeDeleteCallback {
        public void deleteInMerge(String var1, GitChangePath var2);
    }
}

