/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.manifest;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.manifest.CommonManifest;
import com.atlassian.fisheye.manifest.InternalManifestDAO;
import com.atlassian.fisheye.manifest.ManifestDbEntry;
import com.atlassian.fisheye.manifest.ManifestEntry;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.InfDbIterable;

class FullManifest
implements CommonManifest {
    private final InternalManifestDAO manifestDAO;
    private final long commitDbId;

    public FullManifest(InternalManifestDAO manifestDAO, long commitDbId) {
        this.manifestDAO = manifestDAO;
        this.commitDbId = commitDbId;
    }

    @Override
    public String getCommitId() {
        return this.manifestDAO.getCommitId(this.commitDbId);
    }

    @Override
    public void visitPaths(Visitor<ManifestEntry> visitor) {
        InfDbIterable<ManifestDbEntry> iterable = this.manifestDAO.getManifestEntryIterable(this.commitDbId);
        for (ManifestDbEntry manifestDbEntry : iterable) {
            visitor.visit(new ManifestEntry(this.manifestDAO, manifestDbEntry));
        }
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public String getPathCommit(Path path) {
        ManifestDbEntry manifestDbEntry = this.manifestDAO.getManifestEntry(this.commitDbId, this.manifestDAO.getPathId(path));
        return manifestDbEntry != null ? this.manifestDAO.getCommitId(manifestDbEntry.getCommitDbId()) : null;
    }

    @Override
    public boolean isDeleted(Path path) {
        ManifestDbEntry manifestDbEntry = this.manifestDAO.getManifestEntry(this.commitDbId, this.manifestDAO.getPathId(path));
        return manifestDbEntry != null && manifestDbEntry.isDeleted();
    }

    @Override
    public void dumpManifest() {
        this.manifestDAO.dump(this.commitDbId);
    }

    public String toString() {
        return "Full Manifest for " + this.getCommitId();
    }
}

