/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.manifest;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.manifest.CommonManifest;
import com.atlassian.fisheye.manifest.InternalManifestDAO;
import com.atlassian.fisheye.manifest.ManifestDbEntry;
import com.atlassian.fisheye.manifest.ManifestEntry;
import com.atlassian.fisheye.manifest.ManifestTraversal;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

class DeltaManifest
implements CommonManifest {
    private final InternalManifestDAO manifestDAO;
    private final long commitDbId;
    private final int depth;
    private final List<Long> parentCommitDbIds;

    public DeltaManifest(InternalManifestDAO manifestDAO, long commitDbId, long parentCommitDbId, int depth) {
        this.manifestDAO = manifestDAO;
        this.commitDbId = commitDbId;
        this.depth = depth;
        this.parentCommitDbIds = new ArrayList<Long>(depth);
        this.parentCommitDbIds.add(parentCommitDbId);
    }

    private String getParentCommit() {
        return this.manifestDAO.getCommitId(this.parentCommitDbIds.get(0));
    }

    @Override
    public String getCommitId() {
        return this.manifestDAO.getCommitId(this.commitDbId);
    }

    @Override
    public void visitPaths(Visitor<ManifestEntry> visitor) {
        ManifestDbEntry manifestDbEntry;
        TreeSet<ManifestTraversal> traversals = new TreeSet<ManifestTraversal>(new ManifestTraversal.TraversalComparator());
        int traversalDepth = this.depth;
        long id = this.commitDbId;
        int index = 0;
        while (traversalDepth >= 0) {
            if (id == -1L) {
                throw new DbException("Trying to load a non-existent manifest entry when traversing manifest for " + this.getCommitId());
            }
            traversals.add(new ManifestTraversal(traversalDepth--, this.manifestDAO.getManifestEntryIterable(id).iterator()));
            id = this.getParentCommitId(index++, null);
        }
        long lastPathVisitedId = -1L;
        while (traversals.size() > 1) {
            ManifestTraversal head = (ManifestTraversal)traversals.first();
            traversals.remove(head);
            manifestDbEntry = head.next();
            lastPathVisitedId = this.visitIfNotVisited(visitor, lastPathVisitedId, manifestDbEntry);
            if (!head.hasNext()) continue;
            traversals.add(head);
        }
        if (!traversals.isEmpty()) {
            ManifestTraversal lastTraversal = (ManifestTraversal)traversals.first();
            while (lastTraversal.hasNext()) {
                manifestDbEntry = lastTraversal.next();
                lastPathVisitedId = this.visitIfNotVisited(visitor, lastPathVisitedId, manifestDbEntry);
            }
        }
    }

    private long visitIfNotVisited(Visitor<ManifestEntry> visitor, long lastPathVisitedId, ManifestDbEntry manifestDbEntry) {
        if (manifestDbEntry.getPathId() > lastPathVisitedId) {
            visitor.visit(new ManifestEntry(this.manifestDAO, manifestDbEntry));
            return manifestDbEntry.getPathId();
        }
        return lastPathVisitedId;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public String getPathCommit(Path path) {
        ManifestDbEntry manifestDbEntry = this.getManifestPath(path);
        return manifestDbEntry != null ? this.manifestDAO.getCommitId(manifestDbEntry.getCommitDbId()) : null;
    }

    private ManifestDbEntry getManifestPath(Path path) {
        long pathId = this.manifestDAO.getPathId(path);
        long id = this.commitDbId;
        int index = 0;
        while (id != -1L) {
            ManifestDbEntry manifestDbEntry = this.manifestDAO.getManifestEntry(id, pathId);
            if (manifestDbEntry != null) {
                return manifestDbEntry;
            }
            id = this.getParentCommitId(index++, path);
        }
        return null;
    }

    private long getParentCommitId(int index, Path path) {
        if (this.parentCommitDbIds.size() - 1 < index) {
            int lastIndex = this.parentCommitDbIds.size() - 1;
            long id = this.parentCommitDbIds.get(lastIndex);
            for (int i2 = lastIndex + 1; i2 <= index; ++i2) {
                long manifestParentDbId = this.manifestDAO.getManifestParentDbId(id);
                if (this.parentCommitDbIds.contains(manifestParentDbId)) {
                    throw new RuntimeException("getManifestParentDbId(" + id + ") returned duplicate id '" + manifestParentDbId + "'" + (path != null ? " while looking for manifest for path '" + path.getPath() + "'" : ""));
                }
                this.parentCommitDbIds.add(manifestParentDbId);
                if (manifestParentDbId == -1L) {
                    return -1L;
                }
                id = manifestParentDbId;
            }
        }
        return this.parentCommitDbIds.get(index);
    }

    @Override
    public boolean isDeleted(Path path) {
        ManifestDbEntry manifestDbEntry = this.getManifestPath(path);
        return manifestDbEntry != null && manifestDbEntry.isDeleted();
    }

    @Override
    public void dumpManifest() {
        this.manifestDAO.dump(this.commitDbId);
    }

    public String toString() {
        return "Delta Manifest for " + this.getCommitId() + ", parent = " + this.getParentCommit() + ", depth = " + this.depth;
    }
}

