/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.manifest;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.manifest.CommonManifest;
import com.atlassian.fisheye.manifest.CommonManifestDAO;
import com.atlassian.fisheye.manifest.DeltaManifest;
import com.atlassian.fisheye.manifest.FullManifest;
import com.atlassian.fisheye.manifest.InternalManifestDAO;
import com.atlassian.fisheye.manifest.ManifestDbEntry;
import com.atlassian.fisheye.manifest.ManifestEntry;
import com.atlassian.fisheye.manifest.ManifestType;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.InfDbIterable;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;

public class CommonManifestDAOImpl
implements CommonManifestDAO,
InternalManifestDAO {
    private final InfinityDbHandle dbh;
    private final CommonStringTables stringTables;

    public CommonManifestDAOImpl(InfinityDbHandle dbh, CommonStringTables stringTables) {
        this.dbh = dbh;
        this.stringTables = stringTables;
    }

    @Override
    public CommonManifest load(String commitId) {
        long commitDbId = this.stringTables.changeSetIdDB.find(commitId);
        if (commitDbId == -1L) {
            throw new DbException("Unable to find commit id for " + commitId);
        }
        return this.loadManifest(commitDbId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CommonManifest loadManifest(long commitDbId) {
        CommonManifest manifest = null;
        y cu = this.getManifestCu(commitDbId);
        try {
            ac db = this.dbh.get();
            cu.a(CommonSchema.ManifestInfo.A_TYPE);
            int pl = cu.e();
            if (!db.a(cu, pl)) return manifest;
            ManifestType type = ManifestType.fromInt((int)cu.v(pl));
            switch (type) {
                case FULL: {
                    manifest = this.loadFullManifest(commitDbId);
                    return manifest;
                }
                case DELTA: {
                    manifest = this.loadDeltaManifest(commitDbId);
                    return manifest;
                }
            }
            return manifest;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    @Override
    public long getManifestParentDbId(long commitDbId) {
        y cu = this.getManifestCu(commitDbId);
        try {
            ManifestType type;
            ac db = this.dbh.get();
            int keylength = cu.e();
            cu.a(CommonSchema.ManifestInfo.A_TYPE);
            int typeKeyLen = cu.e();
            long parentCommitDbId = -1L;
            if (db.a(cu, typeKeyLen) && (type = ManifestType.fromInt((int)cu.v(typeKeyLen))) == ManifestType.DELTA) {
                cu.d(keylength).a(CommonSchema.ManifestInfo.A_PARENT);
                int parentKeyLen = cu.e();
                if (db.a(cu, parentKeyLen)) {
                    parentCommitDbId = cu.v(parentKeyLen);
                } else {
                    throw new DbException("Could not get delta manifest parent for commit " + this.getCommitId(commitDbId));
                }
            }
            long l2 = parentCommitDbId;
            return l2;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    private CommonManifest loadDeltaManifest(long commitDbId) {
        y cu = this.getManifestCu(commitDbId);
        try {
            ac db = this.dbh.get();
            int keylength = cu.e();
            cu.a(CommonSchema.ManifestInfo.A_DEPTH);
            int attrLen = cu.e();
            int depth = 0;
            if (db.a(cu, attrLen)) {
                depth = (int)cu.v(attrLen);
            }
            long parentCommitDbId = -1L;
            cu.d(keylength).a(CommonSchema.ManifestInfo.A_PARENT);
            attrLen = cu.e();
            if (db.a(cu, attrLen)) {
                parentCommitDbId = cu.v(attrLen);
            }
            if (parentCommitDbId == -1L) {
                String commitId = this.getCommitId(commitDbId);
                throw new DbException("Manifest corrupt as could not find parent manifest for " + commitId);
            }
            DeltaManifest deltaManifest = new DeltaManifest(this, commitDbId, parentCommitDbId, depth);
            return deltaManifest;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    @Override
    public String getCommitId(long commitDbId) {
        return this.stringTables.changeSetIdDB.get(commitDbId);
    }

    @Override
    public long getPathId(Path path) {
        return this.stringTables.pathDB.find(path.getPath());
    }

    @Override
    public boolean exists(String commit) {
        long commitDbId = this.stringTables.changeSetIdDB.find(commit);
        if (commitDbId == -1L) {
            Logs.APP_LOG.warn((Object)("Commit does not exist when looking for manifest: " + commit));
            return false;
        }
        y cu = this.getManifestCu(commitDbId);
        try {
            ac db = this.dbh.get();
            cu.a(CommonSchema.ManifestInfo.A_TYPE);
            int pl = cu.e();
            boolean bl = db.a(cu, pl);
            return bl;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    @Override
    public ManifestDbEntry getManifestEntry(long commitDbId, long pathId) {
        y cu = this.getManifestCu(commitDbId);
        try {
            ac db = this.dbh.get();
            cu.a(CommonSchema.ManifestInfo.A_PATHS);
            cu.b(pathId);
            int pl = cu.e();
            if (db.a(cu, pl)) {
                long pathCommitDbId = cu.v(pl);
                int offset = cu.w(pl);
                boolean deleted = cu.s(offset);
                ManifestDbEntry manifestDbEntry = new ManifestDbEntry(pathId, pathCommitDbId, deleted);
                return manifestDbEntry;
            }
            ManifestDbEntry manifestDbEntry = null;
            return manifestDbEntry;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    @Override
    public void addManifestEntry(String commit, ManifestEntry manifestEntry) {
        RevInfoKey key = manifestEntry.getRevInfoKey();
        this.addManifestEntry(commit, key.getPath(), key.getRev(), manifestEntry.isDeleted());
    }

    @Override
    public void dump(long commitDbId) {
        if (Logs.isDebugMode()) {
            CommonManifest manifest = this.loadManifest(commitDbId);
            Logs.APP_LOG.debug((Object)("Dumping manifest " + manifest));
            manifest.visitPaths(new Visitor<ManifestEntry>(){

                @Override
                public void visit(ManifestEntry manifestEntry) {
                    Logs.APP_LOG.debug((Object)("Manifest Path key " + manifestEntry.getRevInfoKey() + " from " + manifestEntry));
                }
            });
            Logs.APP_LOG.debug((Object)"-------");
        }
    }

    private CommonManifest loadFullManifest(long commitDbId) {
        return new FullManifest(this, commitDbId);
    }

    @Override
    public InfDbIterable<ManifestDbEntry> getManifestEntryIterable(long commitDbId) {
        y cu = this.getManifestCu(commitDbId);
        cu.a(CommonSchema.ManifestInfo.A_PATHS);
        int keyLength = cu.e();
        return new InfDbIterable<ManifestDbEntry>(this.dbh, cu, keyLength){

            @Override
            public ManifestDbEntry getElement(y cu, int elementOffset) throws IOException, DbException {
                long pathId = cu.v(elementOffset);
                int offset = cu.w(elementOffset);
                long commitDbId = cu.v(offset);
                offset = cu.w(offset);
                boolean deleted = cu.s(offset);
                return new ManifestDbEntry(pathId, commitDbId, deleted);
            }
        };
    }

    @Override
    public CommonManifest createFullManifest(String commitId) {
        long commitDbId = this.stringTables.changeSetIdDB.add(commitId);
        this.deleteManifest(commitDbId);
        y cu = this.getManifestCu(commitDbId);
        try {
            ac db = this.dbh.get();
            cu.a(CommonSchema.ManifestInfo.A_TYPE).b((long)ManifestType.FULL.getValue());
            db.b(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
        return this.loadFullManifest(commitDbId);
    }

    @Override
    public CommonManifest createDeltaManifest(String commitId, CommonManifest parentManifest) {
        long commitDbId = this.stringTables.changeSetIdDB.add(commitId);
        this.deleteManifest(commitDbId);
        y cu = this.getManifestCu(commitDbId);
        try {
            ac db = this.dbh.get();
            int keylength = cu.e();
            cu.a(CommonSchema.ManifestInfo.A_TYPE).b((long)ManifestType.DELTA.getValue());
            db.b(cu);
            int depth = parentManifest.getDepth() + 1;
            cu.d(keylength).a(CommonSchema.ManifestInfo.A_DEPTH).b((long)depth);
            db.b(cu);
            long parentCommitDbId = this.stringTables.changeSetIdDB.find(parentManifest.getCommitId());
            if (parentCommitDbId == -1L) {
                throw new DbException("Unable to find commit id for parent commit " + parentManifest.getCommitId());
            }
            cu.d(keylength).a(CommonSchema.ManifestInfo.A_PARENT).b(parentCommitDbId);
            db.b(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
        return this.loadDeltaManifest(commitDbId);
    }

    private y getManifestCu(long commitDbId) {
        y cu = y.a();
        cu.a(CommonSchema.ManifestInfo.ENTITY).b(commitDbId);
        return cu;
    }

    @Override
    public void addManifestEntry(String commitId, ManifestDbEntry manifestDbEntry) {
        long commitDbId = this.stringTables.changeSetIdDB.find(commitId);
        if (commitDbId == -1L) {
            throw new DbException("Unable to find commit id for " + commitId);
        }
        y cu = this.getManifestCu(commitDbId);
        try {
            ac db = this.dbh.get();
            cu.a(CommonSchema.ManifestInfo.A_PATHS);
            cu.b(manifestDbEntry.getPathId());
            int pl = cu.e();
            cu.b(manifestDbEntry.getCommitDbId());
            cu.a(manifestDbEntry.isDeleted());
            db.e(cu, pl);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    @Override
    public void addManifestEntry(String manifestCommitId, Path path, String pathLastCommitId, boolean isDeleted) {
        if (pathLastCommitId == null) {
            throw new IllegalArgumentException("Adding invalid manifest path for " + path + "@" + manifestCommitId);
        }
        long pathId = this.stringTables.pathDB.find(path.getPath());
        if (pathId == -1L) {
            throw new DbException("Unable to find path id for " + path);
        }
        long commitDbId = this.stringTables.changeSetIdDB.find(pathLastCommitId);
        if (commitDbId == -1L) {
            throw new DbException("Unable to find commit id for " + pathLastCommitId);
        }
        ManifestDbEntry manifestDbEntry = new ManifestDbEntry(pathId, commitDbId, isDeleted);
        this.addManifestEntry(manifestCommitId, manifestDbEntry);
    }

    private void deleteManifest(long commitDbId) {
        y cu = this.getManifestCu(commitDbId);
        try {
            ac db = this.dbh.get();
            int pl = cu.e();
            while (db.a(cu, pl)) {
                db.c(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    @Override
    public RevInfoKey fromManifestEntry(ManifestDbEntry manifestDbEntry) {
        Path path = new Path(this.stringTables.pathDB.get(manifestDbEntry.getPathId()));
        String commitHash = this.getCommitId(manifestDbEntry.getCommitDbId());
        return new RevInfoKey(path, commitHash);
    }
}

