/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.jira.setup;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationException;
import com.atlassian.applinks.spi.auth.AuthenticationScenario;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.link.ReciprocalActionException;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.fisheye.jira.setup.CrowdApplicationEntity;
import com.atlassian.fisheye.jira.setup.JiraSetupException;
import com.atlassian.fisheye.jira.setup.JiraSetupService;
import com.atlassian.fisheye.trustedapplications.FisheyeAuthenticationListener;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.AdminUserConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraSetupServiceImpl
implements JiraSetupService {
    private final MutatingApplicationLinkService applicationLinkService;
    private final TypeAccessor typeAccessor;
    private final ManifestRetriever manifestRetriever;
    private final FisheyeAuthenticationListener fisheyeAuthenticationListener;
    private final CrowdDirectoryService crowdDirectoryService;
    private final GlobalPermissionManager globalPermissionManager;
    private final HostApplication hostApplication;
    private final AdminUserConfig adminUserConfig;

    @Autowired
    public JiraSetupServiceImpl(MutatingApplicationLinkService applicationLinkService, CrowdDirectoryService crowdDirectoryService, GlobalPermissionManager globalPermissionManager, TypeAccessor typeAccessor, HostApplication hostApplication, ManifestRetriever manifestRetriever, FisheyeAuthenticationListener fisheyeAuthenticationListener, AdminUserConfig adminUserConfig) {
        this.applicationLinkService = applicationLinkService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.globalPermissionManager = globalPermissionManager;
        this.hostApplication = hostApplication;
        this.typeAccessor = typeAccessor;
        this.manifestRetriever = manifestRetriever;
        this.fisheyeAuthenticationListener = fisheyeAuthenticationListener;
        this.adminUserConfig = adminUserConfig;
    }

    @Override
    public void linkFishEyeToJIRA(URI remoteRpcUrl, URI localRpcUrl, String username, String password, Iterable<String> groupsWithFecruAccess, Iterable<String> adminGroups) throws JiraSetupException {
        this.checkServerIsJiraWithEmbeddedCrowd(remoteRpcUrl);
        this.checkAdminCredentials(remoteRpcUrl, username, password);
        ApplicationLink applicationLink = null;
        try {
            applicationLink = this.createReciprocatedApplicationLink(remoteRpcUrl, localRpcUrl, username, password);
            this.authenticateApplicationLink(applicationLink, username, password, localRpcUrl);
            CrowdApplicationEntity crowdApplication = this.createFishEyeApplicationInCrowd(applicationLink, username, password);
            this.permissionGroupsForFecruAccess(groupsWithFecruAccess);
            this.setupCrowdAuthentication(remoteRpcUrl, crowdApplication.getName(), crowdApplication.getPassword());
        }
        catch (Exception e2) {
            try {
                if (applicationLink != null) {
                    this.applicationLinkService.deleteApplicationLink(applicationLink);
                }
                Logs.APP_LOG.info((Object)"Rolled back connection attempt to JIRA");
            }
            catch (Exception rollbackException) {
                Logs.APP_LOG.error((Object)"Failed to rollback local UAL/Crowd configuration", (Throwable)rollbackException);
            }
            if (e2 instanceof JiraSetupException) {
                throw (JiraSetupException)e2;
            }
            throw new JiraSetupException("Failed to setup JIRA integration: " + e2.getMessage(), e2);
        }
        this.setupAdminUsers(adminGroups);
    }

    private void checkServerIsJiraWithEmbeddedCrowd(URI remoteRpcUrl) throws JiraSetupException {
        Manifest manifest;
        try {
            manifest = this.manifestRetriever.getManifest(remoteRpcUrl);
        }
        catch (ManifestNotFoundException e2) {
            Logs.APP_LOG.error((Object)("Failed to retrieve manifest from " + remoteRpcUrl), (Throwable)e2);
            throw new JiraSetupException("Could not retrieve manifest from " + remoteRpcUrl + ". Please check the JIRA Server URL, and ensure it is JIRA 4.3 or later.");
        }
        JiraApplicationType jiraType = (JiraApplicationType)this.typeAccessor.getApplicationType(JiraApplicationType.class);
        if (jiraType == null) {
            throw new IllegalStateException("JiraApplicationType not installed, have you modified or disabled the Application Link plugin?");
        }
        if (!manifest.getTypeId().equals((Object)TypeId.getTypeId((com.atlassian.applinks.api.ApplicationType)jiraType))) {
            throw new JiraSetupException("Specified url " + remoteRpcUrl + " appears to be an application of type: " + manifest.getTypeId() + ". Please specify a JIRA 4.3+ server.");
        }
    }

    private void checkAdminCredentials(URI remoteRpcUrl, String username, String password) throws JiraSetupException {
        try {
            if (!this.applicationLinkService.isAdminUserInRemoteApplication(remoteRpcUrl, username, password)) {
                throw new JiraSetupException("The password was incorrect or the user '" + username + "' is not a " + "system administrator in the specified JIRA server.");
            }
        }
        catch (ResponseException e2) {
            throw new JiraSetupException("An exception occurred whilst checking the specified JIRA user credentials", e2);
        }
    }

    private ApplicationLink createReciprocatedApplicationLink(URI remoteRpcUrl, URI localRpcUrl, String username, String password) throws JiraSetupException {
        ApplicationLink applicationLink;
        try {
            this.applicationLinkService.createReciprocalLink((URI)Preconditions.checkNotNull((Object)remoteRpcUrl, (Object)"remoteRpcUrl"), (URI)Preconditions.checkNotNull((Object)localRpcUrl, (Object)"localRpcUrl"), (String)Preconditions.checkNotNull((Object)username, (Object)"username"), (String)Preconditions.checkNotNull((Object)password, (Object)"password"));
        }
        catch (ReciprocalActionException e2) {
            throw new JiraSetupException(String.format("Failed to create application link from JIRA server at %s to this %s server at %s?. Please read the troubleshooting guide.", remoteRpcUrl, JiraSetupServiceImpl.getDownloadedProductName(), localRpcUrl), e2);
        }
        JiraApplicationType jiraType = (JiraApplicationType)this.typeAccessor.getApplicationType(JiraApplicationType.class);
        if (jiraType == null) {
            throw new JiraSetupException("Failed to load the application type: " + JiraApplicationType.class + ". " + "Have you disabled some modules of the Application Links plugin?");
        }
        try {
            ApplicationLinkDetails linkDetails = ApplicationLinkDetails.builder().rpcUrl(remoteRpcUrl).displayUrl(remoteRpcUrl).isPrimary(true).name(JiraSetupServiceImpl.generateLinkName(remoteRpcUrl)).build();
            applicationLink = this.applicationLinkService.createApplicationLink((com.atlassian.applinks.api.ApplicationType)jiraType, linkDetails);
        }
        catch (ManifestNotFoundException e3) {
            throw new JiraSetupException("Failed to retrieve manifest from the remote JIRA server. Is your JIRA server running and accessible from the server that FishEye is installed on?", e3);
        }
        Logs.APP_LOG.debug((Object)("Created a reciprocal link to jira instance: localUrl=" + localRpcUrl + ", remoteUrl=" + remoteRpcUrl));
        return applicationLink;
    }

    private void authenticateApplicationLink(ApplicationLink applicationLink, String username, String password, URI localRpcUrl) throws JiraSetupException {
        AuthenticationScenario authenticationScenario = new AuthenticationScenario(){

            public boolean isCommonUserBase() {
                return true;
            }

            public boolean isTrusted() {
                return true;
            }
        };
        try {
            this.fisheyeAuthenticationListener.muteFailureLogging();
            this.applicationLinkService.configureAuthenticationForApplicationLink(applicationLink, authenticationScenario, username, password);
            Logs.APP_LOG.debug((Object)"Authenticated application link");
        }
        catch (AuthenticationConfigurationException e2) {
            throw new JiraSetupException(String.format("Failed to authenticate application link between JIRA server at %s to this %s server at %s?. Please read the troubleshooting guide.", applicationLink.getRpcUrl(), JiraSetupServiceImpl.getDownloadedProductName(), localRpcUrl), e2);
        }
        finally {
            this.fisheyeAuthenticationListener.unmuteFailureLogging();
        }
    }

    private CrowdApplicationEntity createFishEyeApplicationInCrowd(ApplicationLink applicationLink, String username, String password) throws JiraSetupException {
        ApplicationLinkRequest request;
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory(Anonymous.class);
        try {
            request = requestFactory.createRequest(Request.MethodType.POST, "rest/appmanagement/1/application?include-request-address=true");
        }
        catch (CredentialsRequiredException e2) {
            throw new IllegalStateException("Anonymous authentication provider should never throw CredentialsRequiredException", e2);
        }
        request.addBasicAuthentication(applicationLink.getRpcUrl().getHost(), username, password);
        CrowdApplicationEntity applicationEntity = this.createApplicationEntity();
        request.setEntity((Object)applicationEntity);
        CrowdResult crowdResult = this.executeRequest(request);
        if (!crowdResult.isOk()) {
            throw new JiraSetupException(crowdResult.message, crowdResult.exception);
        }
        Logs.APP_LOG.debug((Object)("Created " + JiraSetupServiceImpl.getDownloadedProductName() + " application in Crowd"));
        return applicationEntity;
    }

    private CrowdApplicationEntity createApplicationEntity() {
        ApplicationType type = AppConfig.isCrucibleOnly() ? ApplicationType.CRUCIBLE : ApplicationType.FISHEYE;
        String appname = this.generateName(type);
        String password = DefaultSecureTokenGenerator.getInstance().generateToken();
        String description = "Automatically created by the setup of " + type.getDisplayName() + " on " + SimpleDateFormat.getDateInstance().format(new Date());
        return new CrowdApplicationEntity(type, appname, password, description, true);
    }

    private String generateName(ApplicationType type) {
        ApplicationId id = this.hostApplication.getId();
        URI url = this.hostApplication.getBaseUrl();
        return type.getDisplayName() + " - " + StringUtils.defaultString((String)url.getHost()) + " - " + id;
    }

    private CrowdResult executeRequest(ApplicationLinkRequest request) {
        try {
            return (CrowdResult)request.execute((ApplicationLinkResponseHandler)new ApplicationLinkResponseHandler<CrowdResult>(){

                public CrowdResult credentialsRequired(Response response) {
                    throw new IllegalStateException("Anonymous authentication provider should never invoke ApplicationLinkResponseHandler#credentialsRequired()");
                }

                public CrowdResult handle(Response response) throws ResponseException {
                    if (!response.isSuccessful()) {
                        return new CrowdResult(CrowdResultType.NOT_20x, String.format("Failed to register FishEye configuration in JIRA for shared user management. Received: %s %s", response.getStatusCode(), response.getStatusText()), null);
                    }
                    return new CrowdResult(CrowdResultType.OK, null, null);
                }
            });
        }
        catch (ResponseException e2) {
            return new CrowdResult(CrowdResultType.BAD_RESPONSE, String.format("Failed to register FishEye configuration in JIRA for shared user management. An exception occurred whilst communicating with JIRA: %s", new Object[]{e2}), (Exception)((Object)e2));
        }
    }

    private void setupCrowdAuthentication(URI url, String applicationName, String password) {
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder();
        builder.setActive(true);
        builder.setName("JIRA Server");
        builder.setImplementationClass(RemoteCrowdDirectory.class.getName());
        builder.setType(DirectoryType.CROWD);
        builder.setAllowedOperations((Set)ImmutableSet.of((Object)OperationType.UPDATE_USER_ATTRIBUTE, (Object)OperationType.UPDATE_GROUP_ATTRIBUTE));
        builder.setAttributes((Map)ImmutableMap.builder().put((Object)"application.name", (Object)applicationName).put((Object)"application.password", (Object)password).put((Object)"crowd.server.url", (Object)url.toString()).put((Object)"useNestedGroups", (Object)"false").put((Object)"crowd.sync.incremental.enabled", (Object)"true").put((Object)"directory.cache.synchronise.interval", (Object)"3600").build());
        this.crowdDirectoryService.addDirectory(builder.toDirectory());
        Logs.APP_LOG.info((Object)("Set up JIRA authentication for " + applicationName + " at " + url));
    }

    private void permissionGroupsForFecruAccess(Iterable<String> groupsWithFecruAccess) {
        if (!Iterables.isEmpty(groupsWithFecruAccess)) {
            groupsWithFecruAccess.forEach(g2 -> this.globalPermissionManager.setPermissionsForGroup((String)g2, GlobalPermissionType.FISHEYE_AND_CRUCIBLE));
            Logs.APP_LOG.info((Object)("Permissioned JIRA groups " + Iterables.toString(groupsWithFecruAccess) + " for " + JiraSetupServiceImpl.getDownloadedProductName() + " access"));
        }
    }

    private void setupAdminUsers(Iterable<String> adminGroups) {
        for (String group : adminGroups) {
            this.adminUserConfig.addGroup(group);
        }
        try {
            this.adminUserConfig.save();
        }
        catch (IOException e2) {
            String message = String.format("Could not save configuration after setting the admin groups %s (error: %s)", Iterables.toString(adminGroups), e2.getMessage());
            Logs.APP_LOG.error((Object)message, (Throwable)e2);
        }
    }

    private static String generateLinkName(URI remoteRpcUrl) {
        String name = "JIRA";
        if (remoteRpcUrl.getHost() != null) {
            name = remoteRpcUrl.getHost() + " " + name;
        }
        return name;
    }

    private static String getDownloadedProductName() {
        return AppConfig.isFisheyeDownload() && !AppConfig.isCrucibleDownload() ? "FishEye" : "Crucible";
    }

    private static class CrowdResult {
        final CrowdResultType type;
        final String message;
        final Exception exception;

        private CrowdResult(CrowdResultType type, String message, Exception exception) {
            this.type = type;
            this.message = message;
            this.exception = exception;
        }

        boolean isOk() {
            return this.type == CrowdResultType.OK;
        }
    }

    private static enum CrowdResultType {
        NOT_20x,
        BAD_RESPONSE,
        OK;

    }
}

