/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.jira.setup;

import com.atlassian.crowd.model.application.ApplicationType;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="application")
public class CrowdApplicationEntity {
    @XmlElement
    private String name;
    @XmlElement
    @XmlJavaTypeAdapter(value=ApplicationTypeAdapter.class)
    private ApplicationType type;
    @XmlElement
    private String description;
    @XmlElement
    private boolean active;
    @XmlElementWrapper(name="password")
    @XmlElement(name="value")
    private List<String> password;

    public CrowdApplicationEntity() {
    }

    public CrowdApplicationEntity(ApplicationType type, String name, String password, String description, boolean active) {
        this.type = type;
        this.active = active;
        this.description = description;
        this.name = name;
        this.password = Collections.singletonList(password);
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        if (this.password == null || this.password.size() != 1) {
            throw new IllegalStateException("Invalid password: " + this.password);
        }
        return this.password.get(0);
    }

    private static class ApplicationTypeAdapter
    extends XmlAdapter<String, ApplicationType> {
        private ApplicationTypeAdapter() {
        }

        public String marshal(ApplicationType v2) throws Exception {
            return v2.getDisplayName();
        }

        public ApplicationType unmarshal(String v2) throws Exception {
            for (ApplicationType type : ApplicationType.values()) {
                if (!type.getDisplayName().equals(v2)) continue;
                return type;
            }
            return null;
        }
    }
}

