/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.jira.issue;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.fecru.applinks.CredentialsRequiredMessage;
import com.atlassian.fecru.applinks.RemoteRequestUIHelper;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.issue.RemoteExceptionHandler;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import org.springframework.stereotype.Component;

@Component
public class RemoteRequestUIHelperExceptionHandler
implements RemoteExceptionHandler {
    @Override
    public void acceptCredentialsRequired(JiraServer jiraServer, CredentialsRequiredException cre) {
        RemoteRequestUIHelper.requestCredentials(new CredentialsRequiredMessage(jiraServer.getApplicationLink(), String.format("Credentials are required to retrieve issues from <strong>%s</strong>.", this.getEscapedName(jiraServer)), cre.getAuthorisationURI()));
    }

    @Override
    public void acceptException(JiraServer jiraServer, Exception e2) {
        RemoteRequestUIHelper.notifyRemoteError(jiraServer.getApplicationLink(), String.format("An error occurred contacting <strong>%s</strong>: %s", this.getEscapedName(jiraServer), ExpressionUtil.escapeString(e2.getMessage())));
    }

    private String getEscapedName(JiraServer jiraServer) {
        return ExpressionUtil.escapeString(jiraServer.getApplicationLink().getName());
    }
}

