/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.jira.issue;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.JiraServerService;
import com.atlassian.fisheye.jira.issue.QueryContext;
import com.cenqua.crucible.model.Project;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;

public class QueryContextImpl
implements QueryContext {
    private final JiraServerService jiraServerService;
    private final RepositoryHandle repository;
    private final Project project;
    private final Predicate<JiraServer> filter;
    private Iterable<JiraServer> jiraServers;

    QueryContextImpl(JiraServerService jiraServerService, RepositoryHandle repository, Project project) {
        this(jiraServerService, repository, project, null);
    }

    QueryContextImpl(JiraServerService jiraServerService, RepositoryHandle repository, Project project, Predicate<JiraServer> filter) {
        this.jiraServerService = jiraServerService;
        this.repository = repository;
        this.project = project;
        this.filter = filter;
    }

    @Override
    public boolean isGlobal() {
        return this.repository == null && this.project == null;
    }

    @Override
    public RepositoryHandle getRepository() {
        return this.repository;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public Iterable<JiraServer> getJiraServers() {
        if (this.jiraServers == null) {
            this.jiraServers = this.getProject() != null ? this.jiraServerService.getJiraServersPrioritised(this.getProject()) : (this.getRepository() != null ? this.jiraServerService.getJiraServersPrioritised(this.getRepository()) : this.jiraServerService.getJiraServers());
        }
        if (this.filter != null) {
            return Iterables.filter(this.jiraServers, this.filter);
        }
        return this.jiraServers;
    }

    @Override
    public Iterable<ApplicationId> getJiraServerIds() {
        return Iterables.transform(this.getJiraServers(), (Function)new Function<JiraServer, ApplicationId>(){

            public ApplicationId apply(JiraServer jiraServer) {
                return jiraServer.getApplicationLink().getId();
            }
        });
    }

    public static class Builder {
        private JiraServerService jiraServerService;
        private Project project;
        private RepositoryHandle repositoryHandle;
        protected Predicate<JiraServer> filter;

        public Builder(JiraServerService jiraServerService) {
            this.jiraServerService = jiraServerService;
        }

        public static Builder newInstance(JiraServerService jiraServerService) {
            return new Builder(jiraServerService);
        }

        public Builder filter(Predicate<JiraServer> filter) {
            this.filter = filter;
            return this;
        }

        public Builder project(Project project) {
            this.project = project;
            return this;
        }

        public Builder repository(RepositoryHandle repositoryHandle) {
            this.repositoryHandle = repositoryHandle;
            return this;
        }

        public QueryContext build() {
            return new QueryContextImpl(this.jiraServerService, this.repositoryHandle, this.project, this.filter);
        }
    }
}

