/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.jira.issue;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.atlassian.applinks.api.event.ApplicationLinkEvent;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.jira.JiraIssue;
import com.atlassian.fisheye.jira.JiraIssueUtil;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.JiraServerService;
import com.atlassian.fisheye.jira.OauthRequestsIgnoredException;
import com.atlassian.fisheye.jira.RemoteJiraException;
import com.atlassian.fisheye.jira.issue.JiraIssueService;
import com.atlassian.fisheye.jira.issue.QueryContext;
import com.atlassian.fisheye.jira.issue.QueryContextImpl;
import com.atlassian.fisheye.jira.issue.RemoteExceptionHandler;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.UserAppLink;
import com.cenqua.crucible.model.managers.UserAppLinkManager;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins(value=JiraIssueService.class)
public class JiraIssueServiceImpl
implements JiraIssueService {
    private final EffectiveUserProvider userProvider;
    private final JiraServerService jiraServerService;
    private final UserAppLinkManager userAppLinkManager;
    private final RemoteExceptionHandler defaultRemoteExceptionHandler;
    private final EntityLinkService entityLinkService;

    @Autowired
    public JiraIssueServiceImpl(EffectiveUserProvider effectiveUserProvider, JiraServerService jiraServerService, UserAppLinkManager userAppLinkManager, EventPublisher eventPublisher, RemoteExceptionHandler remoteExceptionHandler, EntityLinkService entityLinkService) {
        this.userProvider = effectiveUserProvider;
        this.jiraServerService = jiraServerService;
        this.userAppLinkManager = userAppLinkManager;
        this.defaultRemoteExceptionHandler = remoteExceptionHandler;
        this.entityLinkService = entityLinkService;
        eventPublisher.register((Object)this);
    }

    private QueryContext getQueryContext() {
        return QueryContextImpl.Builder.newInstance(this.jiraServerService).build();
    }

    @Override
    public JiraIssue getJiraIssue(String issueKey) {
        return this.getJiraIssue(issueKey, this.getQueryContext(), this.defaultRemoteExceptionHandler);
    }

    @Override
    public JiraIssue getJiraIssue(String issueKey, QueryContext context) {
        return this.getJiraIssue(issueKey, context, this.defaultRemoteExceptionHandler);
    }

    @Override
    public JiraIssue getJiraIssue(String issueKey, RemoteExceptionHandler exceptionHandler) {
        return this.getJiraIssue(issueKey, this.getQueryContext(), exceptionHandler);
    }

    @Override
    public JiraIssue getJiraIssue(String issueKey, QueryContext context, final RemoteExceptionHandler exceptionHandler) {
        Preconditions.checkNotNull((Object)issueKey, (Object)"issueKey");
        Preconditions.checkNotNull((Object)context, (Object)"context");
        Preconditions.checkNotNull((Object)exceptionHandler, (Object)"exceptionHandler");
        final MutableBoolean stop = new MutableBoolean(false);
        RemoteExceptionHandler handler = new RemoteExceptionHandler(){

            @Override
            public void acceptCredentialsRequired(JiraServer jiraServer, CredentialsRequiredException cre) {
                exceptionHandler.acceptCredentialsRequired(jiraServer, cre);
                stop.setValue(true);
            }

            @Override
            public void acceptException(JiraServer jiraServer, Exception e2) {
                exceptionHandler.acceptException(jiraServer, e2);
            }
        };
        for (JiraServer jiraServer : context.getJiraServers()) {
            JiraIssue issue = this.retrieveJiraIssue(issueKey, jiraServer, handler);
            if (issue == null && !stop.booleanValue()) continue;
            return issue;
        }
        return null;
    }

    @Override
    public JiraIssue getJiraIssueAggregateExceptions(String issueKey, QueryContext context) throws RemoteJiraException {
        final AtomicReference<String> message = new AtomicReference<String>();
        JiraIssue jiraIssue = this.getJiraIssue(issueKey, context, new RemoteExceptionHandler(){

            @Override
            public void acceptCredentialsRequired(JiraServer jiraServer, CredentialsRequiredException cre) {
                String messageStr = "Your credentials for the remote JIRA server are missing or invalid. Please refresh the page.";
                message.set("Your credentials for the remote JIRA server are missing or invalid. Please refresh the page.");
            }

            @Override
            public void acceptException(JiraServer jiraServer, Exception e2) {
                if (!(e2 instanceof NotPermittedException)) {
                    if (message.get() != null) {
                        message.set("Multiple exceptions occurred whilst retrieving attempting to retrieve the specified JIRA issue, see logs for details.");
                    } else {
                        message.set(e2.getMessage());
                    }
                }
            }
        });
        if (jiraIssue == null && message.get() == null) {
            message.set("Couldn't find JIRA issue with key " + issueKey);
        }
        if (jiraIssue == null) {
            throw new RemoteJiraException((String)message.get());
        }
        return jiraIssue;
    }

    @EventListener
    public void onApplicationLinkEvent(ApplicationLinkEvent event) {
        this.flushCache();
    }

    private JiraIssue retrieveJiraIssue(String issueKey, JiraServer jiraServer, RemoteExceptionHandler exceptionHandler) {
        UserAppLink userAppLink;
        Preconditions.checkNotNull((Object)issueKey);
        Preconditions.checkNotNull((Object)jiraServer);
        FecruUser user = this.userProvider.getEffectiveUser();
        if (user != null && (userAppLink = this.userAppLinkManager.getUserAppLink(user, jiraServer.getApplicationLink())) != null && userAppLink.isIgnore()) {
            exceptionHandler.acceptException(jiraServer, new OauthRequestsIgnoredException(issueKey, jiraServer.getApplicationLink().getName(), jiraServer.getApplicationLink().getDisplayUrl()));
            return null;
        }
        JiraIssue issue = null;
        try {
            issue = jiraServer.getIssue(issueKey);
        }
        catch (CredentialsRequiredException cre) {
            exceptionHandler.acceptCredentialsRequired(jiraServer, cre);
            this.logException((Exception)((Object)cre), issueKey, jiraServer);
        }
        catch (Exception e2) {
            exceptionHandler.acceptException(jiraServer, e2);
            this.logException(e2, issueKey, jiraServer);
        }
        return issue;
    }

    private void logException(Exception e2, String issueKey, JiraServer jiraServer) {
        Logs.APP_LOG.debug((Object)this.logMessage(issueKey, jiraServer), (Throwable)e2);
    }

    private String logMessage(String issueKey, JiraServer jiraServer) {
        return "Error retrieving issue '" + issueKey + "' from JIRA server at " + jiraServer.getUrlForIssue(issueKey);
    }

    @Deprecated
    public void flushCache() {
    }

    @Override
    @Deprecated
    public void markAsStale(String issueKey) {
    }

    @Override
    public String getJiraIssueUrl(String issueKey, Project project) {
        Option<String> jiraProjectKey;
        if (issueKey != null && (jiraProjectKey = JiraIssueUtil.getProjectKey(issueKey)).isDefined()) {
            String projectKey = (String)jiraProjectKey.get();
            for (EntityLink link : this.entityLinkService.getEntityLinks((Object)project, JiraProjectEntityType.class)) {
                if (!link.getKey().equals(projectKey)) continue;
                return this.jiraServerService.getJiraServer(link.getApplicationLink().getId()).getUrlForIssue(issueKey);
            }
        }
        return null;
    }

    @Override
    public Iterable<Project> findLinkedCrucibleProjects(Iterable<Project> projects, final String projectKey) {
        return Iterables.filter(projects, (Predicate)new Predicate<Project>(){

            public boolean apply(Project project) {
                Iterable projectLinks = JiraIssueServiceImpl.this.entityLinkService.getEntityLinks((Object)project, JiraProjectEntityType.class);
                EntityLink entityLink = (EntityLink)Iterables.find((Iterable)projectLinks, (Predicate)new Predicate<EntityLink>(){

                    public boolean apply(EntityLink link) {
                        return link.getKey().equals(projectKey);
                    }
                }, null);
                return entityLink != null;
            }
        });
    }
}

