/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.jira.applinks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleProjectEntityType;
import com.atlassian.applinks.api.application.fecru.FishEyeRepositoryEntityType;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.atlassian.applinks.api.auth.types.TrustedAppsAuthenticationProvider;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.link.MutatingEntityLinkService;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.fisheye.jira.JiraServer;
import com.atlassian.fisheye.jira.JiraServerService;
import com.atlassian.fisheye.jira.applinks.ApplicationLinkHelper;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.JiraCrucibleMappingType;
import com.cenqua.fisheye.config1.JiraKeyType;
import com.cenqua.fisheye.config1.JiraProjectMappingType;
import com.cenqua.fisheye.config1.JiraRepositoryMappingType;
import com.cenqua.fisheye.config1.JiraServerType;
import com.cenqua.fisheye.config1.JiraServersType;
import com.cenqua.fisheye.config1.JiraSubtask;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraUALUpgrader {
    private static final String APPLINKS_PLUGIN_KEY = "com.atlassian.applinks.applinks-plugin";
    private final ApplicationLinkHelper linkHelper;
    private final MutatingApplicationLinkService applicationLinkService;
    private final MutatingEntityLinkService entityLinkService;
    private final JiraServerService jiraServerService;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final TypeAccessor typeAccessor;
    private final RootConfig rootConfig;

    @Autowired
    public JiraUALUpgrader(MutatingApplicationLinkService applicationLinkService, MutatingEntityLinkService entityLinkService, AuthenticationConfigurationManager authenticationConfigurationManager, PluginEventManager pluginEventManager, TypeAccessor typeAccessor, JiraServerService jiraServerService, ApplicationLinkHelper linkHelper, RootConfig rootConfig) {
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.applicationLinkService = applicationLinkService;
        this.entityLinkService = entityLinkService;
        this.typeAccessor = typeAccessor;
        this.jiraServerService = jiraServerService;
        this.linkHelper = linkHelper;
        this.rootConfig = rootConfig;
        pluginEventManager.register((Object)this);
    }

    @PluginEventListener
    public void onPluginEnable(PluginEnabledEvent enabledEvent) {
        if (APPLINKS_PLUGIN_KEY.equals(enabledEvent.getPlugin().getKey())) {
            this.migrateJIRAServers();
        }
    }

    private void migrateJIRAServers() {
        if (this.rootConfig.getConfig().isSetJiraServers()) {
            JiraServersType serversElement = this.rootConfig.getConfig().getJiraServers();
            JiraServerType[] servers = serversElement.getJiraServerArray();
            for (int i2 = 0; i2 < servers.length; ++i2) {
                try {
                    String name = servers[i2].getName();
                    this.migrate(servers[i2]);
                    serversElement.removeJiraServer(i2);
                    Logs.APP_LOG.info((Object)String.format("Promoted JIRA server \"%s\" to an Application Link.", name));
                    continue;
                }
                catch (Exception e2) {
                    Logs.APP_LOG.error((Object)"Unable to migrate JIRA server record found in config.xml into an Application Link.", (Throwable)e2);
                }
            }
            if (serversElement.sizeOfJiraServerArray() == 0) {
                this.rootConfig.getConfig().unsetJiraServers();
            }
            try {
                this.rootConfig.saveConfig();
            }
            catch (IOException ioe) {
                Logs.APP_LOG.error((Object)("Error saving updated JIRA server configuration: " + ioe.getMessage()), (Throwable)ioe);
            }
        }
    }

    private URI toURI(String uri) throws URISyntaxException {
        return StringUtils.isBlank((String)uri) ? null : new URI(uri);
    }

    private void migrate(JiraServerType serverType) throws URISyntaxException, TypeNotInstalledException {
        String displayUrl;
        String rpcUrl = serverType.getRpcUrl();
        ApplicationId applicationId = this.linkHelper.getJiraApplicationId(this.toURI(StringUtils.defaultIfEmpty((String)rpcUrl, (String)(displayUrl = serverType.getUrl()))));
        if (this.applicationLinkService.getApplicationLink(applicationId) == null) {
            MutableApplicationLink applicationLink = this.applicationLinkService.addApplicationLink(applicationId, this.typeAccessor.getApplicationType(JiraApplicationType.class), ApplicationLinkDetails.builder().name(serverType.getName()).displayUrl(this.toURI(displayUrl)).rpcUrl(this.toURI(rpcUrl)).build());
            this.configureApplicationLink(serverType, (ApplicationLink)applicationLink);
        } else {
            Logs.APP_LOG.info((Object)String.format("An Application Link for JIRA server \"%s\" already exists (%s). Skipping migration.", serverType.getName(), applicationId.toString()));
        }
    }

    private void configureApplicationLink(JiraServerType oldServer, ApplicationLink applicationLink) {
        JiraServer newServer = this.jiraServerService.getJiraServer(applicationLink.getId());
        newServer.setAllowedUnassigned(oldServer.getAllowUnassigned());
        newServer.setActivityItemProvider(oldServer.getActivityItemProvider());
        this.migrateAuthenticationConfiguration(oldServer, newServer, applicationLink);
        this.migrateSubtaskConfiguration(oldServer, newServer);
        if (oldServer.isSetJiraMappings()) {
            this.migrateRepositoryMapping(oldServer.getJiraMappings(), applicationLink);
            this.migrateProjectMapping(oldServer.getJiraMappings(), applicationLink);
        }
    }

    private void migrateSubtaskConfiguration(JiraServerType oldServer, JiraServer newServer) {
        if (oldServer.isSetDefaultJiraSubtask()) {
            JiraSubtask jiraSubtask = oldServer.getDefaultJiraSubtask();
            final long subtaskId = jiraSubtask.getSubtaskId();
            final long subtaskResolutionActionId = jiraSubtask.getSubtaskResolutionActionId();
            final long subtaskResolutionId = jiraSubtask.getSubtaskResolutionId();
            newServer.setSubtaskConfiguration(new JiraServer.SubtaskConfiguration(){

                @Override
                public Long getSubtaskId() {
                    return subtaskId;
                }

                @Override
                public Long getSubtaskResolutionActionId() {
                    return subtaskResolutionActionId;
                }

                @Override
                public Long getSubtaskResolutionId() {
                    return subtaskResolutionId;
                }
            });
        }
    }

    private void migrateAuthenticationConfiguration(JiraServerType oldServer, JiraServer newServer, ApplicationLink applicationLink) {
        if (oldServer.getUsesTrustedApps()) {
            this.authenticationConfigurationManager.registerProvider(applicationLink.getId(), TrustedAppsAuthenticationProvider.class, (Map)ImmutableMap.of());
        }
    }

    private void migrateRepositoryMapping(JiraProjectMappingType jiraProjectMapping, ApplicationLink applicationLink) {
        for (JiraRepositoryMappingType repMapping : jiraProjectMapping.getRepositoryArray()) {
            for (JiraKeyType jiraKey : repMapping.getJiraKeyArray()) {
                this.entityLinkService.addEntityLink(repMapping.getName(), FishEyeRepositoryEntityType.class, this.createEntityLink(applicationLink, jiraKey));
            }
        }
    }

    private void migrateProjectMapping(JiraProjectMappingType jiraProjectMapping, ApplicationLink applicationLink) {
        for (JiraCrucibleMappingType projectMapping : jiraProjectMapping.getCrucibleProjectArray()) {
            for (JiraKeyType jiraKey : projectMapping.getJiraKeyArray()) {
                this.entityLinkService.addEntityLink(projectMapping.getProject(), FishEyeCrucibleProjectEntityType.class, this.createEntityLink(applicationLink, jiraKey));
            }
        }
    }

    private EntityLink createEntityLink(ApplicationLink applicationLink, JiraKeyType jiraKey) {
        return this.entityLinkService.getEntityLinkBuilderFactory().builder().applicationLink(applicationLink).key(jiraKey.getKey()).name(jiraKey.getName()).type(this.typeAccessor.getEntityType(JiraProjectEntityType.class)).build();
    }
}

